/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface;

import java.awt.event.ActionEvent;
import vmm.actions.ActionList;
import vmm.actions.ActionRadioGroup;
import vmm.actions.ToggleAction;
import vmm.core.Exhibit;
import vmm.core.I18n;
import vmm.core.VMMSave;
import vmm.core3D.View3DLit;
import vmm.surface.Surface;

public class SurfaceView
extends View3DLit {
    protected ToggleAction omitULineAction = new ToggleAction(I18n.tr("vmm.surface.Surface.command.OmitUGridLines")){

        public void actionPerformed(ActionEvent actionEvent) {
            SurfaceView.this.setShowUGridLines(!SurfaceView.this.showUGridLines);
        }
    };
    protected ToggleAction omitVLineAction = new ToggleAction(I18n.tr("vmm.surface.Surface.command.OmitVGridLines")){

        public void actionPerformed(ActionEvent actionEvent) {
            SurfaceView.this.setShowVGridLines(!SurfaceView.this.showVGridLines);
        }
    };
    @VMMSave
    private boolean showUGridLines = true;
    @VMMSave
    private boolean showVGridLines = true;
    protected ActionRadioGroup gridSpacingSelect = new ActionRadioGroup(new String[]{I18n.tr("vmm.surface.Surface.command.GridSpacing.0"), I18n.tr("vmm.surface.Surface.command.GridSpacing.1"), I18n.tr("vmm.surface.Surface.command.GridSpacing.2"), I18n.tr("vmm.surface.Surface.command.GridSpacing.3"), I18n.tr("vmm.surface.Surface.command.GridSpacing.4"), I18n.tr("vmm.surface.Surface.command.GridSpacing.5")}){

        public void optionSelected(int n) {
            SurfaceView.this.setGridSpacing(SurfaceView.this.standardGridSpacings[n]);
        }
    };
    @VMMSave
    private int gridSpacing;
    private int[] standardGridSpacings = new int[]{1, 2, 3, 6, 12, 0};

    public SurfaceView() {
        this.setGridSpacing(6);
        this.setAntialiased(true);
    }

    public void setGridSpacing(int n) {
        if (n < 0) {
            n = 0;
        }
        if (this.gridSpacing == n) {
            return;
        }
        this.gridSpacing = n;
        for (int i = 0; i < this.standardGridSpacings.length; ++i) {
            if (n != this.standardGridSpacings[i]) continue;
            this.gridSpacingSelect.setSelectedIndex(i);
            break;
        }
        this.forceRedraw();
    }

    public int getGridSpacing() {
        return this.gridSpacing;
    }

    public boolean getShowUGridLines() {
        return this.showUGridLines;
    }

    public void setShowUGridLines(boolean bl) {
        if (this.showUGridLines != bl) {
            this.showUGridLines = bl;
            this.omitULineAction.putValue("ToggleStatus", new Boolean(!bl));
            this.forceRedraw();
        }
    }

    public boolean getShowVGridLines() {
        return this.showVGridLines;
    }

    public void setShowVGridLines(boolean bl) {
        if (this.showVGridLines != bl) {
            this.showVGridLines = bl;
            this.omitVLineAction.putValue("ToggleStatus", new Boolean(!bl));
            this.forceRedraw();
        }
    }

    public ActionList getActions() {
        ActionList actionList = super.getActions();
        ActionList actionList2 = new ActionList(I18n.tr("vmm.surface.Surface.command.GridSpacing"));
        actionList2.add(this.gridSpacingSelect);
        actionList2.add(null);
        actionList2.add(this.omitULineAction);
        actionList2.add(this.omitVLineAction);
        actionList.add(actionList2);
        return actionList;
    }

    public void setExhibit(Exhibit exhibit) {
        super.setExhibit(exhibit);
        if (exhibit != null && exhibit instanceof Surface) {
            this.setOrientation(((Surface)exhibit).getDefaultOrientation());
        }
    }
}

