/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface;

import java.awt.Graphics2D;
import vmm.core.Animation;
import vmm.core.IntegerParam;
import vmm.core.TimerAnimation;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.Exhibit3D;
import vmm.core3D.Grid3D;
import vmm.core3D.Transform3D;
import vmm.core3D.View3D;
import vmm.core3D.View3DLit;
import vmm.surface.SurfaceView;

public abstract class Surface
extends Exhibit3D {
    protected Grid3D data;
    protected IntegerParam uPatchCount = new IntegerParam("vmm.surface.Surface.uPatchCount", 18);
    protected IntegerParam vPatchCount = new IntegerParam("vmm.surface.Surface.vPatchCount", 18);
    @VMMSave
    private int defaultOrientation = 0;

    protected abstract void createData();

    public Surface() {
        this.addParameter(this.vPatchCount);
        this.addParameter(this.uPatchCount);
        this.vPatchCount.setMinimumValueForInput(1);
        this.uPatchCount.setMinimumValueForInput(1);
        this.vPatchCount.setMaximumValueForInput(40);
        this.uPatchCount.setMaximumValueForInput(40);
        this.setFramesForMorphing(12);
        this.setUseFilmstripForMorphing(true);
    }

    public int getDefaultOrientation() {
        return this.defaultOrientation;
    }

    public void setDefaultOrientation(int n) {
        if (n != this.defaultOrientation && (n == 0 || n == 2 || n == 1)) {
            this.defaultOrientation = n;
        }
    }

    public View getDefaultView() {
        SurfaceView surfaceView = new SurfaceView();
        return surfaceView;
    }

    public Animation getBuildAnimation(View view) {
        if (!(view instanceof View3DLit)) {
            return null;
        }
        if (((View3DLit)view).getRenderingStyle() == 0) {
            return null;
        }
        final View3DLit view3DLit = (View3DLit)view;
        return new TimerAnimation(0, 20){
            private double percentDrawn;
            private double batchSize;
            {
                super(n, n2);
                this.batchSize = 0.02001;
            }

            protected void drawFrame() {
                if (this.percentDrawn > 1.0) {
                    this.cancel();
                    return;
                }
                if (!view3DLit.beginDrawToOffscreenImage()) {
                    return;
                }
                if (view3DLit instanceof SurfaceView) {
                    SurfaceView surfaceView = (SurfaceView)view3DLit;
                    Surface.this.data.setUCurveIncrement(surfaceView.getShowUGridLines() ? surfaceView.getGridSpacing() : 0);
                    Surface.this.data.setVCurveIncrement(surfaceView.getShowVGridLines() ? surfaceView.getGridSpacing() : 0);
                }
                view3DLit.drawSurface(Surface.this.data, this.percentDrawn, this.percentDrawn + this.batchSize);
                view3DLit.endDrawToOffscreenImage();
                view3DLit.getDisplay().repaint();
                this.percentDrawn += this.batchSize;
            }
        };
    }

    protected void computeDrawData3D(View3D view3D, boolean bl, Transform3D transform3D, Transform3D transform3D2) {
        if (bl) {
            this.createData();
        }
    }

    protected void doDraw3D(Graphics2D graphics2D, View3D view3D, Transform3D transform3D) {
        if (view3D instanceof SurfaceView) {
            SurfaceView surfaceView = (SurfaceView)view3D;
            this.data.setUCurveIncrement(surfaceView.getShowUGridLines() ? surfaceView.getGridSpacing() : 0);
            this.data.setVCurveIncrement(surfaceView.getShowVGridLines() ? surfaceView.getGridSpacing() : 0);
        }
        if (view3D instanceof View3DLit) {
            ((View3DLit)view3D).drawSurface(this.data);
        } else {
            view3D.drawWireframeSurface(this.data);
        }
    }
}

