/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import java.awt.Color;
import java.util.Random;
import vmm.core.RealParamAnimateable;
import vmm.core.Transform;
import vmm.core.View;
import vmm.core3D.DotCloudSurface;
import vmm.core3D.Vector3D;
import vmm.spacecurve.parametric.SpaceCurveParametric;
import vmm.spacecurve.parametric.SphericalCurve;

public class Viviani
extends SphericalCurve {
    private RealParamAnimateable CylinderRadius;
    protected DotCloudCylinder cloudCylinder;

    public Viviani() {
        this.tResolution.setValueAndDefault(150);
        this.tmin.setValueAndDefaultFromString("-2 * pi");
        this.tmax.setValueAndDefaultFromString("2 * pi");
        this.CylinderRadius = new RealParamAnimateable("vmm.spacecurve.parametric.Viviani.CylinderRadius", 0.5, 0.1, 0.9);
        this.addParameter(this.CylinderRadius);
        this.setDefaultWindow(-1.2, 1.2, -1.2, 1.2);
        this.setDefaultViewpoint(new Vector3D(2.0, 20.0, 15.0));
        this.tubeSize.setValueAndDefault(0.2);
        this.cloudCylinder = new DotCloudCylinder();
        this.cloudCylinder.setColor(Color.red);
        this.addDecoration(this.cloudCylinder);
    }

    public View getDefaultView() {
        SpaceCurveParametric.SpaceCurveParametricView spaceCurveParametricView = (SpaceCurveParametric.SpaceCurveParametricView)super.getDefaultView();
        spaceCurveParametricView.setUseReverseCollar(true);
        return spaceCurveParametricView;
    }

    protected Vector3D value(double d) {
        double d2 = this.CylinderRadius.getValue();
        double d3 = 2.0 * Math.sqrt(d2 * (1.0 - d2)) * Math.sin(d / 2.0);
        double d4 = d2 * Math.sin(d);
        double d5 = 1.0 + d2 * (Math.cos(d) - 1.0);
        return new Vector3D(d3, d4, d5);
    }

    protected Vector3D deriv1(double d) {
        double d2 = this.CylinderRadius.getValue();
        double d3 = Math.sqrt(d2 * (1.0 - d2)) * Math.cos(d / 2.0);
        double d4 = d2 * Math.cos(d);
        double d5 = d2 * -Math.sin(d);
        return new Vector3D(d3, d4, d5);
    }

    protected Vector3D deriv2(double d) {
        double d2 = this.CylinderRadius.getValue();
        double d3 = -Math.sqrt(d2 * (1.0 - d2)) * Math.sin(d / 2.0) / 2.0;
        double d4 = -d2 * Math.sin(d);
        double d5 = -d2 * Math.cos(d);
        return new Vector3D(d3, d4, d5);
    }

    protected class DotCloudCylinder
    extends DotCloudSurface {
        private int j = 0;

        protected DotCloudCylinder() {
        }

        protected Vector3D makeRandomPixel(Random random) {
            double d = random.nextDouble() * Math.PI * 2.0;
            double d2 = random.nextDouble();
            ++this.j;
            if (this.j % 10 == 0) {
                d2 = Math.round(d2);
            }
            double d3 = d2 * 3.0 - 1.5;
            double d4 = Viviani.this.CylinderRadius.getValue();
            double d5 = 1.0 + d4 * (Math.cos(d) - 1.0);
            double d6 = d4 * Math.sin(d);
            return new Vector3D(d3, d6, d5);
        }

        public void computeDrawData(View view, boolean bl, Transform transform, Transform transform2) {
            this.j = 0;
            super.computeDrawData(view, bl, transform, transform2);
        }
    }
}

