/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import vmm.core.UserExhibit;
import vmm.core.VariableParamAnimateable;
import vmm.core3D.UserExhibit3D;
import vmm.core3D.Vector3D;
import vmm.spacecurve.parametric.SpaceCurveParametric;

public class UserSpaceCurveParametric
extends SpaceCurveParametric
implements UserExhibit3D {
    private UserExhibit3D.Support userExhibitSupport;
    private UserExhibit.FunctionInfo xOfT;
    private UserExhibit.FunctionInfo yOfT;
    private UserExhibit.FunctionInfo zOfT;

    public UserSpaceCurveParametric() {
        this.tmin.reset(-1.0);
        this.tmax.reset(1.0);
        this.tResolution.reset(300);
        this.tubeSize.reset(0.2);
        this.userExhibitSupport = new UserExhibit3D.Support(this);
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("a", 2.0, 1.3, 2.2));
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("b", 3.0, 2.3, 3.2));
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("c", 0.1, 0.0, 0.3));
        this.xOfT = this.userExhibitSupport.addRealFunction("x", "(a + c*cos(7*t)) * sin(5*pi*t)", "t");
        this.yOfT = this.userExhibitSupport.addRealFunction("y", "(a + c*cos(7*t)) * cos(5*pi*t)", "t");
        this.zOfT = this.userExhibitSupport.addRealFunction("z", "b*sin(7*pi*t)", "t");
    }

    protected Vector3D value(double d) {
        double[] dArray = new double[]{d};
        double d2 = this.xOfT.realFunctionValue(dArray);
        double d3 = this.yOfT.realFunctionValue(dArray);
        double d4 = this.zOfT.realFunctionValue(dArray);
        if (Double.isNaN(d2) || Double.isNaN(d3) || Double.isNaN(d4)) {
            return null;
        }
        return new Vector3D(d2, d3, d4);
    }

    public UserExhibit.Support getUserExhibitSupport() {
        return this.userExhibitSupport;
    }
}

