/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import vmm.core.Parameter;
import vmm.core.UserExhibit;
import vmm.core.VariableParamAnimateable;
import vmm.core3D.UserExhibit3D;
import vmm.core3D.Vector3D;
import vmm.spacecurve.parametric.SpaceCurveParametric;

public class UserSpaceCurveKappaTau
extends SpaceCurveParametric
implements UserExhibit3D {
    private UserExhibit3D.Support userExhibitSupport;
    private UserExhibit.FunctionInfo Kappa;
    private UserExhibit.FunctionInfo Tau;
    int tr;
    Vector3D startPoint;
    Vector3D P;
    Vector3D T;
    Vector3D N;
    Vector3D B;
    Vector3D[] initialFrenet;
    Vector3D[] repere;
    Vector3D[] pointSet;
    Vector3D[] helperFrame;
    boolean needsNewArray;
    Vector3D dT1;
    Vector3D dN1;
    Vector3D dB1;
    Vector3D dT2;
    Vector3D dN2;
    Vector3D dB2;
    Vector3D dT3;
    Vector3D dN3;
    Vector3D dB3;
    Vector3D dT4;
    Vector3D dN4;
    Vector3D dB4;
    Vector3D Vvv;

    public UserSpaceCurveKappaTau() {
        this.tr = this.tResolution.getValue();
        this.startPoint = new Vector3D(0.0, 0.0, 0.0);
        this.P = new Vector3D(0.0, 0.0, -1.0);
        this.T = new Vector3D(1.0, 0.0, 0.0);
        this.N = new Vector3D(0.0, 1.0, 0.0);
        this.B = new Vector3D(0.0, 0.0, 1.0);
        this.initialFrenet = new Vector3D[]{this.startPoint, this.T, this.N, this.B};
        this.repere = new Vector3D[]{this.P, this.T, this.N, this.B};
        this.pointSet = new Vector3D[this.tr + 1];
        this.helperFrame = new Vector3D[4 * (this.tr + 1)];
        this.needsNewArray = true;
        this.dT1 = new Vector3D(0.0, 0.0, 0.0);
        this.dN1 = new Vector3D(0.0, 0.0, 0.0);
        this.dB1 = new Vector3D(0.0, 0.0, 0.0);
        this.dT2 = new Vector3D(0.0, 0.0, 0.0);
        this.dN2 = new Vector3D(0.0, 0.0, 0.0);
        this.dB2 = new Vector3D(0.0, 0.0, 0.0);
        this.dT3 = new Vector3D(0.0, 0.0, 0.0);
        this.dN3 = new Vector3D(0.0, 0.0, 0.0);
        this.dB3 = new Vector3D(0.0, 0.0, 0.0);
        this.dT4 = new Vector3D(0.0, 0.0, 0.0);
        this.dN4 = new Vector3D(0.0, 0.0, 0.0);
        this.dB4 = new Vector3D(0.0, 0.0, 0.0);
        this.Vvv = new Vector3D(0.0, 0.0, 0.0);
        this.setDefaultViewpoint(new Vector3D(0.0, -16.0, -6.0));
        this.setDefaultWindow(-2.0, 2.0, -1.7, 1.7);
        this.tResolution.setValueAndDefault(300);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("4*pi");
        this.tubeSize.reset(0.1);
        this.userExhibitSupport = new UserExhibit3D.Support(this);
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("a", 2.0, 2.0, 2.0));
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("b", 0.0, 0.0, 0.0));
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("c", 0.2, 0.2, 0.2));
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("d", 2.0, 1.5, 3.5));
        this.Kappa = this.userExhibitSupport.addRealFunction("kappa", "(a + b*cos(t))", "t");
        this.Tau = this.userExhibitSupport.addRealFunction("tau", "(c + d*sin(3*t))", "t");
    }

    public void parameterChanged(Parameter parameter, Object object, Object object2) {
        super.parameterChanged(parameter, object, object2);
        this.needsNewArray = true;
    }

    protected double kappa(double d) {
        return this.Kappa.realFunctionValue(d);
    }

    protected double tau(double d) {
        return this.Tau.realFunctionValue(d);
    }

    protected Vector3D[] frenetODEstep2(double d, double d2, Vector3D[] vector3DArray, int n) {
        this.P = vector3DArray[0];
        this.T = vector3DArray[1];
        this.N = vector3DArray[2];
        this.B = vector3DArray[3];
        double d3 = d;
        double d4 = (1.0 + Math.abs(d2 - d)) * (double)n;
        double d5 = (d2 - d) / d4;
        Vector3D vector3D = new Vector3D(this.T);
        Vector3D vector3D2 = new Vector3D(this.N);
        Vector3D vector3D3 = new Vector3D(this.B);
        int n2 = 0;
        while ((double)n2 < d4) {
            vector3D = this.T.plus(this.N.times(this.kappa(d3) * d5 / 2.0));
            vector3D2 = this.N.plus(this.T.times(-this.kappa(d3) * d5 / 2.0)).plus(this.B.times(this.tau(d3) * d5 / 2.0));
            vector3D3 = this.B.plus(this.N.times(-this.tau(d3) * d5 / 2.0));
            this.P = this.P.plus(this.T.plus(vector3D.times(4.0)).times(d5 / 6.0));
            this.T = this.T.plus(vector3D2.times(this.kappa(d3 += d5 / 2.0) * d5));
            this.N = this.N.plus(vector3D.times(-this.kappa(d3) * d5)).plus(vector3D3.times(this.tau(d3) * d5));
            this.B = this.B.plus(vector3D2.times(-this.tau(d3) * d5));
            this.P = this.P.plus(this.T.times(d5 / 6.0));
            d3 += d5 / 2.0;
            ++n2;
        }
        return new Vector3D[]{this.P, this.T, this.N, this.B};
    }

    protected Vector3D[] frenetODEstep4(double d, double d2, Vector3D[] vector3DArray, int n) {
        this.P = vector3DArray[0];
        this.T = vector3DArray[1];
        this.N = vector3DArray[2];
        this.B = vector3DArray[3];
        double d3 = d;
        double d4 = Math.floor((1.0 + Math.abs(d2 - d)) * (double)n);
        double d5 = (d2 - d) / d4 / 2.0;
        d4 -= 0.0625;
        int n2 = 0;
        while ((double)n2 < d4) {
            for (int i = 1; i < 3; ++i) {
                this.dT1.assignTimes(this.kappa(d3) * d5 / 2.0, this.N);
                this.dN1.assignLinComb(-this.kappa(d3) * d5 / 2.0, this.T, this.tau(d3) * d5 / 2.0, this.B);
                this.dB1.assignTimes(-this.tau(d3) * d5 / 2.0, this.N);
                this.dT2.assignSumTimes(this.N, this.dN1, this.kappa(d3 += d5 / 2.0) * d5);
                this.dN2.assignSumTimes(this.T, this.dT1, -this.kappa(d3) * d5);
                this.Vvv.assignSumTimes(this.B, this.dB1, this.tau(d3) * d5);
                this.dN2.assignPlus(this.Vvv);
                this.dB2.assignSumTimes(this.N, this.dN1, -this.tau(d3) * d5);
                this.dT3.assignLinComb(this.kappa(d3) * d5, this.N, this.kappa(d3) * d5 / 2.0, this.dN2);
                this.dN3.assignLinComb(-this.kappa(d3) * d5, this.T, -this.kappa(d3) * d5 / 2.0, this.dT2);
                this.Vvv.assignLinComb(this.tau(d3) * d5, this.B, this.tau(d3) * d5 / 2.0, this.dB2);
                this.dN3.assignPlus(this.Vvv);
                this.dB3.assignLinComb(-this.tau(d3) * d5, this.N, -this.tau(d3) * d5 / 2.0, this.dN2);
                this.dT4.assignSumTimes(this.N, this.dN3, this.kappa(d3 += d5 / 2.0) * d5 / 2.0);
                this.dN4.assignSumTimes(this.T, this.dT3, -this.kappa(d3) * d5 / 2.0);
                this.Vvv.assignSumTimes(this.B, this.dB3, this.tau(d3) * d5 / 2.0);
                this.dN4.assignPlus(this.Vvv);
                this.dB4.assignSumTimes(this.N, this.dN3, -this.tau(d3) * d5 / 2.0);
                this.P = this.P.plus(this.T.times(d5 * (double)i * (double)i / 3.0));
                this.Vvv.assignSumTimes(this.dT1, this.dT2, this.dT3, this.dT4, 0.3333333333333333);
                this.T = this.T.plus(this.Vvv);
                this.Vvv.assignSumTimes(this.dN1, this.dN2, this.dN3, this.dN4, 0.3333333333333333);
                this.N = this.N.plus(this.Vvv);
                this.Vvv.assignSumTimes(this.dB1, this.dB2, this.dB3, this.dB4, 0.3333333333333333);
                this.B = this.B.plus(this.Vvv);
            }
            this.P.assignLinComb(1.0, d5 / 3.0, this.T);
            ++n2;
        }
        return new Vector3D[]{this.P, this.T, this.N, this.B};
    }

    private void createFrenetArray() {
        int n;
        int n2 = this.tResolution.getValue();
        double d = (this.tmax.getValue() - this.tmin.getValue()) / (double)n2;
        double d2 = this.tmin.getValue();
        this.helperFrame = new Vector3D[4 * (n2 + 1)];
        this.pointSet = new Vector3D[n2 + 1];
        this.helperFrame[0] = new Vector3D(0.0, 0.0, 0.0);
        this.helperFrame[1] = new Vector3D(1.0, 0.0, 0.0);
        this.helperFrame[2] = new Vector3D(0.0, 1.0, 0.0);
        this.helperFrame[3] = new Vector3D(0.0, 0.0, 1.0);
        this.pointSet[0] = new Vector3D(this.helperFrame[0]);
        for (n = 0; n < n2; ++n) {
            int n3;
            for (n3 = 0; n3 < 4; ++n3) {
                this.initialFrenet[n3] = this.helperFrame[n3 + 4 * n];
            }
            this.repere = this.frenetODEstep4(d2, d2 + d, this.initialFrenet, 32);
            for (n3 = 0; n3 < 4; ++n3) {
                this.helperFrame[n3 + 4 * (n + 1)] = new Vector3D(this.repere[n3]);
            }
            this.pointSet[n + 1] = this.helperFrame[4 * (n + 1)];
            d2 += d;
        }
        this.startPoint = this.getCenterOfPoints(this.pointSet, n2 + 1);
        this.startPoint.x = -this.startPoint.x;
        this.startPoint.y = -this.startPoint.y;
        this.startPoint.z = -this.startPoint.z;
        for (n = 0; n <= n2; ++n) {
            this.helperFrame[4 * n].assignPlus(this.startPoint);
        }
    }

    public Vector3D[] makeRepereMobile(double d) {
        int n = 0;
        double d2 = 0.0;
        if (this.needsNewArray) {
            this.createFrenetArray();
            this.needsNewArray = false;
        }
        n = (int)Math.round((double)this.tResolution.getValue() * (d - this.tmin.getValue()) / (this.tmax.getValue() - this.tmin.getValue()));
        d2 = this.tmin.getValue() + (double)n * (this.tmax.getValue() - this.tmin.getValue()) / (double)this.tResolution.getValue();
        for (int i = 0; i < 4; ++i) {
            this.initialFrenet[i] = this.helperFrame[i + 4 * n];
        }
        this.repere = this.frenetODEstep4(d2, d, this.initialFrenet, 16);
        return this.repere;
    }

    protected Vector3D value(double d) {
        int n = 0;
        double d2 = 0.0;
        if (this.needsNewArray) {
            this.createFrenetArray();
            this.needsNewArray = false;
        }
        n = (int)Math.round((double)this.tResolution.getValue() * (d - this.tmin.getValue()) / (this.tmax.getValue() - this.tmin.getValue()));
        d2 = this.tmin.getValue() + (double)n * (this.tmax.getValue() - this.tmin.getValue()) / (double)this.tResolution.getValue();
        for (int i = 0; i < 4; ++i) {
            this.initialFrenet[i] = this.helperFrame[i + 4 * n];
        }
        Vector3D vector3D = this.frenetODEstep4(d2, d, this.initialFrenet, 16)[0];
        return vector3D;
    }

    public UserExhibit.Support getUserExhibitSupport() {
        return this.userExhibitSupport;
    }
}

