/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Random;
import vmm.actions.ActionList;
import vmm.actions.ToggleAction;
import vmm.core.I18n;
import vmm.core.RealParamAnimateable;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.DotCloudSurface;
import vmm.core3D.Vector3D;
import vmm.spacecurve.parametric.SpaceCurveParametric;

public class TorusKnot
extends SpaceCurveParametric {
    RealParamAnimateable aa = new RealParamAnimateable("vmm.spacecurve.parametric.TorusKnot.aa", 6.25, 6.25, 6.25);
    RealParamAnimateable bb = new RealParamAnimateable("vmm.spacecurve.parametric.TorusKnot.bb", 3.0, 2.0, 3.5);
    RealParamAnimateable cc = new RealParamAnimateable("vmm.spacecurve.parametric.TorusKnot.cc", 3.0, 5.0, 2.0);
    RealParamAnimateable dd = new RealParamAnimateable("vmm.spacecurve.parametric.TorusKnot.dd", 5.0, 5.0, 5.0);
    RealParamAnimateable ee = new RealParamAnimateable("vmm.spacecurve.parametric.TorusKnot.ee", 2.0, 2.0, 2.0);

    public TorusKnot() {
        this.setDefaultViewpoint(new Vector3D(30.0, 0.0, 10.0));
        this.setDefaultWindow(-12.0, 12.0, -10.0, 10.0);
        this.tResolution.setValueAndDefault(300);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("2 * pi");
        this.addParameter(this.ee);
        this.addParameter(this.dd);
        this.addParameter(this.cc);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
        this.tubeSize.setValueAndDefault(1.0);
    }

    protected Vector3D value(double d) {
        double d2 = this.aa.getValue();
        double d3 = this.bb.getValue();
        double d4 = this.cc.getValue();
        double d5 = this.dd.getValue();
        double d6 = this.ee.getValue();
        d5 = (int)d5;
        d6 = (int)d6;
        double d7 = (d2 + d3 * Math.cos(d5 * d)) * Math.cos(d6 * d);
        double d8 = (d2 + d3 * Math.cos(d5 * d)) * Math.sin(d6 * d);
        double d9 = d4 * Math.sin(d5 * d);
        return new Vector3D(d7, d8, d9);
    }

    public View getDefaultView() {
        TorusKnotView torusKnotView = new TorusKnotView();
        torusKnotView.setName("vmm.spacecurve.parametric.SpaceCurveParametric.view.ViewAsCurve");
        return torusKnotView;
    }

    private class DotCloudTorus
    extends DotCloudSurface {
        private DotCloudTorus() {
        }

        protected Vector3D makeRandomPixel(Random random) {
            double d = TorusKnot.this.aa.getValue();
            double d2 = TorusKnot.this.bb.getValue();
            double d3 = TorusKnot.this.cc.getValue();
            double d4 = random.nextDouble() * Math.PI * 2.0;
            double d5 = random.nextDouble() * Math.PI * 2.0;
            double d6 = (d + d2 * Math.cos(d4)) * Math.cos(d5);
            double d7 = (d + d2 * Math.cos(d4)) * Math.sin(d5);
            double d8 = d3 * Math.sin(d4);
            return new Vector3D(d6, d7, d8);
        }
    }

    public class TorusKnotView
    extends SpaceCurveParametric.SpaceCurveParametricView {
        @VMMSave
        private boolean showDotCloudTorus;
        private ToggleAction showCloudTorusOption = new ToggleAction(I18n.tr("vmm.spacecurve.parametric.TorusKnot.ShowCloudTorus")){

            public void actionPerformed(ActionEvent actionEvent) {
                TorusKnotView.this.setShowDotCloudTorus(this.getState());
            }
        };
        private DotCloudTorus cloudTorus;

        public void setShowDotCloudTorus(boolean bl) {
            if (bl != this.showDotCloudTorus) {
                this.showDotCloudTorus = bl;
                this.showCloudTorusOption.setState(bl);
                if (bl) {
                    if (this.cloudTorus == null) {
                        this.cloudTorus = new DotCloudTorus();
                        this.cloudTorus.setColor(Color.blue);
                    }
                    this.addDecoration(this.cloudTorus);
                } else {
                    this.removeDecoration(this.cloudTorus);
                }
            }
        }

        public ActionList getActions() {
            ActionList actionList = super.getActions();
            actionList.add(this.showCloudTorusOption);
            return actionList;
        }

        public boolean getShowDotCloudTorus() {
            return this.showDotCloudTorus;
        }
    }
}

