/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.spacecurve.parametric.SphericalCurve;

public class SphericalEllipse
extends SphericalCurve {
    RealParamAnimateable aa = new RealParamAnimateable("vmm.spacecurve.parametric.SphericalEllipse.aa", 0.6, 0.6, 0.6);
    RealParamAnimateable ee = new RealParamAnimateable("vmm.spacecurve.parametric.SphericalEllipse.ee", 0.9, 0.4, 1.15);

    public SphericalEllipse() {
        this.setDefaultViewpoint(new Vector3D(10.0, 0.0, 30.0));
        this.setDefaultWindow(-1.1, 1.1, -1.1, 1.1);
        this.tResolution.setValueAndDefault(200);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("2 * pi");
        this.addParameter(this.ee);
        this.addParameter(this.aa);
        this.tubeSize.setValueAndDefault(0.1);
    }

    protected Vector3D value(double d) {
        double d2 = this.aa.getValue();
        double d3 = this.ee.getValue();
        Vector3D vector3D = new Vector3D(0.0, 0.0, 1.0);
        Vector3D vector3D2 = new Vector3D(Math.sin(d3), 0.0, Math.cos(d3));
        Vector3D vector3D3 = this.geographicCoordinates(2.0 * d2, d);
        Vector3D vector3D4 = vector3D3.minus(vector3D2);
        vector3D4.normalize();
        Vector3D vector3D5 = vector3D2.minus(vector3D3);
        double d4 = vector3D5.dot(vector3D3.minus(vector3D));
        double d5 = vector3D5.dot(vector3D3);
        double d6 = d5 / d4;
        Vector3D vector3D6 = vector3D.linComb(d6, 1.0 - d6, vector3D3);
        if (2.0 * d2 > Math.PI) {
            vector3D6.negate();
        }
        vector3D6.normalize();
        return new Vector3D(vector3D6);
    }
}

