/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.spacecurve.parametric.SphericalCurve;

public class SphericalCycloid
extends SphericalCurve {
    RealParamAnimateable aa = new RealParamAnimateable("vmm.spacecurve.parametric.SphericalCycloid.aa", 0.2, 0.2, 0.2);
    RealParamAnimateable bb = new RealParamAnimateable("vmm.spacecurve.parametric.SphericalCycloid.bb", 2.0, -1.0, 3.0);
    RealParamAnimateable ee = new RealParamAnimateable("vmm.spacecurve.parametric.SphericalCycloid.ee", 5.0, 5.0, 5.0);

    public SphericalCycloid() {
        this.setDefaultViewpoint(new Vector3D(10.0, 0.0, 30.0));
        this.setDefaultWindow(-1.1, 1.1, -1.1, 1.1);
        this.tResolution.setValueAndDefault(200);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("2 * pi");
        this.addParameter(this.ee);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
        this.tubeSize.setValueAndDefault(0.1);
    }

    protected Vector3D value(double d) {
        double d2 = this.aa.getValue();
        double d3 = this.bb.getValue();
        double d4 = this.ee.getValue();
        d4 = (int)d4;
        double d5 = 0.0;
        if (Math.signum(d4) < 0.0) {
            d5 = Math.PI;
        }
        double d6 = Math.asin(Math.sin(Math.PI * d2) / Math.abs(d4));
        Vector3D vector3D = this.geographicCoordinates(d3 * d6, (d4 + 1.0) * d + d5);
        Vector3D vector3D2 = this.geographicCoordinates((Math.PI * d2 + Math.signum(d4) * d6) / 2.0, d);
        Vector3D vector3D3 = vector3D.reflectInAxis(vector3D2);
        return new Vector3D(vector3D3);
    }
}

