/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import java.awt.Color;
import java.util.Random;
import vmm.core.View;
import vmm.core3D.DotCloudSurface;
import vmm.core3D.Vector3D;
import vmm.spacecurve.parametric.SpaceCurveParametric;

public abstract class SphericalCurve
extends SpaceCurveParametric {
    protected DotCloudSphere cloudSphere;

    public SphericalCurve() {
        this.setDefaultWindow(-1.2, 1.2, -1.2, 1.2);
        this.setDefaultViewpoint(new Vector3D(16.0, 8.0, 19.0));
        this.cloudSphere = new DotCloudSphere();
        this.cloudSphere.setColor(Color.blue);
        this.addDecoration(this.cloudSphere);
    }

    public View getDefaultView() {
        SphericalCurveView sphericalCurveView = new SphericalCurveView();
        sphericalCurveView.setName("vmm.spacecurve.parametric.SpaceCurveParametric.view.ViewAsCurve");
        return sphericalCurveView;
    }

    public class SphericalCurveView
    extends SpaceCurveParametric.SpaceCurveParametricView {
    }

    protected class DotCloudSphere
    extends DotCloudSurface {
        protected DotCloudSphere() {
        }

        protected Vector3D makeRandomPixel(Random random) {
            double d = random.nextDouble() * Math.PI * 2.0;
            double d2 = random.nextDouble() * 2.0 - 1.0;
            double d3 = Math.sqrt(1.0 - d2 * d2);
            double d4 = d3 * Math.cos(d);
            double d5 = d3 * Math.sin(d);
            return new Vector3D(d4, d5, d2);
        }
    }
}

