/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.actions.ToggleAction;
import vmm.core.Animation;
import vmm.core.Decoration;
import vmm.core.Display;
import vmm.core.I18n;
import vmm.core.IntegerParam;
import vmm.core.RealParam;
import vmm.core.TimerAnimation;
import vmm.core.Transform;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.Grid3D;
import vmm.core3D.Transform3D;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;
import vmm.core3D.View3DLit;
import vmm.spacecurve.SpaceCurve;
import vmm.spacecurve.SpaceCurveView;
import vmm.spacecurve.parametric.RepereMobileDecoration;

public abstract class SpaceCurveParametric
extends SpaceCurve {
    protected IntegerParam tResolution;
    protected RealParam tmin = new RealParam("vmm.spacecurve.parametric.SpaceCurveParameteric.tmin", -5.0);
    protected RealParam tmax = new RealParam("vmm.spacecurve.parametric.SpaceCurveParameteric.tmax", 5.0);
    protected double[] tVals;
    protected Grid3D tube;
    protected RealParam tubeSize;
    protected IntegerParam tubeSides;

    public SpaceCurveParametric() {
        this.tResolution = new IntegerParam("vmm.spacecurve.parametric.SpaceCurveParameteric.tResolution", 200);
        this.tResolution.setMinimumValueForInput(4);
        this.tResolution.setMaximumValueForInput(2000);
        this.tubeSize = new RealParam("vmm.spacecurve.parametric.SpaceCurveParameteric.TubeSize", 0.25);
        this.tubeSize.setMinimumValueForInput(0.01);
        this.tubeSides = new IntegerParam("vmm.spacecurve.parametric.SpaceCurveParametric.TubeSides", 4);
        this.tubeSides.setMinimumValueForInput(3);
        this.tubeSides.setMaximumValueForInput(20);
        this.addParameter(this.tubeSides);
        this.addParameter(this.tubeSize);
        this.addParameter(this.tResolution);
        this.addParameter(this.tmax);
        this.addParameter(this.tmin);
        this.setFramesForMorphing(25);
        this.setUseFilmstripForMorphing(true);
    }

    protected void makePoints() {
        int n = this.tResolution.getValue();
        this.tVals = new double[n + 1];
        this.points = new Vector3D[n + 1];
        double d = this.tmin.getValue();
        double d2 = (this.tmax.getValue() - d) / (double)n;
        for (int i = 0; i <= n; ++i) {
            this.tVals[i] = d + d2 * (double)i;
            this.points[i] = this.value(this.tVals[i]);
            if (!Double.isNaN(this.points[i].x) && !Double.isInfinite(this.points[i].x) && !Double.isNaN(this.points[i].y) && !Double.isInfinite(this.points[i].y) && !Double.isNaN(this.points[i].z) && !Double.isInfinite(this.points[i].z)) continue;
            this.points[i] = null;
        }
    }

    protected Vector3D getCenterOfPoints(Vector3D[] vector3DArray, int n) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += vector3DArray[i].x;
            d2 += vector3DArray[i].y;
            d3 += vector3DArray[i].z;
        }
        return new Vector3D(d / (double)n, d2 / (double)n, d3 / (double)n);
    }

    protected abstract Vector3D value(double var1);

    protected Vector3D deriv1(double d) {
        double d2 = 5.0E-5;
        Vector3D vector3D = this.value(d + d2);
        Vector3D vector3D2 = this.value(d + 2.0 * d2);
        Vector3D vector3D3 = this.value(d - d2);
        Vector3D vector3D4 = this.value(d - 2.0 * d2);
        vector3D.x = (8.0 * vector3D.x + vector3D4.x - (vector3D2.x + 8.0 * vector3D3.x)) / (12.0 * d2);
        vector3D.y = (8.0 * vector3D.y + vector3D4.y - (vector3D2.y + 8.0 * vector3D3.y)) / (12.0 * d2);
        vector3D.z = (8.0 * vector3D.z + vector3D4.z - (vector3D2.z + 8.0 * vector3D3.z)) / (12.0 * d2);
        if (vector3D == null || vector3D2 == null || vector3D3 == null || vector3D4 == null) {
            return null;
        }
        return vector3D;
    }

    protected Vector3D deriv2(double d) {
        double d2 = 5.0E-5;
        Vector3D vector3D = this.value(d);
        Vector3D vector3D2 = this.value(d + d2);
        Vector3D vector3D3 = this.value(d + 2.0 * d2);
        Vector3D vector3D4 = this.value(d - d2);
        Vector3D vector3D5 = this.value(d - 2.0 * d2);
        if (vector3D == null || vector3D2 == null || vector3D3 == null || vector3D4 == null || vector3D5 == null) {
            return null;
        }
        vector3D.x = (16.0 * vector3D2.x + 16.0 * vector3D4.x - 30.0 * vector3D.x - vector3D3.x - vector3D5.x) / (12.0 * d2 * d2);
        vector3D.y = (16.0 * vector3D2.y + 16.0 * vector3D4.y - 30.0 * vector3D.y - vector3D3.y - vector3D5.y) / (12.0 * d2 * d2);
        vector3D.z = (16.0 * vector3D2.z + 16.0 * vector3D4.z - 30.0 * vector3D.z - vector3D3.z - vector3D5.z) / (12.0 * d2 * d2);
        return vector3D;
    }

    public Vector3D geographicCoordinates(double d, double d2) {
        double d3 = Math.sin(d) * Math.cos(d2);
        double d4 = Math.sin(d) * Math.sin(d2);
        double d5 = Math.cos(d);
        return new Vector3D(d3, d4, d5);
    }

    public double getT(int n) {
        return this.tVals[n];
    }

    public int getTResolution() {
        return this.tResolution.getValue();
    }

    public Vector3D[] makeRepereMobile(double d) {
        Vector3D vector3D = this.value(d);
        Vector3D vector3D2 = this.deriv1(d);
        Vector3D vector3D3 = this.deriv2(d);
        if (vector3D == null || vector3D2 == null || vector3D3 == null) {
            return null;
        }
        Vector3D vector3D4 = vector3D2.cross(vector3D3);
        vector3D2.normalize();
        vector3D4.normalize();
        Vector3D vector3D5 = vector3D4.cross(vector3D2);
        if (Double.isNaN(vector3D5.x) || Double.isInfinite(vector3D5.y) || Double.isNaN(vector3D5.y) || Double.isInfinite(vector3D5.y) || Double.isNaN(vector3D5.z) || Double.isInfinite(vector3D5.z)) {
            return null;
        }
        return new Vector3D[]{vector3D, vector3D2, vector3D5, vector3D4};
    }

    public View getDefaultView() {
        SpaceCurveParametricView spaceCurveParametricView = new SpaceCurveParametricView();
        spaceCurveParametricView.setName("vmm.spacecurve.parametric.SpaceCurveParametric.view.ViewAsCurve");
        return spaceCurveParametricView;
    }

    public View[] getAlternativeViews() {
        SpaceCurveParametricViewAsTube spaceCurveParametricViewAsTube = new SpaceCurveParametricViewAsTube();
        spaceCurveParametricViewAsTube.setAntialiased(true);
        spaceCurveParametricViewAsTube.setName("vmm.spacecurve.parametric.SpaceCurveParametric.view.ViewAsTube");
        return new View[]{spaceCurveParametricViewAsTube};
    }

    public ActionList getActionsForView(final View view) {
        ActionList actionList = super.getActionsForView(view);
        if (view instanceof SpaceCurveParametricView) {
            actionList.add(null);
            actionList.add(new AbstractActionVMM(I18n.tr("vmm.spacecurve.parametric.SpaceCurveParameteric.showRepereMobile")){

                public void actionPerformed(ActionEvent actionEvent) {
                    Display display = view.getDisplay();
                    display.installAnimation(new TimerAnimation(SpaceCurveParametric.this.getTResolution(), 40){
                        RepereMobileDecoration dec;
                        {
                            this.dec = new RepereMobileDecoration();
                        }

                        protected void animationEnding() {
                            view.removeDecoration(this.dec);
                        }

                        protected void animationStarting() {
                            this.dec.setCurve(SpaceCurveParametric.this);
                            view.addDecoration(this.dec);
                        }

                        protected void drawFrame() {
                            this.dec.setIndex(this.getFrameNumber());
                        }
                    });
                }
            });
            actionList.add(((SpaceCurveParametricView)view).showOsculatingCirclesAction);
            actionList.add(((SpaceCurveParametricView)view).showEvoluteToggle);
        } else if (view instanceof SpaceCurveParametricViewAsTube) {
            actionList.add(null);
            actionList.add(((SpaceCurveParametricViewAsTube)view).showGridToggle);
        }
        return actionList;
    }

    public Animation getCreateAnimation(final View view) {
        if (view == null || !(view instanceof SpaceCurveParametricView)) {
            return null;
        }
        return new TimerAnimation(75, 20){

            protected void drawFrame() {
                ((SpaceCurveParametricView)view).fractionToDraw = (double)this.frameNumber / 75.0;
                view.forceRedraw();
            }

            public void animationStarting() {
                ((SpaceCurveParametricView)view).fractionToDraw = 0.0;
            }

            public void animationEnding() {
                ((SpaceCurveParametricView)view).fractionToDraw = 1.0;
                view.forceRedraw();
            }
        };
    }

    public Animation getBuildAnimation(View view) {
        if (!(view instanceof View3DLit)) {
            return null;
        }
        if (((View3DLit)view).getRenderingStyle() == 0) {
            return null;
        }
        final View3DLit view3DLit = (View3DLit)view;
        return new TimerAnimation(0, 20){
            private double percentDrawn;
            private double batchSize;
            {
                super(n, n2);
                this.batchSize = 0.0201;
            }

            protected void drawFrame() {
                if (this.percentDrawn > 1.0) {
                    this.cancel();
                    return;
                }
                if (!view3DLit.beginDrawToOffscreenImage()) {
                    return;
                }
                view3DLit.drawSurface(SpaceCurveParametric.this.tube, this.percentDrawn, this.percentDrawn + this.batchSize);
                view3DLit.endDrawToOffscreenImage();
                view3DLit.getDisplay().repaint();
                this.percentDrawn += this.batchSize;
            }
        };
    }

    protected void computeDrawData3D(View3D view3D, boolean bl, Transform3D transform3D, Transform3D transform3D2) {
        int n;
        super.computeDrawData3D(view3D, bl, transform3D, transform3D2);
        if (this.tube == null || bl) {
            n = this.tResolution.getValue();
            int n2 = this.tubeSides.getValue();
            if (this.tube == null || this.tube.getUPatchCount() != n || this.tube.getVPatchCount() != n2) {
                this.tube = new Grid3D(n, n2, 1);
            }
            for (int i = 0; i <= n; ++i) {
                Vector3D[] vector3DArray = this.makeRepereMobile(this.tVals[i]);
                if (vector3DArray == null) {
                    for (int j = 0; j <= n2; ++j) {
                        this.tube.setVertex(i, j, null);
                    }
                    continue;
                }
                Vector3D vector3D = vector3DArray[2];
                Vector3D vector3D2 = vector3DArray[3];
                vector3D = vector3D.times(this.tubeSize.getValue() / 2.0);
                vector3D2 = vector3D2.times(this.tubeSize.getValue() / 2.0);
                for (int j = 0; j <= n2; ++j) {
                    double d = (double)(j * 2) * Math.PI / (double)n2;
                    Vector3D vector3D3 = vector3DArray[0].plus(vector3D.times(Math.cos(d))).plus(vector3D2.times(Math.sin(d)));
                    this.tube.setVertex(i, j, vector3D3);
                }
            }
        }
        n = 1;
        if (view3D instanceof SpaceCurveParametricViewAsTube) {
            n = ((SpaceCurveParametricViewAsTube)view3D).getShowGrid() ? 1 : 0;
        }
        this.tube.setUCurveIncrement(n != 0 ? 1 : 0);
        this.tube.setVCurveIncrement(n != 0 ? 1 : 0);
    }

    protected void doDraw3D(Graphics2D graphics2D, View3D view3D, Transform3D transform3D) {
        if (view3D instanceof View3DLit) {
            ((View3DLit)view3D).drawSurface(this.tube);
        } else {
            if (this.points.length == 0) {
                return;
            }
            int n = this.points.length;
            if (view3D instanceof SpaceCurveParametricView) {
                double d = ((SpaceCurveParametricView)view3D).fractionToDraw;
                if (d >= 0.0 && d < 1.0) {
                    n = (int)(d * (double)n);
                }
                if (n == 0) {
                    n = 1;
                }
            }
            boolean bl = false;
            if (view3D instanceof SpaceCurveView) {
                bl = ((SpaceCurveView)view3D).getUseReverseCollar();
            }
            view3D.drawCollaredCurve(this.points, n, bl);
        }
    }

    private class EvoluteDecoration
    extends Decoration {
        private final int POINTS_ON_CIRCLE = 180;
        private Vector3D[] evolutePoints;
        private boolean showCompleteEvolute = true;
        private int circleIndex;
        private final Color COLOR = Color.BLUE;

        private EvoluteDecoration() {
        }

        public void computeDrawData(View view, boolean bl, Transform transform, Transform transform2) {
            if (bl || this.decorationNeedsRedraw) {
                int n;
                int n2 = SpaceCurveParametric.this.getPointCount();
                if (n2 == 0) {
                    this.evolutePoints = null;
                    return;
                }
                this.evolutePoints = new Vector3D[n2];
                if (this.showCompleteEvolute) {
                    n = n2;
                } else {
                    n = this.circleIndex;
                    if (n > n2) {
                        n = n2;
                    }
                }
                for (int i = 0; i < n; ++i) {
                    this.evolutePoints[i] = this.centerOfOsculatingCircle(i);
                }
            }
        }

        public void doDraw(Graphics2D graphics2D, View view, Transform transform) {
            if (this.evolutePoints == null) {
                return;
            }
            View3D view3D = (View3D)view;
            Color color = view.getColor();
            view.setColor(view3D.getViewStyle() == 1 ? Color.LIGHT_GRAY : this.COLOR);
            if (this.showCompleteEvolute) {
                view.setStrokeSizeMultiplier(2);
                view3D.drawCurve(this.evolutePoints);
                view.setStrokeSizeMultiplier(1);
            } else {
                if (this.circleIndex >= 0 && this.circleIndex < this.evolutePoints.length) {
                    this.evolutePoints[this.circleIndex] = this.drawOsculatingCircle(view3D);
                }
                if (this.circleIndex > 0) {
                    view.setStrokeSizeMultiplier(2);
                    view3D.drawCurve(this.evolutePoints, this.circleIndex + 1);
                    view.setStrokeSizeMultiplier(1);
                }
            }
            view.setColor(color);
        }

        private Vector3D drawOsculatingCircle(View3D view3D) {
            double d = SpaceCurveParametric.this.getT(this.circleIndex);
            Vector3D vector3D = SpaceCurveParametric.this.value(d);
            Vector3D vector3D2 = SpaceCurveParametric.this.deriv1(d);
            Vector3D vector3D3 = SpaceCurveParametric.this.deriv2(d);
            if (vector3D == null || vector3D2 == null || vector3D3 == null) {
                return null;
            }
            double d2 = vector3D2.cross(vector3D3).norm() / Math.pow(vector3D2.norm(), 3.0);
            double d3 = 1.0 / d2;
            if (Double.isNaN(d3) || d3 > 10000.0) {
                return null;
            }
            Vector3D vector3D4 = vector3D2.cross(vector3D3);
            vector3D2.normalize();
            vector3D4.normalize();
            Vector3D vector3D5 = vector3D4.cross(vector3D2);
            if (Double.isNaN(vector3D5.x) || Double.isInfinite(vector3D5.y) || Double.isNaN(vector3D5.y) || Double.isInfinite(vector3D5.y) || Double.isNaN(vector3D5.z) || Double.isInfinite(vector3D5.z)) {
                return null;
            }
            vector3D5.normalize();
            Vector3D vector3D6 = vector3D5.times(d3);
            Vector3D vector3D7 = vector3D2.times(d3);
            Vector3D vector3D8 = vector3D.plus(vector3D6);
            vector3D6.negate();
            Vector3D vector3D9 = vector3D8.plus(vector3D6);
            for (int i = 1; i <= 180; ++i) {
                double d4 = Math.PI * 2 * (double)i / 180.0;
                Vector3D vector3D10 = vector3D8.plus(vector3D6.times(Math.cos(d4))).plus(vector3D7.times(Math.sin(d4)));
                view3D.drawLine(vector3D9, vector3D10);
                vector3D9 = vector3D10;
            }
            view3D.drawLine(vector3D8, vector3D);
            return vector3D8;
        }

        private Vector3D centerOfOsculatingCircle(int n) {
            double d = SpaceCurveParametric.this.getT(n);
            Vector3D vector3D = SpaceCurveParametric.this.value(d);
            Vector3D vector3D2 = SpaceCurveParametric.this.deriv1(d);
            Vector3D vector3D3 = SpaceCurveParametric.this.deriv2(d);
            if (vector3D == null || vector3D2 == null || vector3D3 == null) {
                return null;
            }
            double d2 = vector3D2.cross(vector3D3).norm() / Math.pow(vector3D2.norm(), 3.0);
            double d3 = 1.0 / d2;
            if (Double.isNaN(d3) || d3 > 10000.0) {
                return null;
            }
            Vector3D vector3D4 = vector3D2.cross(vector3D3);
            vector3D2.normalize();
            vector3D4.normalize();
            Vector3D vector3D5 = vector3D4.cross(vector3D2);
            vector3D5.normalize();
            if (Double.isNaN(vector3D5.x) || Double.isInfinite(vector3D5.y) || Double.isNaN(vector3D5.y) || Double.isInfinite(vector3D5.y) || Double.isNaN(vector3D5.z) || Double.isInfinite(vector3D5.z)) {
                return null;
            }
            Vector3D vector3D6 = vector3D.plus(vector3D5.times(d3));
            return vector3D6;
        }
    }

    public static class SpaceCurveParametricViewAsTube
    extends View3DLit {
        private ToggleAction showGridToggle = new ToggleAction(I18n.tr("vmm.spacecurve.parametric.SpaceCurveParametric.ShowTubeGrid"), true){

            public void actionPerformed(ActionEvent actionEvent) {
                SpaceCurveParametricViewAsTube.this.setShowGrid(this.getState());
            }
        };
        @VMMSave
        private boolean showGrid = true;

        public boolean getShowGrid() {
            return this.showGrid;
        }

        public void setShowGrid(boolean bl) {
            if (bl == this.showGrid) {
                return;
            }
            this.showGrid = bl;
            this.showGridToggle.setState(bl);
            this.forceRedraw();
        }
    }

    public class SpaceCurveParametricView
    extends SpaceCurveView {
        double fractionToDraw = -1.0;
        @VMMSave
        private boolean showEvolute;
        EvoluteDecoration evolute;
        ToggleAction showEvoluteToggle = new ToggleAction(I18n.tr("vmm.spacecurve.parametric.SpaceCurveParametric.ShowEvolute")){

            public void actionPerformed(ActionEvent actionEvent) {
                SpaceCurveParametricView.this.setShowEvolute(this.getState());
            }
        };
        AbstractActionVMM showOsculatingCirclesAction = new AbstractActionVMM(I18n.tr("vmm.spacecurve.parametric.SpaceCurveParametric.ShowOsculatingCircles")){

            public void actionPerformed(ActionEvent actionEvent) {
                SpaceCurveParametricView.this.getDisplay().installAnimation(new TimerAnimation(){

                    protected void drawFrame() {
                        if (SpaceCurveParametricView.this.evolute == null) {
                            this.cancel();
                        } else {
                            SpaceCurveParametricView.this.evolute.circleIndex++;
                            if (SpaceCurveParametricView.this.evolute.circleIndex >= SpaceCurveParametric.this.getPointCount()) {
                                this.cancel();
                            } else {
                                SpaceCurveParametricView.this.forceRedraw();
                            }
                        }
                    }

                    protected void animationEnding() {
                        SpaceCurveParametricView.this.evolute.showCompleteEvolute = true;
                        SpaceCurveParametricView.this.forceRedraw();
                    }

                    protected void animationStarting() {
                        if (!SpaceCurveParametricView.this.showEvolute) {
                            SpaceCurveParametricView.this.evolute = new EvoluteDecoration();
                        }
                        SpaceCurveParametricView.this.evolute.showCompleteEvolute = false;
                        SpaceCurveParametricView.this.evolute.showCompleteEvolute = false;
                        SpaceCurveParametricView.this.evolute.circleIndex = 0;
                        SpaceCurveParametricView.this.setShowEvolute(true);
                        SpaceCurveParametricView.this.forceRedraw();
                    }
                });
            }
        };

        public SpaceCurveParametricView() {
            this.setAntialiased(true);
        }

        public boolean getShowEvolute() {
            return this.showEvolute;
        }

        public void setShowEvolute(boolean bl) {
            if (this.showEvolute == bl) {
                return;
            }
            this.showEvolute = bl;
            this.showEvoluteToggle.setState(bl);
            if (bl) {
                if (this.evolute == null) {
                    this.evolute = new EvoluteDecoration();
                }
                this.addDecoration(this.evolute);
            } else {
                this.removeDecoration(this.evolute);
                this.evolute = null;
            }
        }
    }
}

