/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import vmm.core.Decoration;
import vmm.core.Parameterizable;
import vmm.core.Transform;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;
import vmm.spacecurve.parametric.SpaceCurveParametric;

public class RepereMobileDecoration
extends Decoration {
    private SpaceCurveParametric curve;
    @VMMSave
    private double t = Double.NaN;

    public SpaceCurveParametric getCurve() {
        return this.curve;
    }

    public void setCurve(SpaceCurveParametric spaceCurveParametric) {
        this.curve = spaceCurveParametric;
    }

    public void setT(double d) {
        this.t = d;
        this.fireDecorationChangeEvent();
    }

    public double getT() {
        return this.t;
    }

    public void setIndex(int n) {
        if (this.curve != null && n >= 0 && n <= this.curve.getTResolution()) {
            this.setT(this.curve.getT(n));
        } else {
            this.setT(Double.NaN);
        }
    }

    public void doDraw(Graphics2D graphics2D, View view, Transform transform) {
        Parameterizable parameterizable;
        if (this.curve == null && view != null) {
            parameterizable = view.getExhibit();
            if (parameterizable instanceof SpaceCurveParametric) {
                this.curve = (SpaceCurveParametric)parameterizable;
            } else {
                return;
            }
        }
        if (Double.isNaN(this.t)) {
            return;
        }
        if (!(view instanceof View3D)) {
            return;
        }
        parameterizable = (View3D)view;
        Vector3D[] vector3DArray = this.curve.makeRepereMobile(this.t);
        if (vector3DArray == null) {
            return;
        }
        Color color = ((View)parameterizable).getColor();
        ((View)parameterizable).setStrokeSizeMultiplier(2);
        boolean bl = ((View3D)parameterizable).getViewStyle() == 1;
        double d = transform.getPixelWidth() * 50.0;
        if (bl) {
            ((View)parameterizable).setColor(Color.white);
        } else {
            ((View)parameterizable).setColor(Color.red);
        }
        ((View3D)parameterizable).drawLine(vector3DArray[0], vector3DArray[0].plus(vector3DArray[1].times(d)));
        if (!bl) {
            ((View)parameterizable).setColor(Color.blue);
        }
        ((View3D)parameterizable).drawLine(vector3DArray[0], vector3DArray[0].plus(vector3DArray[2].times(d)));
        if (!bl) {
            ((View)parameterizable).setColor(Color.green);
        }
        ((View3D)parameterizable).drawLine(vector3DArray[0], vector3DArray[0].plus(vector3DArray[3].times(d)));
        ((View)parameterizable).setColor(color);
        ((View)parameterizable).setStrokeSizeMultiplier(1);
    }
}

