/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.spacecurve.parametric.SphericalCurve;

public class Loxodrome
extends SphericalCurve {
    private RealParamAnimateable Slope;

    public Loxodrome() {
        this.tResolution.setValueAndDefault(300);
        this.tmin.setValueAndDefaultFromString("-8 * pi");
        this.tmax.setValueAndDefaultFromString("8 * pi");
        this.Slope = new RealParamAnimateable("vmm.spacecurve.parametric.Loxodrome.Slope", 0.2, 0.1, 0.3);
        this.addParameter(this.Slope);
        this.tubeSize.setValueAndDefault(0.1);
    }

    protected Vector3D value(double d) {
        double d2 = Math.exp(this.Slope.getValue() * d);
        double d3 = 2.0 * d2 * Math.cos(d) / (1.0 + d2 * d2);
        double d4 = 2.0 * d2 * Math.sin(d) / (1.0 + d2 * d2);
        double d5 = (1.0 - d2 * d2) / (1.0 + d2 * d2);
        return new Vector3D(d3, d4, d5);
    }
}

