/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.spacecurve.parametric.SpaceCurveParametric;

public class Helix
extends SpaceCurveParametric {
    private RealParamAnimateable radiusX;
    private RealParamAnimateable radiusZ;
    private RealParamAnimateable risePerTurn;

    public Helix() {
        this.tResolution.setValueAndDefault(150);
        this.tmin.setValueAndDefaultFromString("-3 * pi");
        this.tmax.setValueAndDefaultFromString("3 * pi");
        this.radiusX = new RealParamAnimateable("vmm.spacecurve.parametric.Helix.radiusX", 1.5, 1.5, 1.5);
        this.radiusZ = new RealParamAnimateable("vmm.spacecurve.parametric.Helix.radiusZ", 1.5, 1.5, 1.5);
        this.risePerTurn = new RealParamAnimateable("vmm.spacecurve.parametric.Helix.risePerTurn", 2.5, 1.0, 3.0);
        this.addParameter(this.risePerTurn);
        this.addParameter(this.radiusZ);
        this.addParameter(this.radiusX);
        this.setDefaultWindow(-5.0, 5.0, -3.0, 3.0);
        this.setDefaultViewpoint(new Vector3D(20.0, 5.0, 2.0));
        this.tubeSize.setValueAndDefault(0.5);
    }

    protected Vector3D value(double d) {
        double d2 = this.radiusX.getValue() * Math.cos(d);
        double d3 = d * this.risePerTurn.getValue() / (Math.PI * 2);
        double d4 = this.radiusZ.getValue() * Math.sin(d);
        return new Vector3D(d2, d3, d4);
    }

    protected Vector3D deriv1(double d) {
        double d2 = -this.radiusX.getValue() * Math.sin(d);
        double d3 = this.risePerTurn.getValue() / (Math.PI * 2);
        double d4 = this.radiusZ.getValue() * Math.cos(d);
        return new Vector3D(d2, d3, d4);
    }

    protected Vector3D deriv2(double d) {
        double d2 = -this.radiusX.getValue() * Math.cos(d);
        double d3 = 0.0;
        double d4 = -this.radiusZ.getValue() * Math.sin(d);
        return new Vector3D(d2, d3, d4);
    }
}

