/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import vmm.actions.ActionList;
import vmm.actions.ActionRadioGroup;
import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.Vector3D;
import vmm.spacecurve.parametric.SpaceCurveParametric;

public class ConstantTorsion
extends SpaceCurveParametric {
    RealParamAnimateable aa = new RealParamAnimateable("vmm.spacecurve.parametric.ConstantTorsion.aa", 0.178632213, 0.17863, 0.7227614);
    RealParamAnimateable bb = new RealParamAnimateable("vmm.spacecurve.parametric.ConstantTorsion.bb", 0.0, 0.0, 0.0);
    RealParamAnimateable cc = new RealParamAnimateable("vmm.spacecurve.parametric.ConstantTorsion.cc", 0.2874008, 0.2874008, 7.39575343);
    RealParamAnimateable dd = new RealParamAnimateable("vmm.spacecurve.parametric.ConstantTorsion.dd", 0.0, 0.0, 0.0);
    RealParamAnimateable ee = new RealParamAnimateable("vmm.spacecurve.parametric.ConstantTorsion.ee", 0.0, 0.0, 0.0);
    RealParamAnimateable ff = new RealParamAnimateable("vmm.spacecurve.parametric.ConstantTorsion.ff", 0.208, 0.208, 0.208);
    double tau = 0.178632213;
    double b = 0.0;
    double c = 0.2874008;
    double d = 0.0;
    double e = 0.0;
    double f = 0.208;
    private int exampleNumber = 0;
    private ActionRadioGroup exampleSelect;
    int tr = this.tResolution.getValue();
    Vector3D startPoint = new Vector3D(0.0, 0.0, 0.0);
    Vector3D P = new Vector3D(0.0, 0.0, -1.0);
    Vector3D T = new Vector3D(1.0, 0.0, 0.0);
    Vector3D N = new Vector3D(0.0, 1.0, 0.0);
    Vector3D B = new Vector3D(0.0, 0.0, 1.0);
    Vector3D[] initialFrenet = new Vector3D[]{this.startPoint, this.T, this.N, this.B};
    Vector3D[] repere = new Vector3D[]{this.P, this.T, this.N, this.B};
    Vector3D[] pointSet = new Vector3D[this.tr + 1];
    Vector3D[] helperFrame = new Vector3D[4 * (this.tr + 1)];
    boolean needsNewArray = true;
    Vector3D dT1 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D dN1 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D dB1 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D dT2 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D dN2 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D dB2 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D dT3 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D dN3 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D dB3 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D dT4 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D dN4 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D dB4 = new Vector3D(0.0, 0.0, 0.0);
    Vector3D Vvv = new Vector3D(0.0, 0.0, 0.0);

    public ConstantTorsion() {
        this.setDefaultViewpoint(new Vector3D(0.0, -16.0, -6.0));
        this.setDefaultWindow(-8.0, 8.0, -6.0, 6.0);
        this.tResolution.setValueAndDefault(400);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("60");
        this.addParameter(this.ff);
        this.addParameter(this.ee);
        this.addParameter(this.dd);
        this.addParameter(this.cc);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
        this.tubeSize.setValueAndDefault(0.2);
        ActionRadioGroup actionRadioGroup = new ActionRadioGroup(){

            public void optionSelected(int n) {
                ConstantTorsion.this.setExampleNumberFunction(n);
            }
        };
        actionRadioGroup.addItem(I18n.tr("vmm.spacecurve.parametric.ConstantTorsion.example0"));
        actionRadioGroup.addItem(I18n.tr("vmm.spacecurve.parametric.ConstantTorsion.example1"));
        actionRadioGroup.addItem(I18n.tr("vmm.spacecurve.parametric.ConstantTorsion.example2"));
        actionRadioGroup.addItem(I18n.tr("vmm.spacecurve.parametric.ConstantTorsion.example3"));
        actionRadioGroup.addItem(I18n.tr("vmm.spacecurve.parametric.ConstantTorsion.example4"));
        actionRadioGroup.setSelectedIndex(0);
        this.exampleSelect = actionRadioGroup;
    }

    public int getExampleNumberFunction() {
        return this.exampleNumber;
    }

    public void setExampleNumberFunction(int n) {
        if (this.exampleNumber != n) {
            this.exampleNumber = n;
            System.out.println("exampleNumber = " + n);
            this.resetFourierConstants(n);
            this.forceRedraw();
        }
    }

    public ActionList getActionsForView(View view) {
        ActionList actionList = super.getActionsForView(view);
        actionList.add(null);
        ActionList actionList2 = new ActionList(I18n.tr("vmm.spacecurve.parametric.ConstantTorsion.closedCurves"));
        actionList2.add(this.exampleSelect);
        actionList.add(actionList2);
        return actionList;
    }

    private void resetFourierConstants(int n) {
        this.needsNewArray = true;
        this.tResolution.reset(400);
        this.ff.reset(0.208);
        this.bb.reset(0.0);
        this.dd.reset(0.0);
        this.ee.reset(0.0);
        switch (n) {
            case 0: {
                this.tmax.reset("18*pi");
                this.aa.reset(0.178632213);
                this.cc.reset(0.2874008);
                break;
            }
            case 1: {
                this.tmax.reset("18*pi");
                this.aa.reset(0.513441035);
                this.cc.reset(3.489480574);
                break;
            }
            case 2: {
                this.tmax.reset("18*pi");
                this.aa.reset(0.7227614);
                this.cc.reset(7.39575343);
                break;
            }
            case 3: {
                this.tmax.reset("24*pi");
                this.ff.reset(0.23);
                this.aa.reset(0.7081321561);
                this.cc.reset(3.732639742);
                break;
            }
            case 4: {
                this.tResolution.reset(600);
                this.tmax.reset("30*pi");
                this.ff.reset(0.2324);
                this.aa.reset(0.73855871446286);
                this.cc.reset(2.96466);
            }
        }
        this.getConstants();
    }

    private void getConstants() {
        this.tr = this.tResolution.getValue();
        this.tau = this.aa.getValue();
        this.b = this.bb.getValue();
        this.c = this.cc.getValue();
        this.d = this.dd.getValue();
        this.e = this.ee.getValue();
        this.f = this.ff.getValue();
    }

    public void parameterChanged(Parameter parameter, Object object, Object object2) {
        super.parameterChanged(parameter, object, object2);
        this.needsNewArray = true;
    }

    protected double kappa(double d) {
        return this.b + this.c * Math.cos(this.f * d) + this.d * Math.cos(2.0 * this.f * d) + this.e * Math.cos(3.0 * this.f * d);
    }

    protected Vector3D[] frenetODEstep2(double d, double d2, Vector3D[] vector3DArray, int n) {
        this.P = vector3DArray[0];
        this.T = vector3DArray[1];
        this.N = vector3DArray[2];
        this.B = vector3DArray[3];
        double d3 = d;
        double d4 = (1.0 + Math.abs(d2 - d)) * (double)n;
        double d5 = (d2 - d) / d4;
        Vector3D vector3D = new Vector3D(this.T);
        Vector3D vector3D2 = new Vector3D(this.N);
        Vector3D vector3D3 = new Vector3D(this.B);
        int n2 = 0;
        while ((double)n2 < d4) {
            vector3D = this.T.plus(this.N.times(this.kappa(d3) * d5 / 2.0));
            vector3D2 = this.N.plus(this.T.times(-this.kappa(d3) * d5 / 2.0)).plus(this.B.times(this.tau * d5 / 2.0));
            vector3D3 = this.B.plus(this.N.times(-this.tau * d5 / 2.0));
            this.P = this.P.plus(this.T.plus(vector3D.times(4.0)).times(d5 / 6.0));
            this.T = this.T.plus(vector3D2.times(this.kappa(d3 += d5 / 2.0) * d5));
            this.N = this.N.plus(vector3D.times(-this.kappa(d3) * d5)).plus(vector3D3.times(this.tau * d5));
            this.B = this.B.plus(vector3D2.times(-this.tau * d5));
            this.P = this.P.plus(this.T.times(d5 / 6.0));
            d3 += d5 / 2.0;
            ++n2;
        }
        return new Vector3D[]{this.P, this.T, this.N, this.B};
    }

    protected Vector3D[] frenetODEstep4(double d, double d2, Vector3D[] vector3DArray, int n) {
        this.P = vector3DArray[0];
        this.T = vector3DArray[1];
        this.N = vector3DArray[2];
        this.B = vector3DArray[3];
        double d3 = d;
        double d4 = 0.0;
        double d5 = Math.floor((1.0 + Math.abs(d2 - d)) * (double)n);
        double d6 = (d2 - d) / d5 / 2.0;
        d5 -= 0.0625;
        int n2 = 0;
        while ((double)n2 < d5) {
            for (int i = 1; i < 3; ++i) {
                d4 = this.kappa(d3);
                this.dT1.assignTimes(this.kappa(d3) * d6 / 2.0, this.N);
                this.dN1.assignLinComb(-this.kappa(d3) * d6 / 2.0, this.T, this.tau * d6 / 2.0, this.B);
                this.dB1.assignTimes(-this.tau * d6 / 2.0, this.N);
                d4 = this.kappa(d3 += d6 / 2.0);
                this.dT2.assignSumTimes(this.N, this.dN1, d4 * d6);
                this.dN2.assignSumTimes(this.T, this.dT1, -d4 * d6);
                this.Vvv.assignSumTimes(this.B, this.dB1, this.tau * d6);
                this.dN2.assignPlus(this.Vvv);
                this.dB2.assignSumTimes(this.N, this.dN1, -this.tau * d6);
                this.dT3.assignLinComb(d4 * d6, this.N, d4 * d6 / 2.0, this.dN2);
                this.dN3.assignLinComb(-d4 * d6, this.T, -d4 * d6 / 2.0, this.dT2);
                this.Vvv.assignLinComb(this.tau * d6, this.B, this.tau * d6 / 2.0, this.dB2);
                this.dN3.assignPlus(this.Vvv);
                this.dB3.assignLinComb(-this.tau * d6, this.N, -this.tau * d6 / 2.0, this.dN2);
                d4 = this.kappa(d3 += d6 / 2.0);
                this.dT4.assignSumTimes(this.N, this.dN3, d4 * d6 / 2.0);
                this.dN4.assignSumTimes(this.T, this.dT3, -d4 * d6 / 2.0);
                this.Vvv.assignSumTimes(this.B, this.dB3, this.tau * d6 / 2.0);
                this.dN4.assignPlus(this.Vvv);
                this.dB4.assignSumTimes(this.N, this.dN3, -this.tau * d6 / 2.0);
                this.P = this.P.plus(this.T.times(d6 * (double)i * (double)i / 3.0));
                this.Vvv.assignSumTimes(this.dT1, this.dT2, this.dT3, this.dT4, 0.3333333333333333);
                this.T = this.T.plus(this.Vvv);
                this.Vvv.assignSumTimes(this.dN1, this.dN2, this.dN3, this.dN4, 0.3333333333333333);
                this.N = this.N.plus(this.Vvv);
                this.Vvv.assignSumTimes(this.dB1, this.dB2, this.dB3, this.dB4, 0.3333333333333333);
                this.B = this.B.plus(this.Vvv);
            }
            this.P.assignLinComb(1.0, d6 / 3.0, this.T);
            ++n2;
        }
        return new Vector3D[]{this.P, this.T, this.N, this.B};
    }

    private void createFrenetArray() {
        int n;
        this.getConstants();
        double d = (this.tmax.getValue() - this.tmin.getValue()) / (double)this.tr;
        double d2 = this.tmin.getValue();
        this.helperFrame = new Vector3D[4 * (this.tr + 1)];
        this.pointSet = new Vector3D[this.tr + 1];
        this.helperFrame[0] = new Vector3D(0.0, 0.0, 0.0);
        this.helperFrame[1] = new Vector3D(1.0, 0.0, 0.0);
        this.helperFrame[2] = new Vector3D(0.0, 1.0, 0.0);
        this.helperFrame[3] = new Vector3D(0.0, 0.0, 1.0);
        this.pointSet[0] = new Vector3D(this.helperFrame[0]);
        for (n = 0; n < this.tr; ++n) {
            int n2;
            for (n2 = 0; n2 < 4; ++n2) {
                this.initialFrenet[n2] = this.helperFrame[n2 + 4 * n];
            }
            this.repere = this.frenetODEstep4(d2, d2 + d, this.initialFrenet, 32);
            for (n2 = 0; n2 < 4; ++n2) {
                this.helperFrame[n2 + 4 * (n + 1)] = new Vector3D(this.repere[n2]);
            }
            this.pointSet[n + 1] = this.helperFrame[4 * (n + 1)];
            d2 += d;
        }
        this.startPoint = this.getCenterOfPoints(this.pointSet, this.tr + 1);
        this.startPoint.x = -this.startPoint.x;
        this.startPoint.y = -this.startPoint.y;
        this.startPoint.z = -this.startPoint.z;
        for (n = 0; n <= this.tr; ++n) {
            this.helperFrame[4 * n].assignPlus(this.startPoint);
        }
    }

    public Vector3D[] makeRepereMobile(double d) {
        int n = 0;
        double d2 = 0.0;
        if (this.needsNewArray) {
            this.createFrenetArray();
            this.needsNewArray = false;
        }
        n = (int)Math.floor((double)this.tResolution.getValue() * (d - this.tmin.getValue()) / (this.tmax.getValue() - this.tmin.getValue()));
        n = Math.max(0, Math.min(n, this.tResolution.getValue()));
        d2 = this.tmin.getValue() + (double)n * (this.tmax.getValue() - this.tmin.getValue()) / (double)this.tResolution.getValue();
        for (int i = 0; i < 4; ++i) {
            this.initialFrenet[i] = this.helperFrame[i + 4 * n];
        }
        this.repere = this.frenetODEstep4(d2, d, this.initialFrenet, 16);
        return this.repere;
    }

    protected Vector3D value(double d) {
        int n = 0;
        double d2 = 0.0;
        if (this.needsNewArray) {
            this.createFrenetArray();
            this.needsNewArray = false;
        }
        n = (int)Math.floor((double)this.tResolution.getValue() * (d - this.tmin.getValue()) / (this.tmax.getValue() - this.tmin.getValue()));
        n = Math.max(0, Math.min(n, this.tResolution.getValue()));
        d2 = this.tmin.getValue() + (double)n * (this.tmax.getValue() - this.tmin.getValue()) / (double)this.tResolution.getValue();
        for (int i = 0; i < 4; ++i) {
            this.initialFrenet[i] = this.helperFrame[i + 4 * n];
        }
        Vector3D vector3D = this.frenetODEstep4(d2, d, this.initialFrenet, 16)[0];
        return vector3D;
    }
}

