/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.spacecurve.parametric.SpaceCurveParametric;

public class CinquefoilKnot
extends SpaceCurveParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 2.0, 2.0, 6.0);

    public CinquefoilKnot() {
        this.addParameter(this.aa);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("10 * pi");
        this.tResolution.setValueAndDefault(300);
        this.setDefaultViewpoint(new Vector3D(100.0, -100.0, 52.5));
        this.setDefaultWindow(-3.0, 3.0, -3.0, 3.0);
        this.tubeSize.setValueAndDefault(0.3);
    }

    protected Vector3D value(double d) {
        double d2 = this.aa.getValue();
        double d3 = 2.0 / (2.0 * d2 + 1.0);
        return new Vector3D(Math.cos(d) * (2.0 - Math.cos(d3 * d)), Math.sin(d) * (2.0 - Math.cos(d3 * d)), -Math.sin(d3 * d));
    }
}

