/*
 * Decompiled with CFR 0.152.
 */
package vmm.pseudospherical;

import vmm.core.Complex;
import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.pseudospherical.ComplexMatrix2D;
import vmm.pseudospherical.ComplexVector2D;
import vmm.surface.parametric.SurfaceParametric;

public class nSolitons
extends SurfaceParametric {
    Complex lambda;
    double xVar;
    double tVar;
    public RealParamAnimateable s = new RealParamAnimateable("s1", 1.0, 0.2, 1.0);
    public RealParamAnimateable s1 = new RealParamAnimateable("s2", 1.0, 0.2, 1.0);
    public RealParamAnimateable s2 = new RealParamAnimateable("s3", 1.0, 0.2, 1.0);
    public int solitonNum = 2;
    public double epsilon = 1.0E-7;
    public ComplexVector2D initVec = new ComplexVector2D(new Complex(1.0, 0.0), new Complex(1.0, 0.0));
    public ComplexVector2D initVec1 = new ComplexVector2D(new Complex(1.0, 0.0), new Complex(-5.0, 0.0));
    public ComplexVector2D initVec2 = new ComplexVector2D(new Complex(1.0, 0.0), new Complex(1.0, 0.0));
    public ComplexMatrix2D E0;
    public ComplexMatrix2D g1;
    public ComplexMatrix2D g2;
    public ComplexMatrix2D g3;
    public ComplexMatrix2D E1;
    public ComplexMatrix2D proj;
    public ComplexMatrix2D proj1;
    public ComplexMatrix2D proj2;
    public ComplexMatrix2D projPerp;
    public ComplexMatrix2D projPerp1;
    public ComplexMatrix2D projPerp2;
    public ComplexMatrix2D id;
    public ComplexMatrix2D g1Perp;
    public ComplexMatrix2D[][] E;
    public ComplexMatrix2D[][] g;

    public nSolitons() {
        int n;
        int n2;
        this.lambda = new Complex(0.0, 1.0);
        this.E = new ComplexMatrix2D[4][6];
        for (n2 = 0; n2 <= 3; ++n2) {
            for (n = 0; n < 6; ++n) {
                this.E[n2][n] = new ComplexMatrix2D();
            }
        }
        this.g = new ComplexMatrix2D[4][5];
        for (n2 = 0; n2 <= 3; ++n2) {
            for (n = 0; n < 5; ++n) {
                this.g[n2][n] = new ComplexMatrix2D();
            }
        }
        this.E0 = new ComplexMatrix2D();
        this.getE0(this.xVar, this.s.getValue(), this.lambda);
        this.proj = ComplexMatrix2D.getProj(this.initVec);
        this.proj1 = ComplexMatrix2D.getProj(this.initVec1);
        this.proj2 = ComplexMatrix2D.getProj(this.initVec2);
        this.id = new ComplexMatrix2D();
        this.id.setMatrixEntry(Complex.ONE_C, 1, 1);
        this.id.setMatrixEntry(Complex.ZERO_C, 1, 2);
        this.id.setMatrixEntry(Complex.ZERO_C, 2, 1);
        this.id.setMatrixEntry(Complex.ONE_C, 2, 2);
        this.g1 = new ComplexMatrix2D();
        this.g2 = new ComplexMatrix2D();
        this.g3 = new ComplexMatrix2D();
    }

    public ComplexMatrix2D getProj(ComplexVector2D complexVector2D) {
        return ComplexMatrix2D.getProj(complexVector2D);
    }

    public void getg1(Complex complex) {
        ComplexMatrix2D complexMatrix2D = this.id.subtract(this.proj);
        Complex complex2 = new Complex(0.0, 1.0);
        complex2 = complex2.times(2.0 * this.s.getValue()).dividedBy(complex.minus(complex2.times(this.s.getValue())));
        this.g1.entries[1][1] = new Complex(complex2.times(complexMatrix2D.entries[1][1]).plus(1.0));
        this.g1.entries[1][2] = new Complex(complex2.times(complexMatrix2D.entries[1][2]));
        this.g1.entries[2][1] = new Complex(complex2.times(complexMatrix2D.entries[2][1]));
        this.g1.entries[2][2] = new Complex(complex2.times(complexMatrix2D.entries[2][2]).plus(1.0));
    }

    public void getg2(Complex complex) {
        ComplexMatrix2D complexMatrix2D = this.id.subtract(this.proj1);
        Complex complex2 = new Complex(0.0, 1.0);
        complex2 = complex2.times(2.0 * this.s1.getValue()).dividedBy(complex.minus(complex2.times(this.s1.getValue())));
        this.g2.entries[1][1] = new Complex(complex2.times(complexMatrix2D.entries[1][1]).plus(1.0));
        this.g2.entries[1][2] = new Complex(complex2.times(complexMatrix2D.entries[1][2]));
        this.g2.entries[2][1] = new Complex(complex2.times(complexMatrix2D.entries[2][1]));
        this.g2.entries[2][2] = new Complex(complex2.times(complexMatrix2D.entries[2][2]).plus(1.0));
    }

    public void getg3(Complex complex) {
        ComplexMatrix2D complexMatrix2D = this.id.subtract(this.proj2);
        Complex complex2 = new Complex(0.0, 1.0);
        complex2 = complex2.times(2.0 * this.s2.getValue()).dividedBy(complex.minus(complex2.times(this.s2.getValue())));
        this.g3.entries[1][1] = new Complex(complex2.times(complexMatrix2D.entries[1][1]).plus(1.0));
        this.g3.entries[1][2] = new Complex(complex2.times(complexMatrix2D.entries[1][2]));
        this.g3.entries[2][1] = new Complex(complex2.times(complexMatrix2D.entries[2][1]));
        this.g3.entries[2][2] = new Complex(complex2.times(complexMatrix2D.entries[2][2]).plus(1.0));
    }

    public void getE0(double d, double d2, Complex complex) {
        Complex complex2 = new Complex(0.0, 1.0);
        Complex complex3 = new Complex(complex2.times(complex).times(d / 2.0 + d2 / 2.0));
        Complex complex4 = new Complex(complex2.times(d / 2.0 - d2 / 2.0).dividedBy(complex));
        this.E0.entries[1][1] = complex4.minus(complex3).exponential();
        this.E0.entries[1][2] = new Complex(0.0, 0.0);
        this.E0.entries[2][1] = new Complex(0.0, 0.0);
        this.E0.entries[2][2] = complex3.minus(complex4).exponential();
    }

    public ComplexMatrix2D getg1Perp(Complex complex) {
        ComplexMatrix2D complexMatrix2D = new ComplexMatrix2D();
        ComplexMatrix2D complexMatrix2D2 = this.id.subtract(this.projPerp);
        Complex complex2 = new Complex(0.0, 1.0);
        complex2 = complex2.times(2.0 * this.s.getValue()).dividedBy(complex.minus(complex2.times(this.s.getValue())));
        complexMatrix2D.entries[1][1] = new Complex(complex2.times(complexMatrix2D2.entries[1][1]).plus(1.0));
        complexMatrix2D.entries[1][2] = new Complex(complex2.times(complexMatrix2D2.entries[1][2]));
        complexMatrix2D.entries[2][1] = new Complex(complex2.times(complexMatrix2D2.entries[2][1]));
        complexMatrix2D.entries[2][2] = new Complex(complex2.times(complexMatrix2D2.entries[2][2]).plus(1.0));
        return complexMatrix2D;
    }

    public ComplexMatrix2D getg2Perp(Complex complex) {
        ComplexMatrix2D complexMatrix2D = new ComplexMatrix2D();
        ComplexMatrix2D complexMatrix2D2 = this.id.subtract(this.projPerp1);
        Complex complex2 = new Complex(0.0, 1.0);
        complex2 = complex2.times(2.0 * this.s1.getValue()).dividedBy(complex.minus(complex2.times(this.s1.getValue())));
        complexMatrix2D.entries[1][1] = new Complex(complex2.times(complexMatrix2D2.entries[1][1]).plus(1.0));
        complexMatrix2D.entries[1][2] = new Complex(complex2.times(complexMatrix2D2.entries[1][2]));
        complexMatrix2D.entries[2][1] = new Complex(complex2.times(complexMatrix2D2.entries[2][1]));
        complexMatrix2D.entries[2][2] = new Complex(complex2.times(complexMatrix2D2.entries[2][2]).plus(1.0));
        return complexMatrix2D;
    }

    public ComplexMatrix2D getg3Perp(Complex complex) {
        ComplexMatrix2D complexMatrix2D = new ComplexMatrix2D();
        ComplexMatrix2D complexMatrix2D2 = this.id.subtract(this.projPerp2);
        Complex complex2 = new Complex(0.0, 1.0);
        complex2 = complex2.times(2.0 * this.s2.getValue()).dividedBy(complex.minus(complex2.times(this.s2.getValue())));
        complexMatrix2D.entries[1][1] = new Complex(complex2.times(complexMatrix2D2.entries[1][1]).plus(1.0));
        complexMatrix2D.entries[1][2] = new Complex(complex2.times(complexMatrix2D2.entries[1][2]));
        complexMatrix2D.entries[2][1] = new Complex(complex2.times(complexMatrix2D2.entries[2][1]));
        complexMatrix2D.entries[2][2] = new Complex(complex2.times(complexMatrix2D2.entries[2][2]).plus(1.0));
        return complexMatrix2D;
    }

    public ComplexMatrix2D getgTilde(ComplexMatrix2D complexMatrix2D, Complex complex, double d) {
        Complex complex2 = new Complex(0.0, d);
        ComplexMatrix2D complexMatrix2D2 = complexMatrix2D.subtract(this.id).scalarMul(complex.minus(complex2).dividedBy(new Complex(0.0, 2.0 * d)));
        complexMatrix2D2 = this.id.subtract(complexMatrix2D2);
        return complexMatrix2D2;
    }

    public ComplexMatrix2D getgPerp(ComplexMatrix2D complexMatrix2D, double d, Complex complex, ComplexVector2D complexVector2D) {
        ComplexMatrix2D complexMatrix2D2 = new ComplexMatrix2D(complexMatrix2D);
        complexMatrix2D2 = complexMatrix2D2.conjugate().transpose();
        complexMatrix2D2 = ComplexMatrix2D.getProj(complexMatrix2D2.vectMul(complexVector2D));
        complexMatrix2D2 = this.id.subtract(complexMatrix2D2);
        ComplexMatrix2D complexMatrix2D3 = new ComplexMatrix2D();
        Complex complex2 = new Complex(0.0, 1.0);
        complex2 = new Complex(complex2.times(2.0 * d).dividedBy(complex.minus(complex2.times(d))));
        complexMatrix2D3.entries[1][1] = complex2.times(new Complex(complexMatrix2D2.entries[1][1])).plus(1.0);
        complexMatrix2D3.entries[1][2] = complex2.times(new Complex(complexMatrix2D2.entries[1][2]));
        complexMatrix2D3.entries[2][1] = complex2.times(new Complex(complexMatrix2D2.entries[2][1]));
        complexMatrix2D3.entries[2][2] = complex2.times(new Complex(complexMatrix2D2.entries[2][2])).plus(1.0);
        return complexMatrix2D3;
    }

    public ComplexMatrix2D getNextE(ComplexMatrix2D complexMatrix2D, ComplexMatrix2D complexMatrix2D2, ComplexMatrix2D complexMatrix2D3, ComplexMatrix2D complexMatrix2D4, ComplexMatrix2D complexMatrix2D5, double d) {
        ComplexMatrix2D complexMatrix2D6 = new ComplexMatrix2D(complexMatrix2D4.multiply(complexMatrix2D));
        ComplexMatrix2D complexMatrix2D7 = new ComplexMatrix2D(this.id.subtract(complexMatrix2D4));
        complexMatrix2D7 = complexMatrix2D7.multiply(complexMatrix2D2).multiply(this.id.subtract(complexMatrix2D5));
        complexMatrix2D6 = new ComplexMatrix2D(complexMatrix2D6.add(complexMatrix2D7));
        complexMatrix2D7 = new ComplexMatrix2D(complexMatrix2D4);
        complexMatrix2D7 = complexMatrix2D7.scalarMul(new Complex(0.0, -2.0 * d));
        complexMatrix2D7 = complexMatrix2D7.multiply(complexMatrix2D2.subtract(complexMatrix2D3).multiply(this.id.subtract(complexMatrix2D5)).scalarMul(new Complex(1.0 / (2.0 * this.epsilon), 0.0)));
        complexMatrix2D6 = complexMatrix2D6.add(complexMatrix2D7);
        return complexMatrix2D6;
    }

    public ComplexMatrix2D getNextE1(ComplexMatrix2D complexMatrix2D, ComplexMatrix2D complexMatrix2D2, ComplexMatrix2D complexMatrix2D3, ComplexMatrix2D complexMatrix2D4, ComplexMatrix2D complexMatrix2D5, double d) {
        ComplexMatrix2D complexMatrix2D6 = this.proj.add(this.proj1).subtract(this.proj1.multiply(this.proj).scalarMul(new Complex(2.0, 0.0)));
        ComplexMatrix2D complexMatrix2D7 = complexMatrix2D2.subtract(complexMatrix2D3).scalarMul(new Complex(1.0 / (2.0 * this.epsilon), 0.0));
        ComplexMatrix2D complexMatrix2D8 = complexMatrix2D2.add(complexMatrix2D3).subtract(complexMatrix2D.scalarMul(new Complex(2.0, 0.0))).scalarMul(new Complex(1.0 / (this.epsilon * this.epsilon), 0.0));
        ComplexMatrix2D complexMatrix2D9 = this.id.subtract(complexMatrix2D4).add(this.id.subtract(complexMatrix2D5));
        ComplexMatrix2D complexMatrix2D10 = this.id.subtract(complexMatrix2D4).multiply(this.id.subtract(complexMatrix2D5));
        ComplexMatrix2D complexMatrix2D11 = this.id.subtract(this.proj1).multiply(this.id.subtract(this.proj));
        complexMatrix2D11 = complexMatrix2D11.subtract(this.proj1.multiply(this.id.subtract(this.proj)));
        complexMatrix2D11 = complexMatrix2D11.subtract(this.id.subtract(this.proj1).multiply(this.proj));
        ComplexMatrix2D complexMatrix2D12 = complexMatrix2D.add(complexMatrix2D7.multiply(complexMatrix2D9).scalarMul(new Complex(0.0, -2.0 * d)));
        complexMatrix2D12 = complexMatrix2D12.add(complexMatrix2D8.multiply(complexMatrix2D10).scalarMul(new Complex(-2.0 * d * d, 0.0)));
        complexMatrix2D12 = this.proj1.multiply(this.proj).multiply(complexMatrix2D12);
        complexMatrix2D12 = complexMatrix2D12.add(complexMatrix2D6.multiply(complexMatrix2D).multiply(complexMatrix2D9));
        complexMatrix2D12 = complexMatrix2D12.add(complexMatrix2D6.multiply(complexMatrix2D7).multiply(complexMatrix2D10).scalarMul(new Complex(0.0, -2.0 * d)));
        complexMatrix2D12 = complexMatrix2D12.add(complexMatrix2D11.multiply(complexMatrix2D).multiply(complexMatrix2D10));
        return complexMatrix2D12;
    }

    public ComplexMatrix2D firstSoliton(double d, double d2) {
        this.getE0(d, d2, new Complex(0.0, -this.s.getValue()));
        ComplexMatrix2D complexMatrix2D = new ComplexMatrix2D(this.E0);
        this.lambda = new Complex(1.0 + this.epsilon, 0.0);
        ComplexMatrix2D complexMatrix2D2 = new ComplexMatrix2D(this.getgPerp(complexMatrix2D, this.s.getValue(), this.lambda, this.initVec));
        this.projPerp = this.getgTilde(complexMatrix2D2, this.lambda, this.s.getValue());
        this.getg1(this.lambda);
        this.getE0(d, d2, this.lambda);
        this.E[0][0] = new ComplexMatrix2D(this.E0);
        this.g[0][0] = new ComplexMatrix2D(complexMatrix2D2);
        ComplexMatrix2D complexMatrix2D3 = new ComplexMatrix2D(this.g1.multiply(this.E0.multiply(complexMatrix2D2.conjugate().transpose())));
        this.E[1][0] = new ComplexMatrix2D(complexMatrix2D3);
        this.lambda = new Complex(1.0 - this.epsilon, 0.0);
        complexMatrix2D2 = new ComplexMatrix2D(this.getgPerp(complexMatrix2D, this.s.getValue(), this.lambda, this.initVec));
        this.getg1(this.lambda);
        this.getE0(d, d2, this.lambda);
        this.E[0][1] = new ComplexMatrix2D(this.E0);
        this.g[0][1] = new ComplexMatrix2D(complexMatrix2D2);
        ComplexMatrix2D complexMatrix2D4 = new ComplexMatrix2D(this.g1.multiply(this.E0.multiply(complexMatrix2D2.conjugate().transpose())));
        this.E[1][1] = new ComplexMatrix2D(complexMatrix2D4);
        complexMatrix2D3 = new ComplexMatrix2D(complexMatrix2D3.subtract(complexMatrix2D4));
        complexMatrix2D3 = new ComplexMatrix2D(complexMatrix2D3.scalarMul(new Complex(1.0 / (2.0 * this.epsilon), 0.0)));
        this.lambda = new Complex(1.0, 0.0);
        complexMatrix2D2 = new ComplexMatrix2D(this.getgPerp(complexMatrix2D, this.s.getValue(), this.lambda, this.initVec));
        this.getg1(this.lambda);
        this.getE0(d, d2, this.lambda);
        this.E[0][2] = new ComplexMatrix2D(this.E0);
        this.g[0][2] = new ComplexMatrix2D(complexMatrix2D2);
        complexMatrix2D4 = new ComplexMatrix2D(this.g1.multiply(this.E0.multiply(complexMatrix2D2.conjugate().transpose())));
        this.E[1][2] = new ComplexMatrix2D(complexMatrix2D4);
        complexMatrix2D3 = complexMatrix2D3.multiply(complexMatrix2D2.multiply(this.E0.inverse().multiply(this.g1.conjugate().transpose())));
        return complexMatrix2D3;
    }

    public void afterFirstSol(double d, double d2) {
        this.getE0(d, d2, new Complex(0.0, -this.s.getValue()));
        ComplexMatrix2D complexMatrix2D = new ComplexMatrix2D(this.E0);
        double d3 = this.s.getValue();
        if (this.solitonNum == 2) {
            d3 = this.s1.getValue();
        }
        if (this.solitonNum == 3) {
            d3 = this.s2.getValue();
        }
        this.lambda = new Complex(0.0, -d3);
        this.getE0(d, d2, this.lambda);
        this.E[0][5] = new ComplexMatrix2D(this.E0);
        this.lambda = new Complex(this.epsilon, -d3);
        this.getg1(this.lambda);
        this.getE0(d, d2, this.lambda);
        ComplexMatrix2D complexMatrix2D2 = new ComplexMatrix2D(this.getgPerp(complexMatrix2D, d3, this.lambda, this.initVec));
        this.E[0][3] = new ComplexMatrix2D(this.E0);
        this.g[0][3] = new ComplexMatrix2D(complexMatrix2D2);
        ComplexMatrix2D complexMatrix2D3 = new ComplexMatrix2D(this.g1.multiply(this.E0.multiply(complexMatrix2D2.inverse())));
        this.E[1][3] = new ComplexMatrix2D(complexMatrix2D3);
        this.lambda = new Complex(-this.epsilon, -d3);
        this.getg1(this.lambda);
        this.getE0(d, d2, this.lambda);
        complexMatrix2D2 = new ComplexMatrix2D(this.getgPerp(complexMatrix2D, d3, this.lambda, this.initVec));
        this.E[0][4] = new ComplexMatrix2D(this.E0);
        this.g[0][4] = new ComplexMatrix2D(complexMatrix2D2);
        complexMatrix2D3 = new ComplexMatrix2D(this.g1.multiply(this.E0.multiply(complexMatrix2D2.inverse())));
        this.E[1][4] = new ComplexMatrix2D(complexMatrix2D3);
        if (this.s.getValue() == this.s1.getValue()) {
            this.E[1][5] = this.getNextE(this.E[0][5], this.E[0][3], this.E[0][4], this.proj, this.projPerp, this.s.getValue());
        } else {
            this.lambda = new Complex(0.0, -this.s1.getValue());
            this.getg1(this.lambda);
            this.getE0(d, d2, this.lambda);
            complexMatrix2D2 = new ComplexMatrix2D(this.getgPerp(complexMatrix2D, this.s.getValue(), this.lambda, this.initVec));
            this.E[1][5] = this.g1.multiply(this.E0).multiply(complexMatrix2D2.inverse());
        }
        this.lambda = new Complex(1.0 + this.epsilon, 0.0);
        this.g[1][0] = this.getgPerp(this.E[1][5], this.s1.getValue(), this.lambda, this.initVec1);
        this.projPerp1 = this.getgTilde(this.g[1][0], this.lambda, this.s1.getValue());
        this.lambda = new Complex(1.0 - this.epsilon, 0.0);
        this.g[1][1] = this.getgPerp(this.E[1][5], this.s1.getValue(), this.lambda, this.initVec1);
        this.lambda = new Complex(1.0, 0.0);
        this.g[1][2] = this.getgPerp(this.E[1][5], this.s1.getValue(), this.lambda, this.initVec1);
        this.lambda = new Complex(this.epsilon, -d3);
        this.g[1][3] = this.getgPerp(this.E[1][5], d3, this.lambda, this.initVec1);
        this.lambda = new Complex(-this.epsilon, -d3);
        this.g[1][4] = this.getgPerp(this.E[1][5], d3, this.lambda, this.initVec1);
    }

    public ComplexMatrix2D iterate1(double d, double d2) {
        ComplexMatrix2D complexMatrix2D;
        int n = 1;
        this.lambda = new Complex(1.0 + this.epsilon, 0.0);
        this.getg2(this.lambda);
        this.E[n + 1][0] = complexMatrix2D = new ComplexMatrix2D(this.g2.multiply(this.E[n][0].multiply(this.g[n][0].conjugate().transpose())));
        this.lambda = new Complex(1.0 - this.epsilon, 0.0);
        this.getg2(this.lambda);
        this.E[n + 1][1] = complexMatrix2D = new ComplexMatrix2D(this.g2.multiply(this.E[n][1].multiply(this.g[n][1].conjugate().transpose())));
        this.lambda = new Complex(1.0, 0.0);
        this.getg2(this.lambda);
        this.E[n + 1][2] = complexMatrix2D = new ComplexMatrix2D(this.g2.multiply(this.E[n][2].multiply(this.g[n][2].conjugate().transpose())));
        ComplexMatrix2D complexMatrix2D2 = new ComplexMatrix2D(this.E[n + 1][0]);
        complexMatrix2D2 = complexMatrix2D2.subtract(this.E[n + 1][1]);
        complexMatrix2D2 = complexMatrix2D2.multiply(this.E[n + 1][2].inverse());
        complexMatrix2D2 = complexMatrix2D2.scalarMul(new Complex(1.0 / (2.0 * this.epsilon), 0.0));
        return complexMatrix2D2;
    }

    public void afterIterate1(double d, double d2) {
        ComplexMatrix2D complexMatrix2D;
        int n = 1;
        double d3 = this.s2.getValue();
        if (this.s.getValue() == this.s1.getValue() && this.s1.getValue() == this.s2.getValue()) {
            this.s2.setValue(d3 + 0.01);
        }
        this.lambda = new Complex(this.epsilon, -this.s2.getValue());
        this.getg2(this.lambda);
        this.E[n + 1][3] = complexMatrix2D = new ComplexMatrix2D(this.g2.multiply(this.E[n][3].multiply(this.g[n][3].inverse())));
        this.lambda = new Complex(-this.epsilon, -this.s2.getValue());
        this.getg2(this.lambda);
        this.E[n + 1][4] = complexMatrix2D = new ComplexMatrix2D(this.g2.multiply(this.E[n][4].multiply(this.g[n][4].inverse())));
        this.lambda = new Complex(0.0, -this.s2.getValue());
        if (this.s2.getValue() == this.s1.getValue() && this.s1.getValue() != this.s.getValue()) {
            this.getg1(this.lambda);
            this.getE0(d, d2, this.lambda);
            complexMatrix2D = this.getg1Perp(this.lambda);
            ComplexMatrix2D complexMatrix2D2 = new ComplexMatrix2D(this.g1.multiply(this.E0).multiply(complexMatrix2D.inverse()));
            this.lambda = new Complex(this.epsilon, -this.s2.getValue());
            this.getg1(this.lambda);
            this.getE0(d, d2, this.lambda);
            complexMatrix2D = this.getg1Perp(this.lambda);
            ComplexMatrix2D complexMatrix2D3 = new ComplexMatrix2D(this.g1.multiply(this.E0).multiply(complexMatrix2D.inverse()));
            this.lambda = new Complex(-this.epsilon, -this.s2.getValue());
            this.getg1(this.lambda);
            this.getE0(d, d2, this.lambda);
            complexMatrix2D = this.getg1Perp(this.lambda);
            ComplexMatrix2D complexMatrix2D4 = new ComplexMatrix2D(this.g1.multiply(this.E0).multiply(complexMatrix2D.inverse()));
            this.E[n + 1][5] = this.getNextE(complexMatrix2D2, complexMatrix2D3, complexMatrix2D4, this.proj1, this.projPerp1, this.s2.getValue());
        } else if (this.s2.getValue() == this.s.getValue() && this.s.getValue() != this.s1.getValue()) {
            this.getE0(d, d2, this.lambda);
            this.getg2(this.lambda);
            ComplexMatrix2D complexMatrix2D5 = new ComplexMatrix2D(this.getg2Perp(this.lambda));
            ComplexMatrix2D complexMatrix2D6 = new ComplexMatrix2D(this.E0);
            this.lambda = new Complex(this.epsilon, -this.s2.getValue());
            this.getE0(d, d2, this.lambda);
            ComplexMatrix2D complexMatrix2D7 = new ComplexMatrix2D(this.E0);
            this.lambda = new Complex(-this.epsilon, -this.s2.getValue());
            this.getE0(d, d2, this.lambda);
            ComplexMatrix2D complexMatrix2D8 = new ComplexMatrix2D(this.E0);
            complexMatrix2D = new ComplexMatrix2D(this.getNextE(complexMatrix2D6, complexMatrix2D7, complexMatrix2D8, this.proj, this.projPerp, this.s2.getValue()));
            this.E[n + 1][5] = this.g2.multiply(complexMatrix2D).multiply(complexMatrix2D5.inverse());
        } else {
            this.getE0(d, d2, this.lambda);
            ComplexMatrix2D complexMatrix2D9 = new ComplexMatrix2D(this.getg1Perp(this.lambda));
            ComplexMatrix2D complexMatrix2D10 = new ComplexMatrix2D(this.getg2Perp(this.lambda));
            this.getg1(this.lambda);
            this.getg2(this.lambda);
            this.E[n + 1][5] = this.g2.multiply(this.g1).multiply(this.E0).multiply(complexMatrix2D9.inverse()).multiply(complexMatrix2D10.inverse());
        }
        this.lambda = new Complex(1.0 + this.epsilon, 0.0);
        this.g[n + 1][0] = this.getgPerp(this.E[n + 1][5], this.s2.getValue(), this.lambda, this.initVec2);
        this.projPerp2 = this.getgTilde(this.g[n + 1][0], this.lambda, this.s2.getValue());
        this.lambda = new Complex(1.0 - this.epsilon, 0.0);
        this.g[n + 1][1] = this.getgPerp(this.E[n + 1][5], this.s2.getValue(), this.lambda, this.initVec2);
        this.lambda = new Complex(1.0, 0.0);
        this.g[n + 1][2] = this.getgPerp(this.E[n + 1][5], this.s2.getValue(), this.lambda, this.initVec2);
        this.lambda = new Complex(this.epsilon, -this.s2.getValue());
        this.g[n + 1][3] = this.getgPerp(this.E[n + 1][5], this.s2.getValue(), this.lambda, this.initVec2);
        this.lambda = new Complex(-this.epsilon, -this.s2.getValue());
        this.g[n + 1][4] = this.getgPerp(this.E[n + 1][5], this.s2.getValue(), this.lambda, this.initVec2);
        this.s2.setValue(d3);
    }

    ComplexMatrix2D iterate2() {
        ComplexMatrix2D complexMatrix2D;
        int n = 2;
        this.lambda = new Complex(1.0 + this.epsilon, 0.0);
        this.getg3(this.lambda);
        this.E[n + 1][0] = complexMatrix2D = new ComplexMatrix2D(this.g3.multiply(this.E[n][0].multiply(this.g[n][0].conjugate().transpose())));
        this.lambda = new Complex(1.0 - this.epsilon, 0.0);
        this.getg3(this.lambda);
        this.E[n + 1][1] = complexMatrix2D = new ComplexMatrix2D(this.g3.multiply(this.E[n][1].multiply(this.g[n][1].conjugate().transpose())));
        this.lambda = new Complex(1.0, 0.0);
        this.getg3(this.lambda);
        this.E[n + 1][2] = complexMatrix2D = new ComplexMatrix2D(this.g3.multiply(this.E[n][2].multiply(this.g[n][2].conjugate().transpose())));
        ComplexMatrix2D complexMatrix2D2 = new ComplexMatrix2D(this.E[n + 1][0]);
        complexMatrix2D2 = complexMatrix2D2.subtract(this.E[n + 1][1]);
        complexMatrix2D2 = complexMatrix2D2.multiply(this.E[n + 1][2].inverse());
        complexMatrix2D2 = complexMatrix2D2.scalarMul(new Complex(1.0 / (2.0 * this.epsilon), 0.0));
        return complexMatrix2D2;
    }

    public synchronized Vector3D surfacePoint(double d, double d2) {
        return new Vector3D(0.0, 0.0, 0.0);
    }
}

