/*
 * Decompiled with CFR 0.152.
 */
package vmm.pseudospherical;

import vmm.core.Complex;
import vmm.core.RealParamAnimateable;
import vmm.core.VariableParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.pseudospherical.ComplexMatrix2D;
import vmm.pseudospherical.ComplexVector2D;
import vmm.surface.parametric.SurfaceParametric;

public class Solitons
extends SurfaceParametric {
    Complex lambda;
    double xVar;
    double tVar;
    private RealParamAnimateable s = new RealParamAnimateable("genericParam.s", 0.85, 0.2, 1.0);
    private VariableParamAnimateable solitonNum = new VariableParamAnimateable("genericParam.solitonNum", 1.0, 1.0, 4.0);
    private double epsilon = 1.0E-5;
    private ComplexVector2D initVec = new ComplexVector2D(new Complex(1.0, 0.0), new Complex(1.0, 0.0));
    public ComplexMatrix2D E0;
    public ComplexMatrix2D g1;
    public ComplexMatrix2D E1;
    public ComplexMatrix2D proj;
    public ComplexMatrix2D id;
    public ComplexMatrix2D g1Perp;

    public Solitons() {
        this.addParameter(this.s);
        this.umin.reset(-3.0);
        this.umax.reset(3.0);
        this.vmin.reset("-pi/2");
        this.vmax.reset("pi/2");
        this.setDefaultWindow(-2.25, 2.25, -1.75, 1.75);
        this.setDefaultViewpoint(new Vector3D(5.5, 4.25, 4.0));
        this.setDefaultViewUp(new Vector3D(-0.16, -0.55, 0.82));
        this.lambda = new Complex(0.0, 1.0);
        this.E0 = new ComplexMatrix2D();
        this.getE0(this.xVar, this.s.getValue(), this.lambda);
        this.proj = ComplexMatrix2D.getProj(this.initVec);
        this.id = new ComplexMatrix2D();
        this.id.setMatrixEntry(Complex.ONE_C, 1, 1);
        this.id.setMatrixEntry(Complex.ZERO_C, 1, 2);
        this.id.setMatrixEntry(Complex.ZERO_C, 2, 1);
        this.id.setMatrixEntry(Complex.ONE_C, 2, 2);
        this.g1 = new ComplexMatrix2D();
        this.getg1(this.lambda);
    }

    public ComplexMatrix2D getProj(ComplexVector2D complexVector2D) {
        return ComplexMatrix2D.getProj(complexVector2D);
    }

    public void getg1(Complex complex) {
        ComplexMatrix2D complexMatrix2D = this.id.subtract(this.proj);
        Complex complex2 = new Complex(0.0, 1.0);
        complex2 = complex2.times(2.0 * this.s.getValue()).dividedBy(complex.minus(complex2.times(this.s.getValue())));
        this.g1.entries[1][1] = new Complex(complex2.times(complexMatrix2D.entries[1][1]).plus(1.0));
        this.g1.entries[1][2] = new Complex(complex2.times(complexMatrix2D.entries[1][2]));
        this.g1.entries[2][1] = new Complex(complex2.times(complexMatrix2D.entries[2][1]));
        this.g1.entries[2][2] = new Complex(complex2.times(complexMatrix2D.entries[2][2]).plus(1.0));
    }

    public void getE0(double d, double d2, Complex complex) {
        Complex complex2 = new Complex(0.0, 1.0);
        Complex complex3 = new Complex(complex2.times(complex).times(d / 2.0 + d2 / 2.0));
        Complex complex4 = new Complex(complex2.times(d / 2.0 - d2 / 2.0).dividedBy(complex));
        this.E0.entries[1][1] = complex4.minus(complex3).exponential();
        this.E0.entries[1][2] = new Complex(0.0, 0.0);
        this.E0.entries[2][1] = new Complex(0.0, 0.0);
        this.E0.entries[2][2] = complex3.minus(complex4).exponential();
    }

    public ComplexMatrix2D getgPerp(ComplexMatrix2D complexMatrix2D, double d, Complex complex, ComplexVector2D complexVector2D) {
        ComplexMatrix2D complexMatrix2D2 = new ComplexMatrix2D(complexMatrix2D);
        complexMatrix2D2 = complexMatrix2D2.conjugate().transpose();
        complexMatrix2D2 = ComplexMatrix2D.getProj(complexMatrix2D2.vectMul(complexVector2D));
        complexMatrix2D2 = this.id.subtract(complexMatrix2D2);
        ComplexMatrix2D complexMatrix2D3 = new ComplexMatrix2D();
        Complex complex2 = new Complex(0.0, 1.0);
        complex2 = new Complex(complex2.times(2.0 * d).dividedBy(complex.minus(complex2.times(d))));
        complexMatrix2D3.entries[1][1] = complex2.times(new Complex(complexMatrix2D2.entries[1][1])).plus(1.0);
        complexMatrix2D3.entries[1][2] = complex2.times(new Complex(complexMatrix2D2.entries[1][2]));
        complexMatrix2D3.entries[2][1] = complex2.times(new Complex(complexMatrix2D2.entries[2][1]));
        complexMatrix2D3.entries[2][2] = complex2.times(new Complex(complexMatrix2D2.entries[2][2])).plus(1.0);
        return complexMatrix2D3;
    }

    public synchronized Vector3D surfacePoint(double d, double d2) {
        this.xVar = d;
        this.tVar = d2;
        this.getE0(d, d2, new Complex(0.0, -this.s.getValue()));
        ComplexMatrix2D complexMatrix2D = new ComplexMatrix2D(this.E0);
        this.lambda = new Complex(1.0 + this.epsilon, 0.0);
        ComplexMatrix2D complexMatrix2D2 = new ComplexMatrix2D(this.getgPerp(complexMatrix2D, this.s.getValue(), this.lambda, this.initVec));
        this.getg1(this.lambda);
        this.getE0(d, d2, this.lambda);
        ComplexMatrix2D complexMatrix2D3 = new ComplexMatrix2D(this.g1.multiply(this.E0.multiply(complexMatrix2D2.conjugate().transpose())));
        this.lambda = new Complex(1.0 - this.epsilon, 0.0);
        complexMatrix2D2 = new ComplexMatrix2D(this.getgPerp(complexMatrix2D, this.s.getValue(), this.lambda, this.initVec));
        this.getg1(this.lambda);
        this.getE0(d, d2, this.lambda);
        ComplexMatrix2D complexMatrix2D4 = new ComplexMatrix2D(this.g1.multiply(this.E0.multiply(complexMatrix2D2.conjugate().transpose())));
        complexMatrix2D3 = new ComplexMatrix2D(complexMatrix2D3.subtract(complexMatrix2D4));
        complexMatrix2D3 = new ComplexMatrix2D(complexMatrix2D3.scalarMul(new Complex(1.0 / (2.0 * this.epsilon), 0.0)));
        this.lambda = new Complex(1.0, 0.0);
        complexMatrix2D2 = new ComplexMatrix2D(this.getgPerp(complexMatrix2D, this.s.getValue(), this.lambda, this.initVec));
        this.getg1(this.lambda);
        this.getE0(d, d2, this.lambda);
        complexMatrix2D3 = complexMatrix2D3.multiply(complexMatrix2D2.multiply(this.E0.inverse().multiply(this.g1.inverse())));
        double d3 = complexMatrix2D3.entries[1][1].im;
        double d4 = complexMatrix2D3.entries[1][2].re;
        double d5 = complexMatrix2D3.entries[1][2].im;
        if (Double.isNaN(d3) || Double.isNaN(d3) || Double.isNaN(d3)) {
            d5 = 0.0;
            d4 = 0.0;
            d3 = 0.0;
        }
        return new Vector3D(d3, d4, d5);
    }
}

