/*
 * Decompiled with CFR 0.152.
 */
package vmm.pseudospherical;

import vmm.core.Complex;

public class ComplexVector2D {
    public Complex x;
    public Complex y;

    public ComplexVector2D() {
        this.x = new Complex(Complex.ZERO_C);
        this.y = new Complex(Complex.ZERO_C);
    }

    public ComplexVector2D(Complex complex, Complex complex2) {
        this.x = new Complex(complex);
        this.y = new Complex(complex2);
    }

    public ComplexVector2D(ComplexVector2D complexVector2D) {
        if (complexVector2D == null) {
            this.x = this.y = new Complex(0.0, 0.0);
        } else {
            this.x = new Complex(complexVector2D.x);
            this.y = new Complex(complexVector2D.y);
        }
    }

    public boolean equals(Object object) {
        if (object == null || !object.getClass().equals(ComplexVector2D.class)) {
            return false;
        }
        ComplexVector2D complexVector2D = (ComplexVector2D)object;
        return complexVector2D.x.equals(this.x) && complexVector2D.y.equals(this.y);
    }

    public void negate() {
        this.x = this.x.times(-1.0);
        this.y = this.y.times(-1.0);
    }

    public ComplexVector2D plus(ComplexVector2D complexVector2D) {
        return new ComplexVector2D(this.x.plus(complexVector2D.x), this.y.plus(complexVector2D.y));
    }

    public ComplexVector2D minus(ComplexVector2D complexVector2D) {
        return new ComplexVector2D(this.x.minus(complexVector2D.x), this.y.minus(complexVector2D.y));
    }

    public Complex dot(ComplexVector2D complexVector2D) {
        Complex complex = new Complex(this.x.times(complexVector2D.x.conj()));
        Complex complex2 = new Complex(this.y.times(complexVector2D.y.conj()));
        return complex.plus(complex2);
    }

    public ComplexVector2D times(Complex complex) {
        return new ComplexVector2D(complex.times(this.x), complex.times(this.y));
    }

    public double norm2() {
        return this.dot((ComplexVector2D)this).re;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }
}

