/*
 * Decompiled with CFR 0.152.
 */
package vmm.pseudospherical;

import vmm.core.Complex;
import vmm.pseudospherical.ComplexVector2D;

public class ComplexMatrix2D {
    Complex[][] entries = new Complex[3][3];

    public ComplexMatrix2D() {
        this.initialize();
    }

    public ComplexMatrix2D(ComplexMatrix2D complexMatrix2D) {
        if (complexMatrix2D == null) {
            this.initialize();
        } else {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.entries[i][j] = complexMatrix2D.entries[i][j];
                }
            }
        }
    }

    public void initialize() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.entries[i][j] = new Complex(0.0, 0.0);
            }
        }
    }

    public Complex getMatrixEntry(int n, int n2) {
        if (n <= 0 || n >= 3 || n2 <= 0 || n2 >= 3) {
            return null;
        }
        return this.entries[n][n2];
    }

    public void setMatrixEntry(Complex complex, int n, int n2) {
        if (n > 0 && n < 3 && n2 > 0 && n2 < 3) {
            this.entries[n][n2] = complex;
        }
    }

    public ComplexMatrix2D inverse() {
        Complex complex;
        ComplexMatrix2D complexMatrix2D = new ComplexMatrix2D();
        Complex complex2 = this.entries[1][1].times(this.entries[2][2]).minus(this.entries[2][1].times(this.entries[1][2]));
        if (complex2.equals(complex = new Complex(0.0, 0.0))) {
            return null;
        }
        complexMatrix2D.entries[1][1] = this.entries[2][2].dividedBy(complex2);
        complexMatrix2D.entries[2][2] = this.entries[1][1].dividedBy(complex2);
        complexMatrix2D.entries[1][2] = complex.minus(this.entries[1][2]).dividedBy(complex2);
        complexMatrix2D.entries[2][1] = complex.minus(this.entries[2][1]).dividedBy(complex2);
        return complexMatrix2D;
    }

    public ComplexMatrix2D multiply(ComplexMatrix2D complexMatrix2D) {
        ComplexMatrix2D complexMatrix2D2 = new ComplexMatrix2D();
        for (int i = 1; i < 3; ++i) {
            for (int j = 1; j < 3; ++j) {
                complexMatrix2D2.entries[i][j] = new Complex();
                for (int k = 1; k < 3; ++k) {
                    complexMatrix2D2.entries[i][j] = complexMatrix2D2.entries[i][j].plus(this.entries[i][k].times(complexMatrix2D.entries[k][j]));
                }
            }
        }
        return complexMatrix2D2;
    }

    public ComplexMatrix2D transpose() {
        ComplexMatrix2D complexMatrix2D = new ComplexMatrix2D();
        complexMatrix2D.entries[1][1] = this.entries[1][1];
        complexMatrix2D.entries[1][2] = this.entries[2][1];
        complexMatrix2D.entries[2][1] = this.entries[1][2];
        complexMatrix2D.entries[2][2] = this.entries[2][2];
        return complexMatrix2D;
    }

    public ComplexMatrix2D conjugate() {
        ComplexMatrix2D complexMatrix2D = new ComplexMatrix2D();
        complexMatrix2D.entries[1][1] = this.entries[1][1].conj();
        complexMatrix2D.entries[1][2] = this.entries[1][2].conj();
        complexMatrix2D.entries[2][1] = this.entries[2][1].conj();
        complexMatrix2D.entries[2][2] = this.entries[2][2].conj();
        return complexMatrix2D;
    }

    public ComplexMatrix2D add(ComplexMatrix2D complexMatrix2D) {
        ComplexMatrix2D complexMatrix2D2 = new ComplexMatrix2D();
        complexMatrix2D2.entries[1][1] = this.entries[1][1].plus(complexMatrix2D.entries[1][1]);
        complexMatrix2D2.entries[1][2] = this.entries[1][2].plus(complexMatrix2D.entries[1][2]);
        complexMatrix2D2.entries[2][1] = this.entries[2][1].plus(complexMatrix2D.entries[2][1]);
        complexMatrix2D2.entries[2][2] = this.entries[2][2].plus(complexMatrix2D.entries[2][2]);
        return complexMatrix2D2;
    }

    public ComplexMatrix2D subtract(ComplexMatrix2D complexMatrix2D) {
        ComplexMatrix2D complexMatrix2D2 = new ComplexMatrix2D();
        complexMatrix2D2.entries[1][1] = this.entries[1][1].minus(complexMatrix2D.entries[1][1]);
        complexMatrix2D2.entries[1][2] = this.entries[1][2].minus(complexMatrix2D.entries[1][2]);
        complexMatrix2D2.entries[2][1] = this.entries[2][1].minus(complexMatrix2D.entries[2][1]);
        complexMatrix2D2.entries[2][2] = this.entries[2][2].minus(complexMatrix2D.entries[2][2]);
        return complexMatrix2D2;
    }

    public ComplexMatrix2D scalarMul(Complex complex) {
        ComplexMatrix2D complexMatrix2D = new ComplexMatrix2D();
        complexMatrix2D.entries[1][1] = this.entries[1][1].times(complex);
        complexMatrix2D.entries[1][2] = this.entries[1][2].times(complex);
        complexMatrix2D.entries[2][1] = this.entries[2][1].times(complex);
        complexMatrix2D.entries[2][2] = this.entries[2][2].times(complex);
        return complexMatrix2D;
    }

    public boolean equals(ComplexMatrix2D complexMatrix2D) {
        return this.entries[1][1].equals(complexMatrix2D.entries[1][1]) && this.entries[1][2].equals(complexMatrix2D.entries[1][2]) && this.entries[2][1].equals(complexMatrix2D.entries[2][1]) && this.entries[2][2].equals(complexMatrix2D.entries[2][2]);
    }

    public String toString() {
        String string = new String();
        string = string + "{{";
        string = string + this.entries[1][1].toString();
        string = string + ",";
        string = string + this.entries[1][2].toString();
        string = string + "},{";
        string = string + this.entries[2][1].toString();
        string = string + ",";
        string = string + this.entries[2][2].toString();
        string = string + "}}";
        return string;
    }

    public static ComplexMatrix2D getProj(ComplexVector2D complexVector2D) {
        ComplexMatrix2D complexMatrix2D = new ComplexMatrix2D();
        double d = complexVector2D.norm2();
        complexMatrix2D.entries[1][1] = complexVector2D.x.times(complexVector2D.x.conj()).dividedBy(d);
        complexMatrix2D.entries[1][2] = complexVector2D.x.times(complexVector2D.y.conj()).dividedBy(d);
        complexMatrix2D.entries[2][1] = complexVector2D.y.times(complexVector2D.x.conj()).dividedBy(d);
        complexMatrix2D.entries[2][2] = complexVector2D.y.times(complexVector2D.y.conj()).dividedBy(d);
        return complexMatrix2D;
    }

    public ComplexVector2D vectMul(ComplexVector2D complexVector2D) {
        Complex complex = new Complex(this.entries[1][1].times(complexVector2D.x).plus(this.entries[1][2].times(complexVector2D.y)));
        Complex complex2 = new Complex(this.entries[2][1].times(complexVector2D.x).plus(this.entries[2][2].times(complexVector2D.y)));
        return new ComplexVector2D(complex, complex2);
    }

    public Complex trace() {
        return this.entries[1][1].plus(this.entries[2][2]);
    }

    public Complex determinant() {
        return this.entries[1][1].times(this.entries[2][2]).minus(this.entries[1][2].times(this.entries[2][1]));
    }
}

