/*
 * Decompiled with CFR 0.152.
 */
package vmm.pseudospherical;

import vmm.core.Complex;
import vmm.core.ComplexParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.pseudospherical.ComplexMatrix2D;
import vmm.pseudospherical.ComplexVector2D;
import vmm.pseudospherical.nSolitons;

public class Breather
extends nSolitons {
    public ComplexParamAnimateable alpha = new ComplexParamAnimateable("alpha", new Complex(0.6, 0.8), new Complex(1.0, 0.0), new Complex(0.0, 1.0));
    public ComplexVector2D vect = new ComplexVector2D(new Complex(1.0, 0.0), new Complex(2.0, 1.0));
    private ComplexMatrix2D g1_alpha;
    private ComplexMatrix2D g2_alpha;

    public Breather() {
        int n;
        int n2;
        this.s.setName("s");
        this.addParameter(this.alpha);
        this.addParameter(this.s);
        this.umin.reset(-4.5);
        this.umax.reset(3.5);
        this.vmin.reset("-3*pi");
        this.vmax.reset("3*pi");
        this.setDefaultWindow(-1.47301, 3.02699, -1.40071, 2.09929);
        this.setDefaultViewpoint(new Vector3D(-3.78115, -6.81146, 1.90246));
        this.setDefaultViewUp(new Vector3D(-0.855955, 0.505503, 0.108658));
        this.lambda = new Complex(0.0, 1.0);
        this.E = new ComplexMatrix2D[2][6];
        for (n2 = 0; n2 <= 1; ++n2) {
            for (n = 0; n < 6; ++n) {
                this.E[n2][n] = new ComplexMatrix2D();
            }
        }
        this.g = new ComplexMatrix2D[2][5];
        for (n2 = 0; n2 <= 1; ++n2) {
            for (n = 0; n < 5; ++n) {
                this.g[n2][n] = new ComplexMatrix2D();
            }
        }
        this.E0 = new ComplexMatrix2D();
        this.getE0(this.xVar, this.s.getValue(), this.lambda);
        this.proj = ComplexMatrix2D.getProj(this.initVec);
        this.id = new ComplexMatrix2D();
        this.id.setMatrixEntry(Complex.ONE_C, 1, 1);
        this.id.setMatrixEntry(Complex.ZERO_C, 1, 2);
        this.id.setMatrixEntry(Complex.ZERO_C, 2, 1);
        this.id.setMatrixEntry(Complex.ONE_C, 2, 2);
        this.g1 = new ComplexMatrix2D();
        this.g1_alpha = this.getG1_alpha(this.lambda, this.alpha.getValue(), this.vect);
        this.g2_alpha = this.getG2_alpha(this.lambda, this.alpha.getValue(), this.vect);
    }

    public ComplexMatrix2D getG1_alpha(Complex complex, Complex complex2, ComplexVector2D complexVector2D) {
        ComplexMatrix2D complexMatrix2D = this.getProj(complexVector2D);
        ComplexMatrix2D complexMatrix2D2 = this.id.subtract(complexMatrix2D);
        Complex complex3 = complex2.minus(complex2.conj());
        complex3 = complex3.dividedBy(complex.minus(complex2));
        ComplexMatrix2D complexMatrix2D3 = new ComplexMatrix2D();
        complexMatrix2D3.entries[1][1] = new Complex(complex3.times(complexMatrix2D2.entries[1][1]).plus(1.0));
        complexMatrix2D3.entries[1][2] = new Complex(complex3.times(complexMatrix2D2.entries[1][2]));
        complexMatrix2D3.entries[2][1] = new Complex(complex3.times(complexMatrix2D2.entries[2][1]));
        complexMatrix2D3.entries[2][2] = new Complex(complex3.times(complexMatrix2D2.entries[2][2]).plus(1.0));
        return complexMatrix2D3;
    }

    public ComplexMatrix2D getG2_alpha(Complex complex, Complex complex2, ComplexVector2D complexVector2D) {
        ComplexMatrix2D complexMatrix2D = this.getG1_alpha(Complex.ZERO_C.minus(complex2.conj()), complex2, complexVector2D);
        ComplexVector2D complexVector2D2 = new ComplexVector2D(complexVector2D.x.conj(), complexVector2D.y.conj());
        ComplexVector2D complexVector2D3 = complexMatrix2D.vectMul(complexVector2D2);
        return this.getG1_alpha(complex, Complex.ZERO_C.minus(complex2.conj()), complexVector2D3);
    }

    public ComplexMatrix2D compBreather(double d, double d2, boolean bl) {
        this.lambda = new Complex(1.0 + this.epsilon, 0.0);
        ComplexMatrix2D complexMatrix2D = this.getH_alpha(this.lambda, this.alpha.getValue(), this.vect);
        this.lambda = new Complex(1.0 - this.epsilon, 0.0);
        ComplexMatrix2D complexMatrix2D2 = this.getH_alpha(this.lambda, this.alpha.getValue(), this.vect);
        this.lambda = new Complex(1.0, 0.0);
        ComplexMatrix2D complexMatrix2D3 = this.getH_alpha(this.lambda, this.alpha.getValue(), this.vect);
        ComplexMatrix2D complexMatrix2D4 = new ComplexMatrix2D();
        if (!bl) {
            this.getE0(d, d2, this.alpha.getValue().conj());
            ComplexMatrix2D complexMatrix2D5 = new ComplexMatrix2D(this.E0.conjugate().transpose());
            ComplexVector2D complexVector2D = complexMatrix2D5.vectMul(this.vect);
            this.lambda = new Complex(1.0 + this.epsilon, 0.0);
            ComplexMatrix2D complexMatrix2D6 = new ComplexMatrix2D(this.getG1_alpha(this.lambda, this.alpha.getValue(), complexVector2D));
            ComplexMatrix2D complexMatrix2D7 = new ComplexMatrix2D(this.getG2_alpha(this.lambda, this.alpha.getValue(), complexVector2D));
            ComplexMatrix2D complexMatrix2D8 = new ComplexMatrix2D(complexMatrix2D7.multiply(complexMatrix2D6));
            complexMatrix2D4 = complexMatrix2D.multiply(this.E[0][0]).multiply(complexMatrix2D8.conjugate().transpose());
            this.lambda = new Complex(1.0 - this.epsilon, 0.0);
            complexMatrix2D6 = new ComplexMatrix2D(this.getG1_alpha(this.lambda, this.alpha.getValue(), complexVector2D));
            complexMatrix2D7 = new ComplexMatrix2D(this.getG2_alpha(this.lambda, this.alpha.getValue(), complexVector2D));
            complexMatrix2D8 = new ComplexMatrix2D(complexMatrix2D7.multiply(complexMatrix2D6));
            complexMatrix2D4 = complexMatrix2D4.subtract(complexMatrix2D2.multiply(this.E[0][1]).multiply(complexMatrix2D8.conjugate().transpose()));
            complexMatrix2D4 = complexMatrix2D4.scalarMul(new Complex(1.0 / (2.0 * this.epsilon), 0.0));
            this.lambda = new Complex(1.0, 0.0);
            complexMatrix2D6 = new ComplexMatrix2D(this.getG1_alpha(this.lambda, this.alpha.getValue(), complexVector2D));
            complexMatrix2D7 = new ComplexMatrix2D(this.getG2_alpha(this.lambda, this.alpha.getValue(), complexVector2D));
            complexMatrix2D8 = new ComplexMatrix2D(complexMatrix2D7.multiply(complexMatrix2D6));
            complexMatrix2D4 = complexMatrix2D4.multiply(complexMatrix2D8.multiply(this.E[0][2].conjugate().transpose()).multiply(complexMatrix2D3.conjugate().transpose()));
        } else {
            this.getE0(d, d2, this.alpha.getValue().conj());
            this.getg1(this.alpha.getValue().conj());
            ComplexMatrix2D complexMatrix2D9 = this.getg1Perp(this.alpha.getValue().conj());
            complexMatrix2D9 = this.g1.multiply(this.E0).multiply(complexMatrix2D9.inverse());
            complexMatrix2D9 = complexMatrix2D9.conjugate().transpose();
            ComplexVector2D complexVector2D = complexMatrix2D9.vectMul(this.vect);
            this.lambda = new Complex(1.0 + this.epsilon, 0.0);
            ComplexMatrix2D complexMatrix2D10 = new ComplexMatrix2D(this.getG1_alpha(this.lambda, this.alpha.getValue(), complexVector2D));
            ComplexMatrix2D complexMatrix2D11 = new ComplexMatrix2D(this.getG2_alpha(this.lambda, this.alpha.getValue(), complexVector2D));
            ComplexMatrix2D complexMatrix2D12 = complexMatrix2D11.multiply(complexMatrix2D10);
            complexMatrix2D4 = complexMatrix2D.multiply(this.E[1][0]).multiply(complexMatrix2D12.conjugate().transpose());
            this.lambda = new Complex(1.0 - this.epsilon, 0.0);
            complexMatrix2D10 = new ComplexMatrix2D(this.getG1_alpha(this.lambda, this.alpha.getValue(), complexVector2D));
            complexMatrix2D11 = new ComplexMatrix2D(this.getG2_alpha(this.lambda, this.alpha.getValue(), complexVector2D));
            complexMatrix2D12 = complexMatrix2D11.multiply(complexMatrix2D10);
            complexMatrix2D4 = complexMatrix2D4.subtract(complexMatrix2D2.multiply(this.E[1][1]).multiply(complexMatrix2D12.conjugate().transpose()));
            complexMatrix2D4 = complexMatrix2D4.scalarMul(new Complex(1.0 / (2.0 * this.epsilon), 0.0));
            this.lambda = new Complex(1.0, 0.0);
            complexMatrix2D10 = new ComplexMatrix2D(this.getG1_alpha(this.lambda, this.alpha.getValue(), complexVector2D));
            complexMatrix2D11 = new ComplexMatrix2D(this.getG2_alpha(this.lambda, this.alpha.getValue(), complexVector2D));
            complexMatrix2D12 = complexMatrix2D11.multiply(complexMatrix2D10);
            complexMatrix2D4 = complexMatrix2D4.multiply(complexMatrix2D12.multiply(this.E[1][2].conjugate().transpose()).multiply(complexMatrix2D3.conjugate().transpose()));
        }
        return complexMatrix2D4;
    }

    public ComplexMatrix2D getH_alpha(Complex complex, Complex complex2, ComplexVector2D complexVector2D) {
        this.g1_alpha = this.getG1_alpha(complex, complex2, complexVector2D);
        this.g2_alpha = this.getG2_alpha(complex, complex2, complexVector2D);
        return this.g2_alpha.multiply(this.g1_alpha);
    }

    public synchronized Vector3D surfacePoint(double d, double d2) {
        ComplexMatrix2D complexMatrix2D = this.firstSoliton(d, d2);
        complexMatrix2D = this.compBreather(d, d2, false);
        double d3 = complexMatrix2D.entries[1][1].im;
        double d4 = complexMatrix2D.entries[1][2].re;
        double d5 = complexMatrix2D.entries[1][2].im;
        if (Double.isNaN(d3) || Double.isNaN(d3) || Double.isNaN(d3)) {
            d5 = 0.0;
            d4 = 0.0;
            d3 = 0.0;
        }
        return new Vector3D(d3, d4, d5);
    }
}

