/*
 * Decompiled with CFR 0.152.
 */
package vmm.polyhedron;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.actions.ActionRadioGroup;
import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.RealParamAnimateable;
import vmm.core.TimerAnimation;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.Transform3D;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;
import vmm.polyhedron.IFS;

public abstract class RegularPolyhedron
extends IFS {
    protected Vector3D[] polyhedronVertices;
    protected int[][] polyhedronFaces;
    private int[][] edgeList;
    private Vector3D[] mangledPolyhedronVertices;
    private int[][] mangledPolyhedronFaces;
    private boolean mangledPolyhedronIsStellated = false;
    @VMMSave
    private boolean stellationWanted = false;
    private double currentTruncation = -1.0;
    protected double stellationScale = 0.5;
    protected double stellationHeight = 1.0;
    private double stellationDegree = 1.0;
    private double stellationDegreeUsed = -1.0;
    protected RealParamAnimateable truncation;
    protected ActionRadioGroup truncationSelect = new ActionRadioGroup(new String[]{I18n.tr("vmm.polyhedron.RegularPolyhedron.NoTruncation"), I18n.tr("vmm.polyhedron.RegularPolyhedron.StandardTruncation"), I18n.tr("vmm.polyhedron.RegularPolyhedron.MidpointTruncation"), I18n.tr("vmm.polyhedron.RegularPolyhedron.Stellated")}, 0){

        public void optionSelected(int n) {
            if (n == 0) {
                RegularPolyhedron.this.truncation.setValue(1.0);
            } else if (n == 1) {
                RegularPolyhedron.this.truncation.setValueFromString("2/3");
            } else if (n == 2) {
                RegularPolyhedron.this.truncation.setValueFromString("1/2");
            }
            RegularPolyhedron.this.setStellationWanted(n == 3);
        }
    };

    protected RegularPolyhedron() {
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-2.0, 2.0, -2.0, 2.0);
        this.truncation = new RealParamAnimateable("vmm.polyhedron.RegularPolyhedron.truncation", "1", "1", "1/2");
        this.truncation.setMinimumValueForInput(0.5);
        this.truncation.setMaximumValueForInput(1.0);
        this.addParameter(this.truncation);
    }

    public boolean getStellationWanted() {
        return this.stellationWanted;
    }

    public void setStellationWanted(boolean bl) {
        if (this.stellationWanted == bl) {
            return;
        }
        this.stellationWanted = bl;
        if (bl) {
            this.truncationSelect.setSelectedIndex(3);
        } else {
            double d = this.truncation.getValue();
            if (d > 0.995) {
                this.truncationSelect.setSelectedIndex(0);
            } else if (Math.abs(d - 0.6666666666666666) < 0.005) {
                this.truncationSelect.setSelectedIndex(1);
            } else if (d < 0.505) {
                this.truncationSelect.setSelectedIndex(2);
            } else {
                this.truncationSelect.setSelectedIndex(-1);
            }
        }
        this.forceRedraw();
    }

    protected void computeDrawData3D(View3D view3D, boolean bl, Transform3D transform3D, Transform3D transform3D2) {
        double d = 1.0 - this.truncation.getValue();
        if (d <= 0.005) {
            d = 0.0;
        } else if (d >= 0.495) {
            d = 0.5;
        }
        if (this.stellationWanted) {
            if (!this.mangledPolyhedronIsStellated || this.stellationDegree != this.stellationDegreeUsed) {
                this.makeStellatedPolyhedron();
                this.mangledPolyhedronIsStellated = true;
                this.setIFSData(this.mangledPolyhedronVertices, this.mangledPolyhedronFaces);
            }
        } else if (this.mangledPolyhedronIsStellated || d != this.currentTruncation) {
            if (d == 0.0) {
                this.mangledPolyhedronFaces = null;
                this.mangledPolyhedronVertices = null;
                this.setIFSData(this.polyhedronVertices, this.polyhedronFaces);
            } else {
                if (this.edgeList == null) {
                    this.makeEdgeList();
                }
                this.makeTruncatedPolyhedron(d);
                this.setIFSData(this.mangledPolyhedronVertices, this.mangledPolyhedronFaces);
            }
            this.currentTruncation = d;
            this.mangledPolyhedronIsStellated = false;
        }
        super.computeDrawData3D(view3D, bl, transform3D, transform3D2);
    }

    public ActionList getActionsForView(View view) {
        ActionList actionList = super.getActionsForView(view);
        actionList.add(null);
        actionList.add(this.truncationSelect);
        return actionList;
    }

    public void parameterChanged(Parameter parameter, Object object, Object object2) {
        super.parameterChanged(parameter, object, object2);
        if (parameter == this.truncation) {
            this.stellationWanted = false;
            double d = this.truncation.getValue();
            if (d > 0.995) {
                this.truncationSelect.setSelectedIndex(0);
            } else if (Math.abs(d - 0.6666666666666666) < 0.005) {
                this.truncationSelect.setSelectedIndex(1);
            } else if (d < 0.505) {
                this.truncationSelect.setSelectedIndex(2);
            } else {
                this.truncationSelect.setSelectedIndex(-1);
            }
        }
    }

    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actionList = super.getAdditionalAnimationsForView(view);
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.polyhedron.RegularPolyhedron.StellationMorph")){

            public void actionPerformed(ActionEvent actionEvent) {
                TimerAnimation timerAnimation = new TimerAnimation(){

                    protected void animationStarting() {
                        RegularPolyhedron.this.stellationDegree = 0.0;
                        RegularPolyhedron.this.truncation.setValue(1.0);
                        RegularPolyhedron.this.setStellationWanted(true);
                        RegularPolyhedron.this.forceRedraw();
                    }

                    protected void animationEnding() {
                        RegularPolyhedron.this.stellationDegree = 1.0;
                        RegularPolyhedron.this.forceRedraw();
                    }

                    protected void drawFrame() {
                        RegularPolyhedron.this.stellationDegree = (double)this.getFrameNumber() / (double)this.getFrames();
                        RegularPolyhedron.this.forceRedraw();
                    }
                };
                timerAnimation.setLooping(2);
                timerAnimation.setFrames(RegularPolyhedron.this.getFramesForMorphing());
                view.getDisplay().installAnimation(timerAnimation);
            }
        });
        return actionList;
    }

    private void makeEdgeList() {
        this.edgeList = new int[this.polyhedronVertices.length][];
        for (int i = 0; i < this.polyhedronVertices.length; ++i) {
            int n;
            Object object;
            int n2;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int[][] nArray = this.polyhedronFaces;
            int n3 = nArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                object = nArray[n2];
                for (n = 0; n < ((int[])object).length; ++n) {
                    int vector3D3;
                    if (object[n] != i) continue;
                    int vector3D2 = n == ((int[])object).length - 1 ? object[0] : object[n + 1];
                    int n4 = vector3D3 = n == 0 ? object[((int[])object).length - 1] : object[n - 1];
                    if (!arrayList.contains(vector3D2)) {
                        arrayList.add(vector3D2);
                    }
                    if (arrayList.contains(vector3D3)) continue;
                    arrayList.add(vector3D3);
                }
            }
            int[] object2 = new int[arrayList.size()];
            object2[0] = (Integer)arrayList.remove(0);
            Vector3D vector3D = this.polyhedronVertices[i];
            block3: for (n2 = 1; n2 < object2.length; ++n2) {
                object = this.polyhedronVertices[object2[n2 - 1]];
                for (n = 0; n < arrayList.size(); ++n) {
                    Vector3D vector3D2 = this.polyhedronVertices[(Integer)arrayList.get(n)];
                    Vector3D vector3D3 = vector3D.minus((Vector3D)object).cross(vector3D2.minus((Vector3D)object));
                    boolean bl = true;
                    for (int j = 0; j < arrayList.size(); ++j) {
                        if (j == n || !(vector3D3.dot(this.polyhedronVertices[(Integer)arrayList.get(j)].minus((Vector3D)object)) > 0.0)) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    object2[n2] = (Integer)arrayList.remove(n);
                    continue block3;
                }
            }
            this.edgeList[i] = object2;
        }
    }

    private void makeTruncatedPolyhedron(double d) {
        int n;
        int n2 = 0;
        for (int[] nArray : this.polyhedronFaces) {
            n2 += nArray.length;
        }
        int n3 = n2;
        this.mangledPolyhedronVertices = new Vector3D[n3];
        int n4 = this.polyhedronFaces.length + this.polyhedronVertices.length;
        this.mangledPolyhedronFaces = new int[n4][];
        int n5 = 0;
        int n6 = 0;
        int[] nArray = new int[this.polyhedronVertices.length];
        for (n = 0; n < this.polyhedronVertices.length; ++n) {
            nArray[n] = n6;
            int[] nArray2 = new int[this.edgeList[n].length];
            for (int i = 0; i < this.edgeList[n].length; ++i) {
                this.mangledPolyhedronVertices[n6] = this.polyhedronVertices[n].plus(this.polyhedronVertices[this.edgeList[n][i]].minus(this.polyhedronVertices[n]).times(d));
                nArray2[i] = n6++;
            }
            this.mangledPolyhedronFaces[n5++] = nArray2;
        }
        for (n = 0; n < this.polyhedronFaces.length; ++n) {
            int n7 = this.polyhedronFaces[n].length;
            if (d < 0.5) {
                n7 *= 2;
            }
            int[] nArray3 = new int[n7];
            int n8 = 0;
            for (int i = 0; i < this.polyhedronFaces[n].length; ++i) {
                int n9;
                int n10 = this.polyhedronFaces[n][i];
                int n11 = this.polyhedronFaces[n][i == this.polyhedronFaces[n].length - 1 ? 0 : i + 1];
                int n12 = nArray[n10];
                for (n9 = 0; n9 < this.edgeList[n10].length && this.edgeList[n10][n9] != n11; ++n9) {
                }
                assert (n9 < this.edgeList[n10].length);
                nArray3[n8++] = n12 + n9;
                if (!(d < 0.5)) continue;
                n12 = nArray[n11];
                for (n9 = 0; n9 < this.edgeList[n11].length && this.edgeList[n11][n9] != n10; ++n9) {
                }
                assert (n9 < this.edgeList[n11].length);
                nArray3[n8++] = n12 + n9;
            }
            this.mangledPolyhedronFaces[n5++] = nArray3;
        }
    }

    private void makeStellatedPolyhedron() {
        int n = this.polyhedronVertices.length + this.polyhedronFaces.length;
        this.mangledPolyhedronVertices = new Vector3D[n];
        int n2 = 0;
        for (int[] nArray : this.polyhedronFaces) {
            n2 += nArray.length;
        }
        this.mangledPolyhedronFaces = new int[n2][];
        for (int i = 0; i < this.polyhedronVertices.length; ++i) {
            this.mangledPolyhedronVertices[i] = this.polyhedronVertices[i].times(this.stellationScale);
        }
        double d = this.stellationHeight * this.stellationScale;
        int n3 = this.polyhedronVertices.length;
        int n4 = 0;
        for (int[] nArray : this.polyhedronFaces) {
            Vector3D object;
            Vector3D vector3D = this.mangledPolyhedronVertices[nArray[1]].minus(this.mangledPolyhedronVertices[nArray[0]]);
            Vector3D vector3D2 = this.mangledPolyhedronVertices[nArray[2]].minus(this.mangledPolyhedronVertices[nArray[1]]);
            Vector3D vector3D3 = vector3D2.cross(vector3D).normalized();
            Vector3D vector3D4 = new Vector3D(0.0, 0.0, 0.0);
            int[] nArray2 = nArray;
            int n5 = nArray2.length;
            for (int i = 0; i < n5; ++i) {
                int n6 = nArray2[i];
                vector3D4.assignPlus(this.mangledPolyhedronVertices[n6]);
            }
            vector3D4 = vector3D4.times(1.0 / (double)nArray.length);
            this.mangledPolyhedronVertices[n3] = object = vector3D4.plus(vector3D3.times(d * this.stellationDegree));
            for (n5 = 1; n5 < nArray.length; ++n5) {
                this.mangledPolyhedronFaces[n4++] = new int[]{nArray[n5 - 1], nArray[n5], n3};
            }
            this.mangledPolyhedronFaces[n4++] = new int[]{nArray[nArray.length - 1], nArray[0], n3++};
        }
        this.stellationDegreeUsed = this.stellationDegree;
        assert (n3 == this.mangledPolyhedronVertices.length);
        assert (n4 == this.mangledPolyhedronFaces.length);
    }
}

