/*
 * Decompiled with CFR 0.152.
 */
package vmm.polyhedron;

import java.awt.event.ActionEvent;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.core.I18n;
import vmm.core.TimerAnimation;
import vmm.core.View;
import vmm.core3D.Vector3D;
import vmm.polyhedron.RegularPolyhedron;

public class Icosahedron
extends RegularPolyhedron {
    public Icosahedron() {
        double d = (Math.sqrt(5.0) - 1.0) / 2.0;
        this.polyhedronVertices = new Vector3D[]{new Vector3D(-1.0, -d, 0.0), new Vector3D(0.0, 1.0, d), new Vector3D(0.0, 1.0, -d), new Vector3D(1.0, d, 0.0), new Vector3D(1.0, -d, 0.0), new Vector3D(0.0, -1.0, -d), new Vector3D(0.0, -1.0, d), new Vector3D(d, 0.0, 1.0), new Vector3D(-d, 0.0, 1.0), new Vector3D(d, 0.0, -1.0), new Vector3D(-d, 0.0, -1.0), new Vector3D(-1.0, d, 0.0)};
        this.polyhedronFaces = new int[][]{{3, 7, 1}, {4, 7, 3}, {6, 7, 4}, {8, 7, 6}, {7, 8, 1}, {9, 4, 3}, {2, 9, 3}, {2, 3, 1}, {11, 2, 1}, {10, 2, 11}, {10, 9, 2}, {9, 5, 4}, {6, 4, 5}, {0, 6, 5}, {0, 11, 8}, {11, 1, 8}, {10, 0, 5}, {10, 5, 9}, {0, 8, 6}, {0, 10, 11}};
        this.setDefaultWindow(-1.3, 1.3, -1.3, 1.3);
        this.stellationScale = 0.45;
        this.stellationHeight = 1.8683447179254318;
    }

    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actionList = super.getAdditionalAnimationsForView(view);
        AbstractActionVMM abstractActionVMM = new AbstractActionVMM(I18n.tr("vmm.polyhedron.Icosahedron.EdgeLengthMorphCommand")){

            public void actionPerformed(ActionEvent actionEvent) {
                view.getDisplay().installAnimation(new EdgeLengthMorph());
            }
        };
        actionList.add(abstractActionVMM);
        return actionList;
    }

    private class EdgeLengthMorph
    extends TimerAnimation {
        double saveTruncation;

        EdgeLengthMorph() {
            super(Icosahedron.this.getFramesForMorphing(), 50);
            this.setLooping(2);
        }

        protected void animationStarting() {
            this.saveTruncation = Icosahedron.this.truncation.getValue();
            Icosahedron.this.truncation.setValue(1.0);
            Icosahedron.this.setStellationWanted(false);
            Icosahedron.this.useBackFaceFudge = true;
        }

        protected void animationEnding() {
            this.setEdgeLength((Math.sqrt(5.0) - 1.0) / 2.0);
            Icosahedron.this.truncation.setValue(this.saveTruncation);
            Icosahedron.this.useBackFaceFudge = false;
        }

        protected void drawFrame() {
            this.setEdgeLength((double)this.getFrameNumber() * ((Math.sqrt(5.0) - 1.0) / 2.0) / (double)this.getFrames());
        }

        void setEdgeLength(double d) {
            Icosahedron.this.polyhedronVertices[1].z = d;
            Icosahedron.this.polyhedronVertices[2].z = -d;
            Icosahedron.this.polyhedronVertices[3].y = d;
            Icosahedron.this.polyhedronVertices[4].y = -d;
            Icosahedron.this.polyhedronVertices[5].z = -d;
            Icosahedron.this.polyhedronVertices[6].z = d;
            Icosahedron.this.polyhedronVertices[7].x = d;
            Icosahedron.this.polyhedronVertices[8].x = -d;
            Icosahedron.this.polyhedronVertices[9].x = d;
            Icosahedron.this.polyhedronVertices[10].x = -d;
            Icosahedron.this.polyhedronVertices[0].y = -d;
            Icosahedron.this.polyhedronVertices[11].y = d;
            Icosahedron.this.setIFSData(Icosahedron.this.polyhedronVertices, Icosahedron.this.polyhedronFaces);
            Icosahedron.this.forceRedraw();
        }
    }
}

