/*
 * Decompiled with CFR 0.152.
 */
package vmm.polyhedron;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import vmm.actions.ActionList;
import vmm.actions.ToggleAction;
import vmm.core.Animation;
import vmm.core.I18n;
import vmm.core.TimerAnimation;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.Exhibit3D;
import vmm.core3D.PhongLighting;
import vmm.core3D.Transform3D;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;
import vmm.core3D.View3DLit;

public class IFS
extends Exhibit3D {
    protected int edgeDivisor = 8;
    protected boolean useBackFaceFudge = false;
    private Vector3D[] vertices;
    private int[][] faces;
    private Vector3D[] unitNormals;
    private ArrayList<int[]> edges;
    private ArrayList<Face> clippedFaces;
    private ArrayList<Segment> clippedEdges;

    public IFS(Vector3D[] vector3DArray, int[][] nArray) {
        this.setIFSData(vector3DArray, nArray);
    }

    protected IFS() {
    }

    protected void setIFSData(Vector3D[] vector3DArray, int[][] nArray) {
        this.vertices = vector3DArray;
        this.faces = nArray;
        this.edges = new ArrayList();
        for (int[] nArray2 : nArray) {
            block1: for (int i = 0; i < nArray2.length; ++i) {
                int n = nArray2[i];
                int n2 = i == nArray2.length - 1 ? nArray2[0] : nArray2[i + 1];
                for (int[] nArray3 : this.edges) {
                    if ((nArray3[0] != n || nArray3[1] != n2) && (nArray3[0] != n2 || nArray3[1] != n)) continue;
                    continue block1;
                }
                this.edges.add(new int[]{n, n2});
            }
        }
        this.unitNormals = new Vector3D[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray4 = nArray[i];
            Vector3D vector3D = null;
            for (int j = 0; j < nArray4.length; ++j) {
                Vector3D vector3D2 = vector3DArray[nArray4[j]];
                Vector3D vector3D3 = vector3DArray[nArray4[(j + 1) % nArray4.length]];
                Vector3D vector3D4 = vector3DArray[nArray4[(j + 2) % nArray4.length]];
                vector3D = vector3D4.minus(vector3D3).cross(vector3D2.minus(vector3D3));
                vector3D.normalize();
                if (!Double.isNaN(vector3D.x)) break;
            }
            if (vector3D == null) {
                vector3D = new Vector3D(0.0, 0.0, 1.0);
            }
            this.unitNormals[i] = vector3D;
        }
        this.clippedFaces = null;
        this.clippedEdges = null;
        this.forceRedraw();
    }

    protected void computeDrawData3D(View3D view3D, boolean bl, Transform3D transform3D, Transform3D transform3D2) {
        if (this.clippedFaces == null || bl || !transform3D2.hasSameProjection(transform3D)) {
            this.clip(view3D);
        }
    }

    protected void doDraw3D(Graphics2D graphics2D, View3D view3D, Transform3D transform3D) {
        boolean bl = false;
        if (!(view3D instanceof View3DLit)) {
            bl = true;
        } else if (((View3DLit)view3D).getRenderingStyle() == 0) {
            bl = true;
        } else if (((View3DLit)view3D).getFastDrawing() && !((View3DLit)view3D).getDragAsSurface()) {
            bl = true;
        }
        if (bl) {
            boolean bl2 = true;
            if (view3D instanceof IFSView) {
                bl2 = ((IFSView)view3D).getThickWireframe();
            }
            Color color = graphics2D.getColor();
            Stroke stroke = graphics2D.getStroke();
            BasicStroke basicStroke = new BasicStroke(transform3D.getDefaultStrokeSize() * 5.0f, 0, 0);
            BasicStroke basicStroke2 = new BasicStroke(transform3D.getDefaultStrokeSize(), 0, 0);
            for (Segment segment : this.clippedEdges) {
                if (segment.wd) {
                    graphics2D.setStroke(basicStroke);
                    graphics2D.setColor(bl2 ? color : graphics2D.getBackground());
                } else {
                    graphics2D.setStroke(basicStroke2);
                    graphics2D.setColor(bl2 ? graphics2D.getBackground() : color);
                }
                view3D.drawLine(segment.v1, segment.v2);
            }
            graphics2D.setColor(color);
            graphics2D.setStroke(stroke);
        } else {
            View3DLit view3DLit = (View3DLit)view3D;
            int n = -1;
            if (view3D instanceof IFSView) {
                n = ((IFSView)view3D).sidesToDraw;
            }
            if (n < 0) {
                n = this.clippedFaces.size();
            }
            int n2 = (int)(255.0 * (1.0 - view3DLit.getTransparency()));
            for (int i = 0; i < n; ++i) {
                Object object;
                Face face = this.clippedFaces.get(i);
                if (view3DLit.getLightingEnabled()) {
                    object = PhongLighting.phongLightingColor(face.unitNormal, view3DLit, view3DLit.getTransform3D(), face.centerPoint, Color.white);
                    if (n2 < 255) {
                        object = new Color(((Color)object).getRed(), ((Color)object).getGreen(), ((Color)object).getBlue(), n2);
                    }
                    view3D.setColor((Color)object);
                } else {
                    view3D.setColor(Color.WHITE);
                }
                object = new Vector3D[face.vertexIndices.length];
                for (int j = 0; j < face.vertexIndices.length; ++j) {
                    object[j] = this.vertices[face.vertexIndices[j]];
                }
                view3DLit.fillPolygon((Vector3D[])object, Color.BLACK);
            }
        }
    }

    public View getDefaultView() {
        return new IFSView();
    }

    public Animation getCreateAnimation(View view) {
        if (!(view instanceof IFSView)) {
            return null;
        }
        final IFSView iFSView = (IFSView)view;
        return new TimerAnimation(-1, 200){

            protected void drawFrame() {
                iFSView.sidesToDraw++;
                if (IFS.this.clippedFaces != null && iFSView.sidesToDraw >= IFS.this.clippedFaces.size()) {
                    this.cancel();
                } else {
                    if (IFS.this.clippedFaces != null && this.getMillisecondsPerFrame() * IFS.this.clippedFaces.size() > 3000) {
                        this.setMillisecondsPerFrame(3000 / IFS.this.clippedFaces.size());
                    }
                    IFS.this.fireExhibitChangeEvent();
                }
            }

            protected void animationStarting() {
                iFSView.sidesToDraw = 0;
                IFS.this.fireExhibitChangeEvent();
            }

            protected void animationEnding() {
                iFSView.sidesToDraw = -1;
                IFS.this.fireExhibitChangeEvent();
            }
        };
    }

    public ActionList getActionsForView(View view) {
        ActionList actionList = super.getActionsForView(view);
        if (view instanceof IFSView) {
            actionList.add(null);
            actionList.add(((IFSView)view).thickWireframeToggle);
        }
        return actionList;
    }

    private void clip(View3D view3D) {
        Object object;
        Transform3D transform3D = view3D.getTransform3D();
        this.clippedFaces = new ArrayList();
        block0: for (int i = 0; i < this.faces.length; ++i) {
            int[] object22 = this.faces[i];
            for (int n : object22) {
                if (view3D.clip(this.vertices[n])) continue block0;
            }
            object = new Face(object22, this.unitNormals[i]);
            this.clippedFaces.add((Face)object);
        }
        for (Face face : this.clippedFaces) {
            face.computeZ(transform3D);
        }
        Collections.sort(this.clippedFaces);
        this.clippedEdges = new ArrayList();
        for (int[] nArray : this.edges) {
            object = this.vertices[nArray[0]];
            Vector3D vector3D = this.vertices[nArray[1]];
            Vector3D vector3D2 = vector3D.minus((Vector3D)object).times(1.0 / (double)this.edgeDivisor);
            Object object2 = object;
            for (int i = 0; i < this.edgeDivisor; ++i) {
                Vector3D vector3D3;
                Vector3D vector3D4 = vector3D3 = i == this.edgeDivisor - 1 ? vector3D : ((Vector3D)object).plus(vector3D2.times(i));
                if (!view3D.clip((Vector3D)object2) && !view3D.clip(vector3D3)) {
                    this.clippedEdges.add(new Segment((Vector3D)object2, vector3D3, true));
                    this.clippedEdges.add(new Segment((Vector3D)object2, vector3D3, false));
                }
                object2 = vector3D3;
            }
        }
        for (Segment segment : this.clippedEdges) {
            segment.computeZ(transform3D);
        }
        Collections.sort(this.clippedEdges);
    }

    public static class IFSView
    extends View3DLit {
        private int sidesToDraw = -1;
        @VMMSave
        private boolean thickWireframe = true;
        protected ToggleAction thickWireframeToggle = new ToggleAction(I18n.tr("vmm.polyhedron.IFS.thickWireframe"), true){

            public void actionPerformed(ActionEvent actionEvent) {
                IFSView.this.setThickWireframe(this.getState());
            }
        };

        public IFSView() {
            this.setAntialiased(true);
            this.setDragAsSurface(true);
        }

        public boolean getThickWireframe() {
            return this.thickWireframe;
        }

        public void setThickWireframe(boolean bl) {
            if (this.thickWireframe == bl) {
                return;
            }
            this.thickWireframe = bl;
            this.thickWireframeToggle.setState(bl);
            this.forceRedraw();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Segment
    implements Comparable<Segment> {
        Vector3D v1;
        Vector3D v2;
        double centerZ;
        boolean wd;

        Segment(Vector3D vector3D, Vector3D vector3D2, boolean bl) {
            this.v1 = vector3D;
            this.v2 = vector3D2;
            this.wd = bl;
        }

        void computeZ(Transform3D transform3D) {
            this.centerZ = this.wd ? 1024.0 * Math.min(transform3D.objectToViewZ(this.v1), transform3D.objectToViewZ(this.v2)) : 1024.0 * Math.max(transform3D.objectToViewZ(this.v1), transform3D.objectToViewZ(this.v2)) + 8.0;
        }

        @Override
        public int compareTo(Segment segment) {
            if (this.centerZ == segment.centerZ) {
                return 0;
            }
            if (this.centerZ < segment.centerZ) {
                return -1;
            }
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Face
    implements Comparable<Face> {
        int[] vertexIndices;
        Vector3D unitNormal;
        Vector3D centerPoint;
        double centerZ;
        boolean isBackFace;

        Face(int[] nArray, Vector3D vector3D) {
            this.vertexIndices = nArray;
            this.unitNormal = vector3D;
            this.centerPoint = IFS.this.vertices[this.vertexIndices[0]];
            for (int i = 1; i < this.vertexIndices.length; ++i) {
                this.centerPoint = this.centerPoint.plus(IFS.this.vertices[this.vertexIndices[i]]);
            }
            this.centerPoint = this.centerPoint.times(1.0 / (double)this.vertexIndices.length);
        }

        void computeZ(Transform3D transform3D) {
            this.centerZ = 0.0;
            for (int n : this.vertexIndices) {
                this.centerZ += transform3D.objectToViewZ(IFS.this.vertices[n]);
            }
            this.centerZ /= (double)this.vertexIndices.length;
            if (IFS.this.useBackFaceFudge) {
                if (transform3D.getOrthographicProjection()) {
                    this.isBackFace = this.unitNormal.dot(transform3D.getViewDirection()) <= 0.0;
                } else {
                    Object object = IFS.this.vertices[this.vertexIndices[0]];
                    for (int i = 1; i < this.vertexIndices.length; ++i) {
                        object = ((Vector3D)object).plus(IFS.this.vertices[this.vertexIndices[i]]);
                    }
                    this.isBackFace = this.unitNormal.dot(((Vector3D)(object = ((Vector3D)object).times(1.0 / (double)this.vertexIndices.length))).minus(transform3D.getViewPoint())) <= 0.0;
                }
            } else {
                this.isBackFace = false;
            }
        }

        @Override
        public int compareTo(Face face) {
            if (this.isBackFace == face.isBackFace) {
                if (this.centerZ == face.centerZ) {
                    return 0;
                }
                if (this.centerZ < face.centerZ) {
                    return -1;
                }
                return 1;
            }
            if (this.isBackFace) {
                return -1;
            }
            return 1;
        }
    }
}

