/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import vmm.core.RealParamAnimateable;
import vmm.core.Transform;
import vmm.core.View;
import vmm.planecurve.parametric.DecoratedCurve;

public class Zykloide
extends DecoratedCurve {
    private RealParamAnimateable radius;
    private RealParamAnimateable stick;

    public Zykloide() {
        this.tResolution.setValueAndDefault(300);
        this.radius = new RealParamAnimateable("vmm.planecurve.parametric.Zykloide.radius", 3.0, 3.0, 3.0);
        this.stick = new RealParamAnimateable("vmm.planecurve.parametric.Zykloide.stick", 1.0, 0.2, 4.0);
        this.addParameter(this.radius);
        this.addParameter(this.stick);
        this.tmin.setValueAndDefaultFromString("-8*pi");
        this.tmax.setValueAndDefaultFromString("8*pi");
        this.setDefaultWindow(-20.0, 20.0, -6.0, 6.0);
    }

    public double xValue(double d) {
        double d2 = this.radius.getValue();
        double d3 = this.stick.getValue();
        return d + d3 * d2 * Math.cos(d / d2);
    }

    public double yValue(double d) {
        double d2 = this.radius.getValue();
        double d3 = this.stick.getValue();
        return -d3 * d2 * Math.sin(d / d2) + d2;
    }

    protected void drawNeededStuff(Graphics2D graphics2D, View view, Transform transform, double d) {
        Color color = graphics2D.getColor();
        double d2 = this.radius.getValue();
        double d3 = this.stick.getValue();
        double d4 = 1.0 - d3 * Math.sin(d / d2);
        double d5 = -d3 * Math.cos(d / d2);
        graphics2D.setColor(Color.red);
        if (d2 > 0.0) {
            graphics2D.draw(new Ellipse2D.Double(d - d2, 0.0, 2.0 * d2, 2.0 * d2));
        } else {
            graphics2D.draw(new Ellipse2D.Double(d + d2, 2.0 * d2, -2.0 * d2, -2.0 * d2));
        }
        graphics2D.setColor(Color.blue);
        graphics2D.draw(new Line2D.Double(this.xValue(d), this.yValue(d), d, 0.0));
        graphics2D.draw(new Line2D.Double(this.xValue(d) - 2.0 * d4, this.yValue(d) - 2.0 * d5, this.xValue(d) + 2.0 * d4, this.yValue(d) + 2.0 * d5));
        graphics2D.setColor(Color.green);
        graphics2D.draw(new Line2D.Double(d, d2, this.xValue(d), this.yValue(d)));
        graphics2D.setColor(color);
    }
}

