/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import vmm.core.Parameter;
import vmm.core.UserExhibit;
import vmm.core.VariableParamAnimateable;
import vmm.planecurve.parametric.PlaneCurveParametric;

public class UserPlaneCurveParametricKappa
extends PlaneCurveParametric
implements UserExhibit {
    private UserExhibit.Support userExhibitSupport;
    private UserExhibit.FunctionInfo kappa;
    double[] helpArray = new double[513];
    boolean needsNewHelpArray;
    double DT;
    double Tstart;

    public UserPlaneCurveParametricKappa() {
        this.tmin.reset(-10.0);
        this.tmax.reset(10.0);
        this.tResolution.reset(257);
        this.userExhibitSupport = new UserExhibit.Support(this);
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("a", 1.0, 1.0, 1.0));
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("b", 1.0, 0.5, 1.0));
        this.kappa = this.userExhibitSupport.addRealFunction("kappa", "b *(2+cos(a*t))", "t");
        this.setDefaultWindow(-2.0, 2.0, -2.0, 2.0);
        this.needsNewHelpArray = true;
        this.DT = (this.tmax.getValue() - this.tmin.getValue()) / (double)(this.helpArray.length - 1);
        this.Tstart = Math.max(Math.min(0.0, this.tmax.getValue()), this.tmin.getValue());
    }

    public void parameterChanged(Parameter parameter, Object object, Object object2) {
        super.parameterChanged(parameter, object, object2);
        this.needsNewHelpArray = true;
        this.Tstart = Math.max(Math.min(0.0, this.tmax.getValue()), this.tmin.getValue());
    }

    public double xValue(double d) {
        long l = 2L * Math.round(2.0 + 4.0 * Math.abs(d - this.Tstart));
        double d2 = 0.0;
        double d3 = Math.cos(this.angle(this.Tstart));
        if (d - this.Tstart != 0.0) {
            d2 += d3;
            double d4 = (d - this.Tstart) / (double)l;
            int n = 1;
            while ((long)n < l) {
                d3 = Math.cos(this.angle(this.Tstart + (double)n * d4));
                d2 += 4.0 * d3;
                d3 = Math.cos(this.angle(this.Tstart + (double)(n + 1) * d4));
                d2 += 2.0 * d3;
                n += 2;
            }
            d2 = (d2 - d3) * d4 / 3.0;
        }
        return d2;
    }

    public double yValue(double d) {
        long l = 2L * Math.round(2.0 + 4.0 * Math.abs(d - this.Tstart));
        double d2 = 0.0;
        double d3 = Math.sin(this.angle(this.Tstart));
        if (d - this.Tstart != 0.0) {
            d2 += d3;
            double d4 = (d - this.Tstart) / (double)l;
            int n = 1;
            while ((long)n < l) {
                d2 += 4.0 * Math.sin(this.angle(this.Tstart + (double)n * d4));
                d3 = Math.sin(this.angle(this.Tstart + (double)(n + 1) * d4));
                d2 += 2.0 * d3;
                n += 2;
            }
            d2 = (d2 - d3) * d4 / 3.0;
        }
        return d2;
    }

    public double xDerivativeValue(double d) {
        return Math.cos(this.angle(d));
    }

    public double yDerivativeValue(double d) {
        return Math.sin(this.angle(d));
    }

    public double x2ndDerivativeValue(double d) {
        return -Math.sin(this.angle(d)) * this.kappa.realFunctionValue(d);
    }

    public double y2ndDerivativeValue(double d) {
        return Math.cos(this.angle(d)) * this.kappa.realFunctionValue(d);
    }

    public UserExhibit.Support getUserExhibitSupport() {
        return this.userExhibitSupport;
    }

    private void recomputeHelpArray() {
        int n = 4;
        double d = this.tmin.getValue();
        this.DT = (this.tmax.getValue() - d) / (double)(this.helpArray.length - 1);
        double d2 = 0.0;
        double d3 = this.DT / (double)n;
        this.helpArray[0] = 0.0;
        for (int i = 1; i < this.helpArray.length; ++i) {
            double d4 = this.kappa.realFunctionValue(d);
            for (int j = 1; j < n; j += 2) {
                d4 += 4.0 * this.kappa.realFunctionValue(d + (double)j * d3);
                d2 = this.kappa.realFunctionValue(d + (double)(j + 1) * d3);
                d4 += 2.0 * d2;
            }
            d4 = (d4 - d2) * d3 / 3.0;
            d += this.DT;
            this.helpArray[i] = this.helpArray[i - 1] + d4;
        }
        this.needsNewHelpArray = false;
        double d5 = this.angle(this.Tstart);
        for (int i = 0; i < this.helpArray.length; ++i) {
            this.helpArray[i] = this.helpArray[i] - d5;
        }
    }

    private double angle(double d) {
        if (this.needsNewHelpArray) {
            this.recomputeHelpArray();
        }
        double d2 = 0.0;
        double d3 = 0.0;
        int n = (int)Math.max(0L, Math.min(Math.round((d - this.tmin.getValue()) / this.DT), (long)(this.helpArray.length - 1)));
        double d4 = this.tmin.getValue() + (double)n * this.DT;
        if (d == d4) {
            d2 = this.helpArray[n];
        } else {
            int n2 = (int)(2L * Math.round(2.0 + 8.0 * Math.abs(d - d4)));
            double d5 = (d - d4) / (double)n2;
            d2 += this.kappa.realFunctionValue(d4);
            for (int i = 1; i < n2; i += 2) {
                d2 += 4.0 * this.kappa.realFunctionValue(d4 + (double)i * d5);
                d3 = this.kappa.realFunctionValue(d4 + (double)(i + 1) * d5);
                d2 += 2.0 * d3;
            }
            d2 = this.helpArray[n] + (d2 - d3) * d5 / 3.0;
        }
        return d2;
    }
}

