/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import vmm.core.RealParamAnimateable;
import vmm.core.Transform;
import vmm.core.View;
import vmm.planecurve.parametric.DecoratedCurve;

public class Tractrix
extends DecoratedCurve {
    private RealParamAnimateable aa;
    private int pointCount;
    private double AA;
    double xa;
    double ya;
    double xb;
    double yb;
    double rotx;
    double roty;
    double tx;
    double ty;
    double dt;
    double nn;
    double ex;
    double ey;

    public Tractrix() {
        this.tResolution.setValueAndDefault(150);
        this.aa = new RealParamAnimateable("aa", 1.0, 0.75, 2.0);
        this.addParameter(this.aa);
        this.tmin.setValueAndDefault(0.01);
        this.tmax.setValueAndDefaultFromString("0.99*pi");
        this.setDefaultWindow(-1.75, 1.75, -1.75, 1.75);
        this.pointCount = 18000;
        this.randomSquare = this.fillRandomSquare(this.pointCount);
        this.movingSquare = this.initializeMovingSquare(this.pointCount);
    }

    public double xValue(double d) {
        this.AA = this.aa.getValue();
        return this.AA * Math.sin(d);
    }

    public double yValue(double d) {
        return this.AA * (Math.cos(d) + Math.log(Math.tan(d / 2.0)));
    }

    public View getDefaultView() {
        DecoratedCurve.MMOView mMOView = (DecoratedCurve.MMOView)super.getDefaultView();
        mMOView.simplifyActionMenu = false;
        mMOView.setUseCloud(false);
        return mMOView;
    }

    private void abbreviations(double d) {
        this.xa = this.xValue(d);
        this.ya = this.yValue(d);
        this.tx = Math.cos(d);
        this.ty = -Math.sin(d) + 1.0 / Math.sin(d);
        this.nn = Math.sqrt(this.tx * this.tx + this.ty * this.ty);
        if (this.nn == 0.0) {
            this.ex = 0.0;
            this.ey = 1.0;
        } else {
            this.ex = -this.ty / this.nn;
            this.ey = this.tx / this.nn;
        }
        this.roty = -this.xa * this.ty / this.tx + this.ya;
        this.rotx = this.xa - (this.roty - this.ya) * this.ty / this.tx;
        this.dt = (this.tmax.getValue() - this.tmin.getValue()) / (double)this.tResolution.getValue();
    }

    protected void drawNeededStuff(Graphics2D graphics2D, View view, Transform transform, double d) {
        DecoratedCurve.MMOView mMOView = (DecoratedCurve.MMOView)view;
        Color color = graphics2D.getColor();
        this.abbreviations(d);
        mMOView.setStrokeSizeMultiplier(3);
        graphics2D.setColor(Color.red);
        graphics2D.draw(new Line2D.Double(this.xa, this.ya, 0.0, this.roty));
        graphics2D.setColor(color);
        this.setStrokeSize(3);
        this.setWantedColor(Color.red);
        graphics2D.setColor(color);
        if (mMOView.getUseCloud()) {
            mMOView.setStrokeSizeMultiplier(1);
            graphics2D.setColor(Color.green);
            graphics2D.draw(new Line2D.Double(0.0, this.roty, this.rotx, this.roty));
            graphics2D.draw(new Line2D.Double(this.xa, this.ya, this.rotx, this.roty));
            graphics2D.draw(new Ellipse2D.Double(this.rotx - 0.03, this.roty - 0.03, 0.06, 0.06));
            graphics2D.setColor(Color.blue);
            this.abbreviations(d - this.dt);
            this.movingSquare = this.moveSquare(this.pointCount, this.xa, this.ya, this.ex, this.ey, 2.0 * this.AA);
            mMOView.drawPixels(this.movingSquare, 0, this.pointCount);
            this.abbreviations(d + this.dt);
            this.movingSquare = this.moveSquare(this.pointCount, this.xa, this.ya, this.ex, this.ey, 2.0 * this.AA);
            mMOView.drawPixels(this.movingSquare, 0, this.pointCount);
            mMOView.setStrokeSizeMultiplier(3);
        }
        graphics2D.setColor(color);
    }
}

