/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import vmm.core.Decoration;
import vmm.core.Exhibit;
import vmm.core.Transform;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.planecurve.parametric.PlaneCurveParametric;

public class TangentAndNormalDecoration
extends Decoration {
    private PlaneCurveParametric curve;
    @VMMSave
    private double t = Double.NaN;

    public PlaneCurveParametric getCurve() {
        return this.curve;
    }

    public void setCurve(PlaneCurveParametric planeCurveParametric) {
        this.curve = planeCurveParametric;
    }

    public void setT(double d) {
        this.t = d;
        this.fireDecorationChangeEvent();
    }

    public double getT() {
        return this.t;
    }

    public void setIndex(int n) {
        if (this.curve != null) {
            this.setT(this.curve.getT(n));
        }
    }

    public void doDraw(Graphics2D graphics2D, View view, Transform transform) {
        if (this.curve == null && view != null) {
            Exhibit exhibit = view.getExhibit();
            if (exhibit instanceof PlaneCurveParametric) {
                this.curve = (PlaneCurveParametric)exhibit;
            } else {
                return;
            }
        }
        if (Double.isNaN(this.t)) {
            return;
        }
        double d = this.curve.xValue(this.t);
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return;
        }
        double d2 = this.curve.yValue(this.t);
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            return;
        }
        double d3 = this.curve.xDerivativeValue(this.t);
        if (Double.isNaN(d3) || Double.isInfinite(d3)) {
            return;
        }
        double d4 = this.curve.yDerivativeValue(this.t);
        if (Double.isNaN(d4) || Double.isInfinite(d4)) {
            return;
        }
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        if (d5 == 0.0) {
            return;
        }
        d3 = d3 / d5 * 40.0 * transform.getPixelWidth();
        d4 = d4 / d5 * 40.0 * transform.getPixelHeight();
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(2.0f * transform.getDefaultStrokeSize()));
        graphics2D.setColor(Color.red);
        graphics2D.draw(new Line2D.Double(d, d2, d + d3, d2 + d4));
        graphics2D.setColor(Color.blue);
        graphics2D.draw(new Line2D.Double(d, d2, d - d4, d2 + d3));
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }
}

