/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import vmm.core.RealParamAnimateable;
import vmm.core.Transform;
import vmm.core.View;
import vmm.planecurve.parametric.DecoratedCurve;

public class SineCurve
extends DecoratedCurve {
    private RealParamAnimateable amplitude = new RealParamAnimateable("vmm.planecurve.parametric.SineCurve.amplitude", 1.0, 0.5, 2.0);
    private RealParamAnimateable frequency = new RealParamAnimateable("vmm.planecurve.parametric.SineCurve.frequency", 2.0, 1.0, 1.0);
    private RealParamAnimateable phase = new RealParamAnimateable("vmm.planecurve.parametric.SineCurve.phase", 0.0, 0.0, 0.0);

    public SineCurve() {
        this.phase.setMinimumValueForInput(0.0);
        this.phase.setMaximumValueForInput(Math.PI * 2);
        this.frequency.setMinimumValueForInput(Double.MIN_VALUE);
        this.addParameter(this.phase);
        this.addParameter(this.frequency);
        this.addParameter(this.amplitude);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("3*pi");
        this.tResolution.setValueAndDefaultFromString("300");
        this.setDefaultWindow(-2.5, 10.0, -2.0, 2.0);
    }

    public double xValue(double d) {
        return d;
    }

    public double yValue(double d) {
        double d2 = this.amplitude.getValue();
        double d3 = this.frequency.getValue();
        double d4 = this.phase.getValue();
        return d2 * Math.sin(d3 * (d - d4));
    }

    protected void drawNeededStuff(Graphics2D graphics2D, View view, Transform transform, double d) {
        double d2 = this.amplitude.getValue();
        double d3 = this.frequency.getValue();
        double d4 = this.phase.getValue();
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.blue);
        double d5 = d3 * d - Math.PI * 2 * Math.floor(d * d3 / 2.0 / Math.PI);
        Point2D[] point2DArray = this.myCircle(-d2, 0.0, d2, 120);
        view.drawCurve(point2DArray, 0, 120);
        double d6 = this.xValue(d);
        double d7 = this.yValue(d);
        view.setStrokeSizeMultiplier(2);
        graphics2D.setColor(Color.red);
        graphics2D.draw(new Line2D.Double(-d2, 0.0, d2 * Math.cos(d3 * (d - d4)) - d2, d2 * Math.sin(d3 * (d - d4))));
        if (d2 == 1.0) {
            view.drawCurve(point2DArray, 0, (int)Math.floor(120.0 * d5 / 2.0 / Math.PI));
            graphics2D.draw(new Line2D.Double(Math.PI * 2 * Math.floor(d * d3 / 2.0 / Math.PI) / d3, 0.0, d, 0.0));
        }
        graphics2D.setColor(Color.gray);
        graphics2D.draw(new Line2D.Double(d2 * Math.cos(d3 * (d - d4)) - d2, d2 * Math.sin(d3 * (d - d4)), d6, d7));
        graphics2D.draw(new Line2D.Double(d, 0.0, d, d2 * Math.sin(d3 * (d - d4))));
        view.setStrokeSizeMultiplier(1);
        graphics2D.setColor(color);
    }
}

