/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.actions.ToggleAction;
import vmm.core.Animation;
import vmm.core.Display;
import vmm.core.I18n;
import vmm.core.IntegerParam;
import vmm.core.RealParam;
import vmm.core.TimerAnimation;
import vmm.core.Transform;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.planecurve.PlaneCurve;
import vmm.planecurve.parametric.NormalBundleDecoration;
import vmm.planecurve.parametric.OsculatingCircleAnimation;
import vmm.planecurve.parametric.ParallelCurveAnimation;
import vmm.planecurve.parametric.TangentAndNormalDecoration;

public abstract class PlaneCurveParametric
extends PlaneCurve {
    protected IntegerParam tResolution;
    protected RealParam tmin = new RealParam("vmm.planecurve.parametric.PlaneCurveParameteric.tmin", -5.0);
    protected RealParam tmax = new RealParam("vmm.planecurve.parametric.PlaneCurveParameteric.tmax", 5.0);
    protected double[] tVals;

    public abstract double xValue(double var1);

    public abstract double yValue(double var1);

    public double xDerivativeValue(double d) {
        double d2 = 0.001;
        double d3 = this.xValue(d + d2);
        double d4 = this.xValue(d + 2.0 * d2);
        double d5 = this.xValue(d - d2);
        double d6 = this.xValue(d - 2.0 * d2);
        return (8.0 * d3 + d6 - (d4 + 8.0 * d5)) / (12.0 * d2);
    }

    public double yDerivativeValue(double d) {
        double d2 = 0.001;
        double d3 = this.yValue(d + d2);
        double d4 = this.yValue(d + 2.0 * d2);
        double d5 = this.yValue(d - d2);
        double d6 = this.yValue(d - 2.0 * d2);
        return (8.0 * d3 + d6 - (d4 + 8.0 * d5)) / (12.0 * d2);
    }

    public double x2ndDerivativeValue(double d) {
        double d2 = 0.001;
        double d3 = this.xValue(d);
        double d4 = this.xValue(d + d2);
        double d5 = this.xValue(d + 2.0 * d2);
        double d6 = this.xValue(d - d2);
        double d7 = this.xValue(d - 2.0 * d2);
        return (16.0 * d4 + 16.0 * d6 - 30.0 * d3 - d5 - d7) / (12.0 * d2 * d2);
    }

    public double y2ndDerivativeValue(double d) {
        double d2 = 0.001;
        double d3 = this.yValue(d);
        double d4 = this.yValue(d + d2);
        double d5 = this.yValue(d + 2.0 * d2);
        double d6 = this.yValue(d - d2);
        double d7 = this.yValue(d - 2.0 * d2);
        return (16.0 * d4 + 16.0 * d6 - 30.0 * d3 - d5 - d7) / (12.0 * d2 * d2);
    }

    public PlaneCurveParametric() {
        this.tResolution = new IntegerParam("vmm.planecurve.parametric.PlaneCurveParameteric.tResolution", 100);
        this.tResolution.setMinimumValueForInput(4);
        this.tResolution.setMaximumValueForInput(2000);
        this.addParameter(this.tResolution);
        this.addParameter(this.tmax);
        this.addParameter(this.tmin);
    }

    public int getTResolution() {
        return this.tResolution.getValue();
    }

    public double getT(int n) {
        if (this.tVals == null || n < 0 || n > this.tVals.length) {
            return Double.NaN;
        }
        return this.tVals[n];
    }

    public Point2D[] myCircle(double d, double d2, double d3, int n) {
        Point2D[] point2DArray = new Point2D[n + 1];
        double d4 = 0.0;
        for (int i = 0; i <= n; ++i) {
            d4 = (double)(i * 2) * Math.PI / (double)n;
            point2DArray[i] = new Point2D.Double(d + d3 * Math.cos(d4), d2 + d3 * Math.sin(d4));
        }
        return point2DArray;
    }

    protected void makePoints() {
        int n;
        int n2 = this.tResolution.getValue();
        this.tVals = new double[n2 + 1];
        this.points = new Point2D[n2 + 1];
        double d = this.tmin.getValue();
        double d2 = (this.tmax.getValue() - d) / (double)n2;
        for (n = 0; n <= n2; ++n) {
            this.tVals[n] = d + d2 * (double)n;
        }
        for (n = 0; n <= n2; ++n) {
            double d3 = this.xValue(this.tVals[n]);
            double d4 = this.yValue(this.tVals[n]);
            this.points[n] = Double.isNaN(d3) || Double.isNaN(d4) || Double.isInfinite(d3) || Double.isInfinite(d4) ? null : new Point2D.Double(d3, d4);
        }
    }

    public void doDraw(Graphics2D graphics2D, View view, Transform transform) {
        if (this.points.length == 0) {
            return;
        }
        int n = this.points.length;
        if (view instanceof PlaneCurveParametricView) {
            double d = ((PlaneCurveParametricView)view).fractionToDraw;
            if (d >= 0.0 && d < 1.0) {
                n = (int)(d * (double)n);
            }
            if (n == 0) {
                n = 1;
            }
        }
        view.drawCurve(this.points, n);
    }

    public Animation getCreateAnimation(final View view) {
        if (view == null || !(view instanceof PlaneCurveParametricView)) {
            return null;
        }
        return new TimerAnimation(50, 20){

            protected void drawFrame() {
                ((PlaneCurveParametricView)view).fractionToDraw = (double)this.frameNumber / 50.0;
                PlaneCurveParametric.this.forceRedraw();
            }

            public void animationStarting() {
                ((PlaneCurveParametricView)view).fractionToDraw = 0.0;
            }

            public void animationEnding() {
                ((PlaneCurveParametricView)view).fractionToDraw = 1.0;
                PlaneCurveParametric.this.forceRedraw();
            }
        };
    }

    public View getDefaultView() {
        PlaneCurveParametricView planeCurveParametricView = new PlaneCurveParametricView();
        planeCurveParametricView.setShowAxes(true);
        return planeCurveParametricView;
    }

    public ActionList getActionsForView(final View view) {
        ActionList actionList = super.getActionsForView(view);
        if (view == null) {
            return actionList;
        }
        actionList.add(null);
        double[] dArray = this.getDefaultWindow();
        final double d = Math.max(Math.abs(dArray[1] - dArray[0]), Math.abs(dArray[3] - dArray[2]));
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.planecurve.parametric.PlaneCurveParameteric.showParallelCurves")){

            public void actionPerformed(ActionEvent actionEvent) {
                Display display = view.getDisplay();
                display.installAnimation(new ParallelCurveAnimation(view, PlaneCurveParametric.this, false, d, d / 200.0));
            }
        });
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.planecurve.parametric.PlaneCurveParameteric.showParallelCurvesWithNormals")){

            public void actionPerformed(ActionEvent actionEvent) {
                Display display = view.getDisplay();
                display.installAnimation(new ParallelCurveAnimation(view, PlaneCurveParametric.this, true, d, d / 200.0));
            }
        });
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.planecurve.parametric.PlaneCurveParameteric.showOsculatingCircles")){

            public void actionPerformed(ActionEvent actionEvent) {
                Display display = view.getDisplay();
                display.installAnimation(new OsculatingCircleAnimation(view, PlaneCurveParametric.this, false, true));
            }
        });
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.planecurve.parametric.PlaneCurveParameteric.showOsculatingCirclesWithNormals")){

            public void actionPerformed(ActionEvent actionEvent) {
                Display display = view.getDisplay();
                display.installAnimation(new OsculatingCircleAnimation(view, PlaneCurveParametric.this));
            }
        });
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.planecurve.parametric.PlaneCurveParameteric.showTangentsAndNormals")){

            public void actionPerformed(ActionEvent actionEvent) {
                Display display = view.getDisplay();
                display.installAnimation(new TimerAnimation(PlaneCurveParametric.this.getTResolution(), 40){
                    TangentAndNormalDecoration dec;
                    {
                        this.dec = new TangentAndNormalDecoration();
                    }

                    protected void animationEnding() {
                        view.removeDecoration(this.dec);
                    }

                    protected void animationStarting() {
                        this.dec.setCurve(PlaneCurveParametric.this);
                        view.addDecoration(this.dec);
                    }

                    protected void drawFrame() {
                        this.dec.setIndex(this.getFrameNumber());
                    }
                });
            }
        });
        if (view instanceof PlaneCurveParametricView) {
            actionList.add(null);
            actionList.add(((PlaneCurveParametricView)view).showEvoluteAction);
        }
        return actionList;
    }

    public static class PlaneCurveParametricView
    extends View {
        @VMMSave
        private boolean showEvolute;
        private ToggleAction showEvoluteAction;
        private NormalBundleDecoration evolute;
        double fractionToDraw = -1.0;

        public PlaneCurveParametricView() {
            this.setAntialiased(true);
            this.showEvoluteAction = new ToggleAction(I18n.tr("vmm.planecurve.parametric.PlaneCurveParameteric.DisplayEvolute")){

                public void actionPerformed(ActionEvent actionEvent) {
                    PlaneCurveParametricView.this.setShowEvolute(this.getState());
                }
            };
        }

        public boolean getShowEvolute() {
            return this.showEvolute;
        }

        public void setShowEvolute(boolean bl) {
            if (this.showEvolute == bl) {
                return;
            }
            this.showEvolute = bl;
            this.showEvoluteAction.setState(bl);
            if (bl) {
                this.evolute = new NormalBundleDecoration();
                this.evolute.setShowEvolute(true);
                this.addDecoration(this.evolute);
            } else {
                this.removeDecoration(this.evolute);
                this.evolute = null;
            }
            this.forceRedraw();
        }

        NormalBundleDecoration getEvoluteDecoration() {
            return this.evolute;
        }
    }
}

