/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import vmm.core.Decorateable;
import vmm.core.ThreadedAnimation;
import vmm.planecurve.parametric.NormalBundleDecoration;
import vmm.planecurve.parametric.PlaneCurveParametric;

public class ParallelCurveAnimation
extends ThreadedAnimation {
    private PlaneCurveParametric curve;
    private Decorateable owner;
    private double offsetMax = 10.0;
    private double offsetIncrement = 0.05;
    private boolean showNormals;

    public ParallelCurveAnimation(PlaneCurveParametric planeCurveParametric) {
        this(planeCurveParametric, planeCurveParametric);
    }

    public ParallelCurveAnimation(Decorateable decorateable, PlaneCurveParametric planeCurveParametric) {
        this.owner = decorateable != null ? decorateable : planeCurveParametric;
        this.curve = planeCurveParametric;
    }

    public ParallelCurveAnimation(Decorateable decorateable, PlaneCurveParametric planeCurveParametric, boolean bl, double d, double d2) {
        this.owner = decorateable != null ? decorateable : planeCurveParametric;
        this.curve = planeCurveParametric;
        this.showNormals = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runAnimation() {
        NormalBundleDecoration normalBundleDecoration = new NormalBundleDecoration(this.curve);
        normalBundleDecoration.setLayer(2);
        this.owner.addDecoration(normalBundleDecoration);
        try {
            int n = this.curve.getTResolution();
            if (this.showNormals) {
                for (int i = 1; i <= n + 1; ++i) {
                    normalBundleDecoration.setPointCount(i);
                    this.pause(20);
                }
                this.pause(100);
                normalBundleDecoration.setPointCount(0);
            }
            normalBundleDecoration.setShowEvolute(true);
            this.pause(200);
            for (double d = 0.0; d <= this.offsetMax; d += this.offsetIncrement) {
                normalBundleDecoration.setParallelCurveOffset(d);
                this.pause(50);
            }
        }
        finally {
            this.owner.removeDecoration(normalBundleDecoration);
        }
    }
}

