/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.core.Complex;
import vmm.core.Decoration;
import vmm.core.Display;
import vmm.core.I18n;
import vmm.core.MouseTask;
import vmm.core.RealParamAnimateable;
import vmm.core.Transform;
import vmm.core.View;
import vmm.planecurve.parametric.ConicSection;
import vmm.planecurve.parametric.NormalBundleDecoration;

public class Parabola
extends ConicSection {
    private RealParamAnimateable focalLength = new RealParamAnimateable("vmm.planecurve.parametric.Parabola.FocalLength", 0.75, 0.5, 1.5);

    public Parabola() {
        this.tResolution.setValueAndDefault(192);
        this.tmin.setValueAndDefault(-8.0);
        this.tmax.setValueAndDefault(8.0);
        this.addParameter(this.focalLength);
        this.setDefaultWindow(-8.0, 8.0, -8.0, 8.0);
    }

    public double xValue(double d) {
        return d * d / (4.0 * this.focalLength.getValue());
    }

    public double yValue(double d) {
        return d;
    }

    public double xDerivativeValue(double d) {
        return d / (2.0 * this.focalLength.getValue());
    }

    public double yDerivativeValue(double d) {
        return 1.0;
    }

    public double x2ndDerivativeValue(double d) {
        return 1.0 / (2.0 * this.focalLength.getValue());
    }

    public double y2ndDerivativeValue(double d) {
        return 0.0;
    }

    protected void drawFociAndDirectrix(Graphics2D graphics2D, View view, Transform transform, double d) {
        double d2 = this.focalLength.getValue();
        Color color = graphics2D.getColor();
        double d3 = Math.abs(transform.getXmax() - transform.getXmin());
        double d4 = 3.0 * transform.getPixelWidth();
        graphics2D.setColor(Color.red);
        graphics2D.draw(new Line2D.Double(d2 - d4, -d4, d2 + d4, d4));
        graphics2D.draw(new Line2D.Double(d2 - d4, d4, d2 + d4, -d4));
        graphics2D.setColor(Color.blue);
        graphics2D.draw(new Line2D.Double(-d2, transform.getYmin(), -d2, transform.getYmax()));
        if (Double.isNaN(d)) {
            graphics2D.setColor(color);
            return;
        }
        double d5 = d * d / (4.0 * d2);
        double d6 = d;
        graphics2D.setColor(new Color(0, 150, 0));
        double d7 = d / (2.0 * d2);
        double d8 = 1.0;
        graphics2D.draw(new Line2D.Double(d5 - d3 * d7, d6 - d3 * d8, d5 + d3 * d7, d6 + d3 * d8));
        graphics2D.setColor(Color.red);
        if (d2 > 0.0) {
            graphics2D.draw(new Line2D.Double(d5, d6, d5 + d3, d6));
        } else {
            graphics2D.draw(new Line2D.Double(d5, d6, d5 - d3, d6));
        }
        graphics2D.setColor(Color.magenta);
        graphics2D.draw(new Line2D.Double(d5, d6, -d2, d6));
        graphics2D.draw(new Line2D.Double(-d2, d6, d2, 0.0));
        graphics2D.draw(new Line2D.Double(d2, 0.0, d5, d6));
        view.drawString("F", d2 + transform.getPixelWidth(), 4.0 * transform.getPixelHeight());
        if (this.focalLength.getValue() > 0.0) {
            view.drawString("S", -d2 - 10.0 * transform.getPixelWidth(), d6);
        } else {
            view.drawString("S", -d2 + 3.0 * transform.getPixelWidth(), d6);
        }
        graphics2D.setColor(color);
    }

    public ActionList getActionsForView(final View view) {
        ActionList actionList = super.getActionsForView(view);
        if (view == null) {
            return actionList;
        }
        actionList.add(null);
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.planecurve.parametric.Parabola.showNormalsWithMouse")){

            public void actionPerformed(ActionEvent actionEvent) {
                view.getDisplay().installOneShotMouseTask(new ShowNormalsMouseTask(view));
            }
        });
        return actionList;
    }

    private class NormalsThroughPoint
    extends Decoration {
        int x;
        int y;
        Line2D[] lines = new Line2D.Double[3];
        double[] params;
        Color darkGreen = new Color(0, 160, 0);

        private NormalsThroughPoint() {
        }

        void setPixel(int n, int n2) {
            if (this.x == n && this.y == n2) {
                return;
            }
            this.x = n;
            this.y = n2;
            this.fireDecorationChangeEvent();
        }

        Complex[] solveCubic(double d, double d2) {
            Complex[] complexArray = new Complex[3];
            double d3 = d2 * d2 / 4.0 - d * d * d;
            Complex complex = new Complex(d3).integerRoot(2);
            Complex complex2 = new Complex(d2 / 2.0).plus(complex);
            Complex complex3 = complex2.integerRoot(3);
            Complex complex4 = new Complex(d).dividedBy(complex3);
            complexArray[0] = complex3.plus(complex4);
            Complex complex5 = Complex.polar(1.0, 2.0943951023931953);
            Complex complex6 = Complex.polar(1.0, 4.1887902047863905);
            complexArray[1] = complex5.times(complex3).plus(complex6.times(complex4));
            complexArray[2] = complex6.times(complex3).plus(complex5.times(complex4));
            return complexArray;
        }

        public void computeDrawData(View view, boolean bl, Transform transform, Transform transform2) {
            double d = transform2.getXmin() + (double)(this.x - transform2.getX()) * transform2.getPixelWidth();
            double d2 = transform2.getYmax() - (double)(this.y - transform2.getY()) * transform2.getPixelHeight();
            double d3 = 10.0 * Math.abs(transform2.getXmax() - transform2.getXmin());
            double d4 = Parabola.this.focalLength.getValue();
            Complex[] complexArray = this.solveCubic(1.3333333333333333 * d4 * d - 2.6666666666666665 * d4 * d4, 8.0 * d4 * d4 * d2);
            for (int i = 0; i < 3; ++i) {
                if (Math.abs(complexArray[i].im) > 1.0E-5) {
                    this.lines[i] = null;
                    continue;
                }
                double d5 = Parabola.this.xValue(complexArray[i].re);
                double d6 = Parabola.this.yValue(complexArray[i].re);
                double d7 = d - d5;
                double d8 = d2 - d6;
                double d9 = Math.sqrt(d7 * d7 + d8 * d8);
                this.lines[i] = new Line2D.Double(d5, d6, d5 + d7 * d3 / d9, d6 + d8 * d3 / d9);
            }
            this.params = (double[])(Math.abs(complexArray[0].im) > 1.0E-5 || Math.abs(complexArray[1].im) > 1.0E-5 || Math.abs(complexArray[2].im) > 1.0E-5 ? null : new double[]{complexArray[0].re, complexArray[1].re, complexArray[2].re});
        }

        public void doDraw(Graphics2D graphics2D, View view, Transform transform) {
            Color color = graphics2D.getColor();
            if (this.lines[0] != null) {
                graphics2D.setColor(Color.red);
                graphics2D.draw(this.lines[0]);
            }
            if (this.lines[1] != null) {
                graphics2D.setColor(this.darkGreen);
                graphics2D.draw(this.lines[1]);
            }
            if (this.lines[2] != null) {
                graphics2D.setColor(Color.blue);
                graphics2D.draw(this.lines[2]);
            }
            if (this.params != null) {
                double d = transform.getPixelWidth();
                if (Parabola.this.focalLength.getValue() < 0.0) {
                    d = -d;
                }
                double d2 = transform.getPixelHeight();
                graphics2D.setColor(Color.red);
                graphics2D.draw(new Line2D.Double(-d * 90.0, 0.0, -d * 90.0, this.params[0]));
                graphics2D.setColor(this.darkGreen);
                graphics2D.draw(new Line2D.Double(-d * 80.0, 0.0, -d * 80.0, this.params[1]));
                graphics2D.setColor(Color.blue);
                graphics2D.draw(new Line2D.Double(-d * 70.0, 0.0, -d * 70.0, this.params[2]));
                double[] dArray = new double[]{Math.abs(this.params[0]), Math.abs(this.params[1]), Math.abs(this.params[2])};
                if (dArray[0] >= dArray[1] && dArray[0] >= dArray[2]) {
                    graphics2D.setColor(Color.red);
                    graphics2D.draw(new Line2D.Double(-d * 150.0, 0.0, -d * 150.0, dArray[0]));
                    graphics2D.setColor(this.darkGreen);
                    graphics2D.draw(new Line2D.Double(-d * 145.0, 0.0, -d * 145.0, dArray[1] - d2));
                    graphics2D.setColor(Color.blue);
                    graphics2D.draw(new Line2D.Double(-d * 145.0, dArray[1] + d2, -d * 145.0, dArray[1] + dArray[2]));
                } else if (dArray[1] >= dArray[0] && dArray[1] >= dArray[2]) {
                    graphics2D.setColor(this.darkGreen);
                    graphics2D.draw(new Line2D.Double(-d * 150.0, 0.0, -d * 150.0, dArray[1]));
                    graphics2D.setColor(Color.red);
                    graphics2D.draw(new Line2D.Double(-d * 145.0, 0.0, -d * 145.0, dArray[0] - d2));
                    graphics2D.setColor(Color.blue);
                    graphics2D.draw(new Line2D.Double(-d * 145.0, dArray[0] + d2, -d * 145.0, dArray[0] + dArray[2]));
                } else {
                    graphics2D.setColor(Color.blue);
                    graphics2D.draw(new Line2D.Double(-d * 150.0, 0.0, -d * 150.0, dArray[2]));
                    graphics2D.setColor(this.darkGreen);
                    graphics2D.draw(new Line2D.Double(-d * 145.0, 0.0, -d * 145.0, dArray[1] - d2));
                    graphics2D.setColor(Color.red);
                    graphics2D.draw(new Line2D.Double(-d * 145.0, dArray[1] + d2, -d * 145.0, dArray[1] + dArray[0]));
                }
            }
            graphics2D.setColor(color);
        }
    }

    private class ShowNormalsMouseTask
    extends MouseTask {
        View view;
        NormalBundleDecoration backgroundDecoration;
        NormalsThroughPoint normals;
        boolean saveShowAxes;

        ShowNormalsMouseTask(View view) {
            this.normals = new NormalsThroughPoint();
            this.view = view;
        }

        public void start(Display display, View view) {
            this.backgroundDecoration = new NormalBundleDecoration(Parabola.this);
            this.backgroundDecoration.setLayer(-2);
            this.backgroundDecoration.setNormalsColor(Color.lightGray);
            this.backgroundDecoration.setPointCount(Parabola.this.tResolution.getValue() + 1);
            this.backgroundDecoration.setEvoluteColor(new Color(0, 180, 180));
            this.backgroundDecoration.setShowEvolute(true);
            view.addDecoration(this.backgroundDecoration);
            this.saveShowAxes = view.getShowAxes();
            view.setShowAxes(true);
        }

        public void finish(Display display, View view) {
            view.removeDecoration(this.backgroundDecoration);
            view.removeDecoration(this.normals);
            view.setShowAxes(this.saveShowAxes);
        }

        public boolean doMouseDown(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            this.normals = new NormalsThroughPoint();
            this.normals.setLayer(-1);
            this.normals.setPixel(mouseEvent.getX(), mouseEvent.getY());
            view.addDecoration(this.normals);
            return true;
        }

        public void doMouseDrag(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            this.normals.setPixel(mouseEvent.getX(), mouseEvent.getY());
        }

        public Cursor getCursor(Display display, View view) {
            return Cursor.getPredefinedCursor(1);
        }
    }
}

