/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import vmm.core.Decorateable;
import vmm.core.ThreadedAnimation;
import vmm.planecurve.parametric.NormalBundleDecoration;
import vmm.planecurve.parametric.PlaneCurveParametric;

public class OsculatingCircleAnimation
extends ThreadedAnimation {
    private PlaneCurveParametric curve;
    private Decorateable owner;
    private boolean showNormals = true;
    private boolean showEvolute = false;

    public OsculatingCircleAnimation(PlaneCurveParametric planeCurveParametric) {
        this(planeCurveParametric, planeCurveParametric);
    }

    public OsculatingCircleAnimation(Decorateable decorateable, PlaneCurveParametric planeCurveParametric) {
        this.owner = decorateable != null ? decorateable : planeCurveParametric;
        this.curve = planeCurveParametric;
    }

    public OsculatingCircleAnimation(Decorateable decorateable, PlaneCurveParametric planeCurveParametric, boolean bl, boolean bl2) {
        this.owner = decorateable != null ? decorateable : planeCurveParametric;
        this.curve = planeCurveParametric;
        this.showNormals = bl;
        this.showEvolute = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runAnimation() {
        NormalBundleDecoration normalBundleDecoration = new NormalBundleDecoration(this.curve);
        this.owner.addDecoration(normalBundleDecoration);
        try {
            int n;
            int n2 = this.curve.getTResolution() + 1;
            if (this.showNormals) {
                for (n = 1; n <= n2; ++n) {
                    normalBundleDecoration.setPointCount(n);
                    this.pause(20);
                }
            }
            for (n = 0; n < 10; ++n) {
                for (int i = 0; i <= n2; ++i) {
                    normalBundleDecoration.setOsculatingCircleIndex(i, this.showEvolute);
                    this.pause(50);
                }
                this.pause(450);
            }
        }
        finally {
            this.owner.removeDecoration(normalBundleDecoration);
        }
    }
}

