/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import vmm.core.Decoration;
import vmm.core.Exhibit;
import vmm.core.Transform;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.planecurve.parametric.PlaneCurveParametric;

public class NormalBundleDecoration
extends Decoration {
    private PlaneCurveParametric curve;
    @VMMSave
    private int pointCt;
    private Line2D.Double[] unitNormals;
    private Line2D.Double[] evoluteNormals;
    private Line2D.Double[] lines;
    @VMMSave
    private boolean useUnitNormals = false;
    @VMMSave
    private boolean showEvolute = false;
    private boolean showEvoluteWithOsculatingCircle = false;
    @VMMSave
    private boolean showTwoParallelCurves = true;
    @VMMSave
    private double parallelCurveOffset = Double.NaN;
    @VMMSave
    private int osculatingCircleIndex = -1;
    private double maxNormalLength;
    @VMMSave
    private Color normalColor = Color.red;
    @VMMSave
    private Color evoluteColor = new Color(0, 200, 0);
    @VMMSave
    private Color osculatingCircleColor = Color.blue;
    @VMMSave
    private Color parallelCurveColor = new Color(60, 180, 180);
    @VMMSave
    private Color parallelCurveColor2 = new Color(200, 100, 100);

    public NormalBundleDecoration() {
    }

    public NormalBundleDecoration(PlaneCurveParametric planeCurveParametric) {
        this.curve = planeCurveParametric;
    }

    public PlaneCurveParametric getCurve() {
        return this.curve;
    }

    public void setCurve(PlaneCurveParametric planeCurveParametric) {
        this.curve = planeCurveParametric;
    }

    public void setPointCount(int n) {
        if (n < 0) {
            n = 0;
        }
        if (this.pointCt != n) {
            this.pointCt = n;
            this.fireDecorationChangeEvent();
        }
    }

    public int getPointCount() {
        return this.pointCt;
    }

    public boolean getShowEvolute() {
        return this.showEvolute;
    }

    public void setShowEvolute(boolean bl) {
        if (bl != this.showEvolute) {
            this.showEvolute = bl;
            this.fireDecorationChangeEvent();
        }
    }

    public double getParallelCurveOffset() {
        return this.parallelCurveOffset;
    }

    public void setParallelCurveOffset(double d) {
        if (!(d == this.parallelCurveOffset || Double.isNaN(d) && Double.isNaN(this.parallelCurveOffset))) {
            this.parallelCurveOffset = d;
            this.fireDecorationChangeEvent();
        }
    }

    public Color getNormalsColor() {
        return this.normalColor;
    }

    public void setNormalsColor(Color color) {
        if (color == null) {
            color = Color.red;
        }
        if (!color.equals(this.normalColor)) {
            this.normalColor = color;
            if (this.pointCt > 0) {
                this.fireDecorationChangeEvent();
            }
        }
    }

    public Color getEvoluteColor() {
        return this.evoluteColor;
    }

    public void setEvoluteColor(Color color) {
        if (color == null) {
            color = new Color(0, 200, 0);
        }
        if (!color.equals(this.evoluteColor)) {
            this.evoluteColor = color;
            if (this.showEvolute) {
                this.fireDecorationChangeEvent();
            }
        }
    }

    public Color getOsculatingCircleColor() {
        return this.osculatingCircleColor;
    }

    public void setOsculatingCircleColor(Color color) {
        if (color == null) {
            color = Color.blue;
        }
        if (!color.equals(this.osculatingCircleColor)) {
            this.osculatingCircleColor = color;
            if (this.osculatingCircleIndex >= 0) {
                this.fireDecorationChangeEvent();
            }
        }
    }

    public Color getParallelCurveColor() {
        return this.parallelCurveColor;
    }

    public void setParallelCurveColor(Color color) {
        if (color == null) {
            color = new Color(60, 180, 180);
        }
        if (!color.equals(this.parallelCurveColor)) {
            this.parallelCurveColor = color;
            if (!Double.isNaN(this.parallelCurveOffset)) {
                this.fireDecorationChangeEvent();
            }
        }
    }

    public Color getParallelCurveColor2() {
        return this.parallelCurveColor;
    }

    public void setParallelCurveColor2(Color color) {
        if (color == null) {
            color = new Color(200, 100, 100);
        }
        if (!color.equals(this.parallelCurveColor2)) {
            this.parallelCurveColor2 = color;
            if (!Double.isNaN(this.parallelCurveOffset) && this.showTwoParallelCurves) {
                this.fireDecorationChangeEvent();
            }
        }
    }

    public boolean getShowTwoParallelCurves() {
        return this.showTwoParallelCurves;
    }

    public void setShowTwoParallelCurves(boolean bl) {
        if (bl != this.showTwoParallelCurves) {
            this.showTwoParallelCurves = bl;
            if (!Double.isNaN(this.parallelCurveOffset)) {
                this.fireDecorationChangeEvent();
            }
        }
    }

    public boolean getUseUnitNormals() {
        return this.useUnitNormals;
    }

    public int getOsculatingCircleIndex() {
        return this.osculatingCircleIndex;
    }

    public void setOsculatingCircleIndex(int n) {
        this.setOsculatingCircleIndex(n, false);
    }

    public void setOsculatingCircleIndex(int n, boolean bl) {
        if (n < 0) {
            n = -1;
        }
        if (n != this.osculatingCircleIndex || bl != this.showEvoluteWithOsculatingCircle) {
            this.osculatingCircleIndex = n;
            this.showEvoluteWithOsculatingCircle = bl;
            this.fireDecorationChangeEvent();
        }
    }

    public void setUseUnitNormals(boolean bl) {
        if (bl != this.useUnitNormals) {
            this.useUnitNormals = bl;
            this.lines = bl ? this.unitNormals : this.evoluteNormals;
            this.fireDecorationChangeEvent();
        }
    }

    public Line2D[] getUnitNormals() {
        return this.unitNormals;
    }

    public void computeDrawData(View view, boolean bl, Transform transform, Transform transform2) {
        Exhibit exhibit;
        if (!bl && !this.decorationNeedsRedraw) {
            return;
        }
        if (this.curve == null && view != null && (exhibit = view.getExhibit()) instanceof PlaneCurveParametric) {
            this.curve = (PlaneCurveParametric)exhibit;
        }
        int n = this.curve.getTResolution();
        this.unitNormals = new Line2D.Double[n + 1];
        this.evoluteNormals = new Line2D.Double[n + 1];
        this.maxNormalLength = transform2.getPixelWidth() * 5000.0;
        for (int i = 0; i <= n; ++i) {
            double d = this.curve.getT(i);
            double d2 = this.curve.xValue(d);
            double d3 = this.curve.yValue(d);
            double d4 = this.curve.xDerivativeValue(d);
            double d5 = this.curve.yDerivativeValue(d);
            double d6 = this.curve.x2ndDerivativeValue(d);
            double d7 = this.curve.y2ndDerivativeValue(d);
            double d8 = Math.sqrt(d4 * d4 + d5 * d5);
            double d9 = d4 / d8;
            double d10 = d5 / d8;
            if (Double.isNaN(d2) || Double.isInfinite(d2) || Double.isNaN(d3) || Double.isInfinite(d3) || Double.isNaN(d9) || Double.isInfinite(d9) || Double.isNaN(d10) || Double.isInfinite(d10)) continue;
            this.unitNormals[i] = new Line2D.Double(d2, d3, d2 - d10, d3 + d9);
            if (Double.isNaN(d6) || Double.isInfinite(d6) || Double.isNaN(d7) || Double.isInfinite(d7)) continue;
            double d11 = (d4 * d7 - d5 * d6) / (d8 * d8 * d8);
            double d12 = 1.0 / d11;
            if (Math.abs(d12) > this.maxNormalLength) {
                d12 = d12 > 0.0 ? this.maxNormalLength : -this.maxNormalLength;
            }
            this.evoluteNormals[i] = new Line2D.Double(d2, d3, d2 - d10 * d12, d3 + d9 * d12);
        }
        this.lines = this.useUnitNormals ? this.unitNormals : this.evoluteNormals;
        this.decorationNeedsRedraw = false;
    }

    public void doDraw(Graphics2D graphics2D, View view, Transform transform) {
        double d;
        double d2;
        double d3;
        int n;
        Color color = graphics2D.getColor();
        double d4 = Math.max(transform.getXmax() - transform.getXmin(), transform.getYmax() - transform.getYmin()) / 4.0;
        int n2 = this.pointCt;
        if (n2 > this.curve.getTResolution()) {
            n2 = this.curve.getTResolution() + 1;
        }
        if (n2 > 0) {
            graphics2D.setColor(this.normalColor);
            for (n = 0; n < n2; ++n) {
                if (this.lines[n] == null) continue;
                graphics2D.draw(this.lines[n]);
            }
        }
        if ((n = this.osculatingCircleIndex) > this.curve.getTResolution()) {
            n = this.curve.getTResolution();
        }
        if (this.showEvolute || n >= 0) {
            graphics2D.setColor(this.evoluteColor);
            d3 = 5000.0 * transform.getPixelWidth();
            d2 = Double.NaN;
            double d5 = Double.NaN;
            int n3 = n >= 0 ? n + 1 : this.evoluteNormals.length;
            for (int i = 0; i < n3; ++i) {
                double d6;
                double d7;
                double d8 = 0.0;
                if (this.evoluteNormals[i] == null) {
                    d7 = Double.NaN;
                    d6 = Double.NaN;
                } else {
                    d6 = this.evoluteNormals[i].getX2();
                    d7 = this.evoluteNormals[i].getY2();
                    d8 = Math.sqrt(Math.pow(d6 - this.evoluteNormals[i].getX1(), 2.0) + Math.pow(d7 - this.evoluteNormals[i].getY1(), 2.0));
                }
                if (!Double.isNaN(d2) && !Double.isNaN(d5) && !Double.isNaN(d6) && !Double.isNaN(d7) && Math.sqrt((d2 - d6) * (d2 - d6) + (d5 - d7) * (d5 - d7)) < d4 && d8 <= d3) {
                    graphics2D.draw(new Line2D.Double(d2, d5, d6, d7));
                }
                d2 = d6;
                d5 = d7;
            }
        }
        if (n >= 0 && this.evoluteNormals[n] != null) {
            graphics2D.setColor(this.osculatingCircleColor);
            Line2D.Double double_ = this.evoluteNormals[n];
            graphics2D.draw(double_);
            double d9 = double_.getX1();
            double d10 = double_.getY1();
            d = double_.getX2() - double_.getX1();
            double d11 = double_.getY2() - double_.getY1();
            double d12 = Math.sqrt(d * d + d11 * d11);
            graphics2D.draw(new Ellipse2D.Double(d9 + d - d12, d10 + d11 - d12, 2.0 * d12, 2.0 * d12));
        }
        if (!Double.isNaN(this.parallelCurveOffset) && !Double.isInfinite(this.parallelCurveOffset)) {
            int n4;
            graphics2D.setColor(this.parallelCurveColor);
            d3 = Double.NaN;
            d2 = Double.NaN;
            for (n4 = 0; n4 < this.unitNormals.length; ++n4) {
                double d13;
                if (this.unitNormals[n4] == null) {
                    d13 = Double.NaN;
                    d = Double.NaN;
                } else {
                    Line2D.Double double_ = this.unitNormals[n4];
                    d = double_.getX1() + this.parallelCurveOffset * (double_.getX2() - double_.getX1());
                    d13 = double_.getY1() + this.parallelCurveOffset * (double_.getY2() - double_.getY1());
                }
                if (!(Double.isNaN(d3) || Double.isNaN(d2) || Double.isNaN(d) || Double.isNaN(d13) || !(Math.abs(d3 - d) + Math.abs(d2 - d13) <= d4))) {
                    graphics2D.draw(new Line2D.Double(d3, d2, d, d13));
                }
                d3 = d;
                d2 = d13;
            }
            if (this.showTwoParallelCurves) {
                graphics2D.setColor(this.parallelCurveColor2);
                d3 = Double.NaN;
                d2 = Double.NaN;
                for (n4 = 0; n4 < this.unitNormals.length; ++n4) {
                    double d14;
                    if (this.unitNormals[n4] == null) {
                        d14 = Double.NaN;
                        d = Double.NaN;
                    } else {
                        Line2D.Double double_ = this.unitNormals[n4];
                        d = double_.getX1() - this.parallelCurveOffset * (double_.getX2() - double_.getX1());
                        d14 = double_.getY1() - this.parallelCurveOffset * (double_.getY2() - double_.getY1());
                    }
                    if (!(Double.isNaN(d3) || Double.isNaN(d2) || Double.isNaN(d) || Double.isNaN(d14) || !(Math.abs(d3 - d) + Math.abs(d2 - d14) <= d4))) {
                        graphics2D.draw(new Line2D.Double(d3, d2, d, d14));
                    }
                    d3 = d;
                    d2 = d14;
                }
            }
        }
        graphics2D.setColor(color);
    }
}

