/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import vmm.core.RealParamAnimateable;
import vmm.planecurve.parametric.PlaneCurveParametric;

public class NephroidOfFreeth
extends PlaneCurveParametric {
    private RealParamAnimateable aa;

    public NephroidOfFreeth() {
        this.tResolution.setValueAndDefault(300);
        this.aa = new RealParamAnimateable("aa", 2.0, 0.0, 3.0);
        this.addParameter(this.aa);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("4*pi");
        this.setDefaultWindow(-4.0, 4.0, -4.0, 4.0);
    }

    private double Multiplier(double d) {
        double d2 = this.aa.getValue();
        return 1.0 - d2 * Math.sin(d / 2.0);
    }

    public double xValue(double d) {
        return this.Multiplier(d) * Math.cos(d);
    }

    public double yValue(double d) {
        return this.Multiplier(d) * Math.sin(d);
    }
}

