/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import vmm.core.RealParamAnimateable;
import vmm.planecurve.parametric.PlaneCurveParametric;

public class Logarithmicspiral
extends PlaneCurveParametric {
    private RealParamAnimateable aa;
    private RealParamAnimateable bb;

    public Logarithmicspiral() {
        this.tResolution.setValueAndDefault(500);
        this.aa = new RealParamAnimateable("aa", 1.0, 1.0, 1.0);
        this.bb = new RealParamAnimateable("bb", 0.08, 0.08, 0.04);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
        this.tmin.setValueAndDefaultFromString("0");
        this.tmax.setValueAndDefaultFromString("12*pi");
        this.setDefaultWindow(-10.0, 10.0, -10.0, 10.0);
    }

    public double xValue(double d) {
        double d2 = this.aa.getValue();
        double d3 = this.bb.getValue();
        return d2 * Math.exp(d3 * d) * Math.cos(d);
    }

    public double yValue(double d) {
        double d2 = this.aa.getValue();
        double d3 = this.bb.getValue();
        return d2 * Math.exp(d3 * d) * Math.sin(d);
    }
}

