/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import vmm.core.RealParamAnimateable;
import vmm.planecurve.parametric.PlaneCurveParametric;

public class Lissajous
extends PlaneCurveParametric {
    private RealParamAnimateable amplitude1;
    private RealParamAnimateable amplitude2;
    private RealParamAnimateable frequency1;
    private RealParamAnimateable frequency2;
    private RealParamAnimateable phase;

    public Lissajous() {
        this.tResolution.setValueAndDefault(500);
        this.amplitude1 = new RealParamAnimateable("vmm.planecurve.parametric.SineCurve.amplitude", 2.0, 2.0, 2.0);
        this.amplitude2 = new RealParamAnimateable("vmm.planecurve.parametric.SineCurve.amplitude", 2.0, 2.0, 2.0);
        this.frequency1 = new RealParamAnimateable("vmm.planecurve.parametric.SineCurve.frequency", 3.0, 1.0, 5.0);
        this.frequency2 = new RealParamAnimateable("vmm.planecurve.parametric.SineCurve.frequency", 5.0, 1.0, 7.0);
        this.phase = new RealParamAnimateable("vmm.planecurve.parametric.SineCurve.phase", 0.0, 0.0, 0.0);
        this.phase.setMinimumValueForInput(0.0);
        this.phase.setMaximumValueForInput(Math.PI * 2);
        this.frequency1.setMinimumValueForInput(Double.MIN_VALUE);
        this.frequency2.setMinimumValueForInput(Double.MIN_VALUE);
        this.addParameter(this.phase);
        this.addParameter(this.frequency1);
        this.addParameter(this.frequency2);
        this.addParameter(this.amplitude1);
        this.addParameter(this.amplitude2);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("2*pi");
        this.setDefaultWindow(-4.0, 4.0, -4.0, 4.0);
    }

    public double xValue(double d) {
        double d2 = this.amplitude1.getValue();
        long l = Math.round(this.frequency2.getValue());
        double d3 = this.phase.getValue();
        return d2 * Math.sin((double)l * d + d3);
    }

    public double yValue(double d) {
        double d2 = this.amplitude2.getValue();
        long l = Math.round(this.frequency1.getValue());
        return d2 * Math.cos((double)l * d);
    }
}

