/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import vmm.core.RealParamAnimateable;
import vmm.planecurve.parametric.PlaneCurveParametric;

public class Limacon
extends PlaneCurveParametric {
    private RealParamAnimateable aa;
    private RealParamAnimateable bb;

    public Limacon() {
        this.tResolution.setValueAndDefault(200);
        this.aa = new RealParamAnimateable("aa", 0.5, 1.0, 1.0);
        this.bb = new RealParamAnimateable("bb", 0.5, 2.0, 0.5);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
        this.tmin.setValueAndDefaultFromString("0");
        this.tmax.setValueAndDefaultFromString("2*pi");
        this.setDefaultWindow(-1.25, 1.25, -1.25, 1.25);
    }

    private static double sin(double d) {
        return Math.sin(d);
    }

    private static double cos(double d) {
        return Math.cos(d);
    }

    public double xValue(double d) {
        double d2 = this.aa.getValue();
        double d3 = this.bb.getValue();
        return d2 - (2.0 * d2 * Limacon.cos(d - Math.PI) + d3) * Limacon.cos(d - Math.PI);
    }

    public double yValue(double d) {
        double d2 = this.aa.getValue();
        double d3 = this.bb.getValue();
        return (2.0 * d2 * Limacon.cos(d - Math.PI) + d3) * Limacon.sin(d - Math.PI);
    }
}

