/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import vmm.core.RealParamAnimateable;
import vmm.core.Transform;
import vmm.core.View;
import vmm.planecurve.parametric.ConicSection;
import vmm.planecurve.parametric.PlaneCurveParametric;

public class Hyperbola
extends ConicSection {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.planecurve.parametric.Hyperbola.a", 1.0, 1.0, 1.0);
    private RealParamAnimateable bb = new RealParamAnimateable("vmm.planecurve.parametric.Hyperbola.b", 1.0, 1.0, 1.5);

    public Hyperbola() {
        this.setDefaultWindow(-4.0, 4.0, -4.0, 4.0);
        this.tmin.setValueAndDefault(-2.3);
        this.tmax.setValueAndDefault(2.3);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
    }

    public void doDraw(Graphics2D graphics2D, View view, Transform transform) {
        if (this.points.length == 0) {
            return;
        }
        super.doDraw(graphics2D, view, transform);
        if (view instanceof PlaneCurveParametric.PlaneCurveParametricView && ((PlaneCurveParametric.PlaneCurveParametricView)view).fractionToDraw < 1.0) {
            return;
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-((float)this.points[0].getX()), -((float)this.points[0].getY()));
        for (int i = 1; i < this.points.length; ++i) {
            generalPath.lineTo(-((float)this.points[i].getX()), -((float)this.points[i].getY()));
        }
        graphics2D.draw(generalPath);
    }

    public double xValue(double d) {
        double d2 = Math.exp(d);
        double d3 = (d2 + 1.0 / d2) / 2.0;
        return this.bb.getValue() * d3;
    }

    public double yValue(double d) {
        double d2 = Math.exp(d);
        double d3 = (d2 - 1.0 / d2) / 2.0;
        return this.aa.getValue() * d3;
    }

    public double xDerivativeValue(double d) {
        double d2 = Math.exp(d);
        double d3 = (d2 - 1.0 / d2) / 2.0;
        return this.bb.getValue() * d3;
    }

    public double yDerivativeValue(double d) {
        double d2 = Math.exp(d);
        double d3 = (d2 + 1.0 / d2) / 2.0;
        return this.aa.getValue() * d3;
    }

    public double x2ndDerivativeValue(double d) {
        return this.xValue(d);
    }

    public double y2ndDerivativeValue(double d) {
        return this.yValue(d);
    }

    protected void drawFociAndDirectrix(Graphics2D graphics2D, View view, Transform transform, double d) {
        double d2;
        double d3 = this.bb.getValue();
        double d4 = this.aa.getValue();
        double d5 = d2 = Math.sqrt(Math.abs(d3 * d3 + d4 * d4));
        double d6 = -d2;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 2.0 * Math.abs(d3);
        Color color = graphics2D.getColor();
        double d10 = Math.abs(transform.getXmax() - transform.getXmin());
        double d11 = 4.0 * transform.getPixelWidth();
        graphics2D.setColor(Color.red);
        graphics2D.draw(new Line2D.Double(d5 - d11, d8 - d11, d5 + d11, d8 + d11));
        graphics2D.draw(new Line2D.Double(d5 - d11, d8 + d11, d5 + d11, d8 - d11));
        graphics2D.draw(new Line2D.Double(d6 - d11, d7 - d11, d6 + d11, d7 + d11));
        graphics2D.draw(new Line2D.Double(d6 - d11, d7 + d11, d6 + d11, d7 - d11));
        graphics2D.setColor(Color.blue);
        graphics2D.draw(new Ellipse2D.Double(d6 - d9, d7 - d9, 2.0 * d9, 2.0 * d9));
        if (Double.isNaN(d)) {
            graphics2D.setColor(color);
            return;
        }
        double d12 = this.xValue(d);
        double d13 = this.yValue(d);
        graphics2D.setColor(new Color(0, 150, 0));
        double d14 = this.xDerivativeValue(d);
        double d15 = this.yDerivativeValue(d);
        graphics2D.draw(new Line2D.Double(d12 - d10 * d14, d13 - d10 * d15, d12 + d10 * d14, d13 + d10 * d15));
        graphics2D.setColor(Color.red);
        graphics2D.draw(new Line2D.Double(d12, d13, d6, d7));
        graphics2D.setColor(Color.magenta);
        graphics2D.draw(new Line2D.Double(d12, d13, d5, d8));
        d14 = d12 - d6;
        d15 = d13 - d7;
        double d16 = Math.sqrt(d14 * d14 + d15 * d15);
        double d17 = d6 + d14 / d16 * d9;
        double d18 = d7 + d15 / d16 * d9;
        graphics2D.draw(new Line2D.Double(d12, d13, d17, d18));
        graphics2D.draw(new Line2D.Double(d5, d8, d17, d18));
        view.drawString("F", d5 + 4.0 * transform.getPixelWidth(), d8 + 4.0 * transform.getPixelHeight());
        view.drawString("S", d17 - 10.0 * transform.getPixelWidth(), d18 + 3.0 * transform.getPixelHeight());
        graphics2D.setColor(color);
    }
}

