/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import vmm.core.RealParamAnimateable;
import vmm.core.Transform;
import vmm.core.View;
import vmm.planecurve.parametric.DecoratedCurve;

public class Epizykloide
extends DecoratedCurve {
    private RealParamAnimateable radius;
    private RealParamAnimateable frequ;
    private RealParamAnimateable stick;
    private int pointCount;
    private double r;
    private double fr;
    private double l;
    private double rr;
    private double rrabs;
    private double dt;
    double xa;
    double ya;
    double ftx;
    double fty;
    double fox;
    double foy;
    double tx;
    double ty;
    double nn;
    double ex;
    double ey;
    double aux;

    public Epizykloide() {
        this.tResolution.setValueAndDefault(300);
        this.radius = new RealParamAnimateable("vmm.planecurve.parametric.Epizykloide.radius", 3.0, 1.5, 4.0);
        this.frequ = new RealParamAnimateable("vmm.planecurve.parametric.Epizykloide.frequency", 4.0, 1.0, 8.0);
        this.stick = new RealParamAnimateable("vmm.planecurve.parametric.Epizykloide.stick", 2.0, 0.3, 2.0);
        this.addParameter(this.radius);
        this.addParameter(this.frequ);
        this.addParameter(this.stick);
        this.tmin.setValueAndDefaultFromString("0");
        this.tmax.setValueAndDefaultFromString("2*pi");
        this.tResolution.setValueAndDefaultFromString("500");
        this.setDefaultWindow(-5.0, 5.0, -5.0, 5.0);
        this.pointCount = 6600;
        this.randomSquare = this.fillRandomSquare(this.pointCount);
        this.movingSquare = this.initializeMovingSquare(this.pointCount);
    }

    private void setConstants() {
        this.r = this.radius.getValue();
        this.fr = this.frequ.getValue();
        this.l = this.stick.getValue();
        this.rr = this.r / this.fr;
        this.rrabs = Math.abs(this.rr);
        this.dt = (this.tmax.getValue() - this.tmin.getValue()) / (double)this.tResolution.getValue();
    }

    private static double sin(double d) {
        return Math.sin(d);
    }

    private static double cos(double d) {
        return Math.cos(d);
    }

    public double xValue(double d) {
        this.setConstants();
        return this.l * this.rr * Epizykloide.cos(this.fr * d) + this.r * Epizykloide.cos(d);
    }

    public double yValue(double d) {
        return this.l * this.rr * Epizykloide.sin(this.fr * d) + this.r * Epizykloide.sin(d);
    }

    public View getDefaultView() {
        DecoratedCurve.MMOView mMOView = (DecoratedCurve.MMOView)super.getDefaultView();
        mMOView.simplifyActionMenu = false;
        mMOView.setUseCloud(false);
        return mMOView;
    }

    private void abbreviations(double d) {
        this.xa = this.xValue(d);
        this.ya = this.yValue(d);
        this.ftx = (this.r - this.rr) * Epizykloide.cos(d);
        this.fty = (this.r - this.rr) * Epizykloide.sin(d);
        this.tx = 2.0 * (this.ya - this.fty);
        this.ty = 2.0 * (-this.xa + this.ftx);
        this.ex = Epizykloide.cos(this.fr * d);
        this.ey = Epizykloide.sin(this.fr * d);
        this.aux = Math.abs(this.r - this.rr);
    }

    protected void drawNeededStuff(Graphics2D graphics2D, View view, Transform transform, double d) {
        DecoratedCurve.MMOView mMOView = (DecoratedCurve.MMOView)view;
        Color color = graphics2D.getColor();
        this.abbreviations(d);
        this.fox = this.ftx;
        this.foy = this.fty;
        graphics2D.draw(new Ellipse2D.Double(-this.aux, -this.aux, 2.0 * this.aux, 2.0 * this.aux));
        graphics2D.setColor(Color.red);
        mMOView.setStrokeSizeMultiplier(3);
        graphics2D.draw(new Ellipse2D.Double(this.r * Epizykloide.cos(d) - this.rrabs, this.r * Epizykloide.sin(d) - this.rrabs, 2.0 * this.rrabs, 2.0 * this.rrabs));
        graphics2D.setColor(Color.green);
        graphics2D.draw(new Line2D.Double(this.r * Epizykloide.cos(d), this.r * Epizykloide.sin(d), this.xa, this.ya));
        graphics2D.setColor(new Color(0, 0, 0));
        graphics2D.draw(new Line2D.Double(this.r * Epizykloide.cos(d) + 0.9 * this.l * this.rr * Epizykloide.cos(this.fr * d), this.r * Epizykloide.sin(d) + 0.9 * this.l * this.rr * Epizykloide.sin(this.fr * d), this.xa, this.ya));
        mMOView.setStrokeSizeMultiplier(1);
        graphics2D.setColor(new Color(0, 150, 0));
        graphics2D.draw(new Line2D.Double(this.ftx, this.fty, this.xa, this.ya));
        graphics2D.draw(new Line2D.Double(this.xa - this.tx, this.ya - this.ty, this.xa + this.tx, this.ya + this.ty));
        if (mMOView.getUseCloud()) {
            graphics2D.setColor(Color.blue);
            this.abbreviations(d - this.dt);
            this.movingSquare = this.moveSquare(this.pointCount, this.xa, this.ya, this.ex, this.ey, 2.0 * this.r);
            mMOView.drawPixels(this.movingSquare, 0, this.pointCount);
            this.abbreviations(d + this.dt);
            this.movingSquare = this.moveSquare(this.pointCount, this.xa, this.ya, this.ex, this.ey, 2.0 * this.r);
            mMOView.drawPixels(this.movingSquare, 0, this.pointCount);
        }
        graphics2D.setColor(color);
    }
}

