/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import vmm.core.RealParamAnimateable;
import vmm.core.Transform;
import vmm.core.View;
import vmm.planecurve.parametric.ConicSection;

public class Ellipse
extends ConicSection {
    private RealParamAnimateable verticalRadius = new RealParamAnimateable("vmm.planecurve.parametric.Ellipse.VerticalRadius", 2.0, 1.0, 3.0);
    private RealParamAnimateable horizontalRadius = new RealParamAnimateable("vmm.planecurve.parametric.Ellipse.HorizontalRadius", 3.0, 5.0, 1.0);

    public Ellipse() {
        this.setDefaultWindow(-6.5, 6.5, -6.5, 6.5);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("2 * pi");
        this.addParameter(this.verticalRadius);
        this.addParameter(this.horizontalRadius);
    }

    public double xValue(double d) {
        return this.horizontalRadius.getValue() * Math.cos(d);
    }

    public double yValue(double d) {
        return this.verticalRadius.getValue() * Math.sin(d);
    }

    public double xDerivativeValue(double d) {
        return -this.horizontalRadius.getValue() * Math.sin(d);
    }

    public double yDerivativeValue(double d) {
        return this.verticalRadius.getValue() * Math.cos(d);
    }

    public double x2ndDerivativeValue(double d) {
        return -this.horizontalRadius.getValue() * Math.cos(d);
    }

    public double y2ndDerivativeValue(double d) {
        return -this.verticalRadius.getValue() * Math.sin(d);
    }

    protected void drawFociAndDirectrix(Graphics2D graphics2D, View view, Transform transform, double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7 = this.horizontalRadius.getValue();
        double d8 = this.verticalRadius.getValue();
        double d9 = Math.sqrt(Math.abs(d7 * d7 - d8 * d8));
        if (d7 * d7 > d8 * d8) {
            d6 = d9;
            d5 = -d9;
            d4 = 0.0;
            d3 = 0.0;
            d2 = 2.0 * Math.abs(d7);
        } else {
            d3 = d9;
            d4 = -d9;
            d5 = 0.0;
            d6 = 0.0;
            d2 = 2.0 * Math.abs(d8);
        }
        Color color = graphics2D.getColor();
        double d10 = Math.abs(transform.getXmax() - transform.getXmin());
        double d11 = 4.0 * transform.getPixelWidth();
        graphics2D.setColor(Color.red);
        graphics2D.draw(new Line2D.Double(d6 - d11, d3 - d11, d6 + d11, d3 + d11));
        graphics2D.draw(new Line2D.Double(d6 - d11, d3 + d11, d6 + d11, d3 - d11));
        graphics2D.draw(new Line2D.Double(d5 - d11, d4 - d11, d5 + d11, d4 + d11));
        graphics2D.draw(new Line2D.Double(d5 - d11, d4 + d11, d5 + d11, d4 - d11));
        graphics2D.setColor(Color.blue);
        graphics2D.draw(new Ellipse2D.Double(d5 - d2, d4 - d2, 2.0 * d2, 2.0 * d2));
        if (Double.isNaN(d)) {
            graphics2D.setColor(color);
            return;
        }
        double d12 = this.xValue(d);
        double d13 = this.yValue(d);
        graphics2D.setColor(new Color(0, 150, 0));
        double d14 = this.xDerivativeValue(d);
        double d15 = this.yDerivativeValue(d);
        graphics2D.draw(new Line2D.Double(d12 - d10 * d14, d13 - d10 * d15, d12 + d10 * d14, d13 + d10 * d15));
        graphics2D.setColor(Color.red);
        graphics2D.draw(new Line2D.Double(d12, d13, d5, d4));
        graphics2D.setColor(Color.magenta);
        graphics2D.draw(new Line2D.Double(d12, d13, d6, d3));
        d14 = d12 - d5;
        d15 = d13 - d4;
        double d16 = Math.sqrt(d14 * d14 + d15 * d15);
        double d17 = d5 + d14 / d16 * d2;
        double d18 = d4 + d15 / d16 * d2;
        graphics2D.draw(new Line2D.Double(d12, d13, d17, d18));
        graphics2D.draw(new Line2D.Double(d6, d3, d17, d18));
        view.drawString("F", d6 + 4.0 * transform.getPixelWidth(), d3 + 4.0 * transform.getPixelHeight());
        view.drawString("S", d17 + 3.0 * transform.getPixelWidth(), d18 + 2.0 * transform.getPixelHeight());
        graphics2D.setColor(color);
    }
}

