/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import vmm.core.Transform;
import vmm.core.View;
import vmm.planecurve.parametric.DecoratedCurve;

public class Deltoid
extends DecoratedCurve {
    public Deltoid() {
        this.tResolution.setValueAndDefault(250);
        this.tmin.setValueAndDefaultFromString("0");
        this.tmax.setValueAndDefaultFromString("2*pi");
        this.setDefaultWindow(-4.5, 4.5, -4.5, 4.5);
    }

    private static double sin(double d) {
        return Math.sin(d);
    }

    private static double cos(double d) {
        return Math.cos(d);
    }

    public double xValue(double d) {
        return 2.0 * Deltoid.cos(d) + Deltoid.cos(2.0 * d);
    }

    public double yValue(double d) {
        return 2.0 * Deltoid.sin(d) - Deltoid.sin(2.0 * d);
    }

    public double xDerivativeValue(double d) {
        return -2.0 * Deltoid.sin(d) - 2.0 * Deltoid.sin(2.0 * d);
    }

    public double yDerivativeValue(double d) {
        return 2.0 * Deltoid.cos(d) - 2.0 * Deltoid.cos(2.0 * d);
    }

    protected void drawNeededStuff(Graphics2D graphics2D, View view, Transform transform, double d) {
        DecoratedCurve.MMOView mMOView = (DecoratedCurve.MMOView)view;
        Color color = graphics2D.getColor();
        this.setStrokeSize(3);
        double d2 = this.xValue(d);
        double d3 = this.yValue(d);
        double d4 = this.xDerivativeValue(d);
        double d5 = this.yDerivativeValue(d);
        double d6 = d4 / Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = d5 / Math.sqrt(d4 * d4 + d5 * d5);
        graphics2D.setColor(Color.blue);
        mMOView.setStrokeSizeMultiplier(1);
        graphics2D.draw(new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0));
        graphics2D.setColor(Color.red);
        mMOView.setStrokeSizeMultiplier(3);
        graphics2D.draw(new Ellipse2D.Double(2.0 * Deltoid.cos(d) - 1.0, 2.0 * Deltoid.sin(d) - 1.0, 2.0, 2.0));
        mMOView.setStrokeSizeMultiplier(1);
        graphics2D.setColor(Color.lightGray);
        graphics2D.draw(new Ellipse2D.Double(Deltoid.cos(d) - 2.0, Deltoid.sin(d) - 2.0, 4.0, 4.0));
        graphics2D.draw(new Ellipse2D.Double(Deltoid.cos(d) - 0.07, Deltoid.sin(d) - 0.07, 0.14, 0.14));
        mMOView.setStrokeSizeMultiplier(3);
        graphics2D.setColor(Color.green);
        graphics2D.draw(new Line2D.Double(2.0 * Deltoid.cos(d), 2.0 * Deltoid.sin(d), d2, d3));
        graphics2D.setColor(new Color(0, 0, 0));
        graphics2D.draw(new Line2D.Double(2.0 * Deltoid.cos(d) + 0.9 * Deltoid.cos(2.0 * d), 2.0 * Deltoid.sin(d) - 0.9 * Deltoid.sin(2.0 * d), d2, d3));
        mMOView.setStrokeSizeMultiplier(1);
        graphics2D.setColor(new Color(0, 128, 0));
        graphics2D.draw(new Line2D.Double(Deltoid.cos(d) - 2.0 * d6, Deltoid.sin(d) - 2.0 * d7, Deltoid.cos(d) + 2.0 * d6, Deltoid.sin(d) + 2.0 * d7));
        graphics2D.draw(new Line2D.Double(3.0 * Deltoid.cos(d), 3.0 * Deltoid.sin(d), d2, d3));
        mMOView.setStrokeSizeMultiplier(3);
        graphics2D.setColor(color);
    }
}

