/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import vmm.actions.ActionList;
import vmm.actions.ToggleAction;
import vmm.core.Animation;
import vmm.core.Decoration;
import vmm.core.I18n;
import vmm.core.ThreadedAnimation;
import vmm.core.Transform;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.planecurve.parametric.PlaneCurveParametric;

public abstract class DecoratedCurve
extends PlaneCurveParametric {
    protected Color wantedColor;
    protected int strokeSize;

    public void setWantedColor(Color color) {
        this.wantedColor = color;
    }

    public Color getWantedColor() {
        Color color = this.wantedColor;
        return color;
    }

    public void setStrokeSize(int n) {
        this.strokeSize = n;
    }

    public int getStrokeSize() {
        int n = this.strokeSize;
        return n;
    }

    protected abstract void drawNeededStuff(Graphics2D var1, View var2, Transform var3, double var4);

    public Animation getCreateAnimation(View view) {
        if (!(view instanceof MMOView)) {
            return null;
        }
        final MMOView mMOView = (MMOView)view;
        this.wantedColor = Color.green;
        this.strokeSize = 1;
        return new ThreadedAnimation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runAnimation() {
                NeededStuffDecoration neededStuffDecoration = null;
                try {
                    this.pause(100);
                    neededStuffDecoration = new NeededStuffDecoration();
                    mMOView.addDecoration(neededStuffDecoration);
                    this.pause(35);
                    int n = DecoratedCurve.this.tResolution.getValue();
                    double d = DecoratedCurve.this.tmin.getValue();
                    double d2 = (DecoratedCurve.this.tmax.getValue() - d) / (double)n;
                    for (int i = 0; i < 2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            mMOView.curveColor = DecoratedCurve.this.wantedColor;
                            neededStuffDecoration.setT(d + (double)j * d2, j);
                            this.pause(35);
                        }
                    }
                }
                finally {
                    mMOView.fractionToDraw = 1.0;
                    mMOView.curveColor = null;
                    if (neededStuffDecoration != null) {
                        mMOView.removeDecoration(neededStuffDecoration);
                    }
                    mMOView.forceRedraw();
                }
            }
        };
    }

    public void doDraw(Graphics2D graphics2D, View view, Transform transform) {
        if (this.points.length == 0) {
            return;
        }
        int n = this.points.length;
        if (view instanceof PlaneCurveParametric.PlaneCurveParametricView) {
            double d = ((PlaneCurveParametric.PlaneCurveParametricView)view).fractionToDraw;
            if (d >= 0.0 && d < 1.0) {
                n = (int)(d * (double)n);
            }
            if (n == 0) {
                n = 1;
            }
        }
        Color color = null;
        if (view instanceof MMOView && ((MMOView)view).curveColor != null) {
            color = graphics2D.getColor();
            graphics2D.setColor(((MMOView)view).curveColor);
            view.setStrokeSizeMultiplier(this.strokeSize);
        }
        view.drawCurve(this.points, n);
        if (color != null) {
            graphics2D.setColor(color);
        }
    }

    public View getDefaultView() {
        MMOView mMOView = new MMOView();
        mMOView.setShowAxes(true);
        return mMOView;
    }

    public static class MMOView
    extends PlaneCurveParametric.PlaneCurveParametricView {
        Color curveColor = null;
        protected boolean simplifyActionMenu = true;
        @VMMSave
        private boolean useCloud = false;
        protected ToggleAction useCloudToggle = new ToggleAction(I18n.tr("vmm.planecurve.parametric.PlaneCurveParameteric.ToggleUseCloud"), false){

            public void actionPerformed(ActionEvent actionEvent) {
                MMOView.this.setUseCloud(!MMOView.this.useCloud);
            }
        };

        public boolean getUseCloud() {
            return this.useCloud;
        }

        public void setUseCloud(boolean bl) {
            if (bl == this.useCloud) {
                return;
            }
            this.useCloudToggle.setState(bl);
            this.forceRedraw();
            this.useCloud = bl;
        }

        public ActionList getActions() {
            ActionList actionList = super.getActions();
            if (!this.simplifyActionMenu) {
                actionList.add(this.useCloudToggle);
            }
            return actionList;
        }
    }

    private class NeededStuffDecoration
    extends Decoration {
        double t = Double.NaN;
        int i = 0;

        private NeededStuffDecoration() {
        }

        void setT(double d, int n) {
            this.t = d;
            this.i = n;
            this.fireDecorationChangeEvent();
        }

        public void doDraw(Graphics2D graphics2D, View view, Transform transform) {
            DecoratedCurve.this.drawNeededStuff(graphics2D, view, transform, this.t);
            MMOView mMOView = (MMOView)view;
            mMOView.drawCurve(DecoratedCurve.this.points, this.i, DecoratedCurve.this.points.length - 1);
        }
    }
}

