/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import vmm.core.RealParamAnimateable;
import vmm.core.Transform;
import vmm.core.View;
import vmm.planecurve.parametric.DecoratedCurve;

public class Convex
extends DecoratedCurve {
    private RealParamAnimateable aa;
    private RealParamAnimateable bb;
    private RealParamAnimateable cc;
    private RealParamAnimateable dd;
    private RealParamAnimateable ee;
    private RealParamAnimateable ff;
    private RealParamAnimateable phase;
    private double a;
    private double b;
    private double c;
    private double d;
    private double e;
    private double f;
    private double ph;

    public Convex() {
        this.tResolution.setValueAndDefault(300);
        this.aa = new RealParamAnimateable("vmm.planecurve.parametric.Convex.aa", 15.0, 15.0, 15.0);
        this.bb = new RealParamAnimateable("vmm.planecurve.parametric.Convex.bb", 0.0, 0.0, 0.0);
        this.cc = new RealParamAnimateable("vmm.planecurve.parametric.Convex.cc", 0.0, 0.0, 0.0);
        this.dd = new RealParamAnimateable("vmm.planecurve.parametric.Convex.dd", 1.5, 1.5, 0.0);
        this.ee = new RealParamAnimateable("vmm.planecurve.parametric.Convex.ee", 0.0, 0.0, 0.0);
        this.ff = new RealParamAnimateable("vmm.planecurve.parametric.Convex.ff", 0.0, 0.0, 0.6);
        this.phase = new RealParamAnimateable("vmm.planecurve.parametric.Convex.phase", 0.0, 0.0, 0.0);
        this.addParameter(this.phase);
        this.addParameter(this.ff);
        this.addParameter(this.ee);
        this.addParameter(this.dd);
        this.addParameter(this.cc);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
        this.tmin.setValueAndDefaultFromString("0");
        this.tmax.setValueAndDefaultFromString("2*pi");
        this.setDefaultWindow(-18.0, 18.0, -18.0, 18.0);
    }

    private void setConstants() {
        this.a = this.aa.getValue();
        this.b = this.bb.getValue();
        this.c = this.cc.getValue();
        this.d = this.dd.getValue();
        this.e = this.ee.getValue();
        this.f = this.ff.getValue();
        this.ph = this.phase.getValue();
    }

    private static double sin(double d) {
        return Math.sin(d);
    }

    private static double cos(double d) {
        return Math.cos(d);
    }

    private double supportFunction(double d) {
        this.setConstants();
        return this.a + this.b * Convex.cos(d) + this.c * Convex.cos(2.0 * d) + this.d * Convex.cos(3.0 * d) + this.e * Convex.cos(4.0 * d) + this.f * Convex.cos(5.0 * d);
    }

    private double supportDerivative(double d) {
        return -this.b * Convex.sin(d) - 2.0 * this.c * Convex.sin(2.0 * d) - 3.0 * this.d * Convex.sin(3.0 * d) - 4.0 * this.e * Convex.sin(4.0 * d) - 5.0 * this.f * Convex.sin(5.0 * d);
    }

    public double xValue(double d) {
        return this.supportFunction(d) * Convex.cos(d - this.ph) - this.supportDerivative(d) * Convex.sin(d - this.ph);
    }

    public double yValue(double d) {
        return this.supportFunction(d) * Convex.sin(d - this.ph) + this.supportDerivative(d) * Convex.cos(d - this.ph) + this.supportFunction(this.ph - 1.5707963267948966) - this.a;
    }

    protected void drawNeededStuff(Graphics2D graphics2D, View view, Transform transform, double d) {
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.lightGray);
        view.setStrokeSizeMultiplier(6);
        double d2 = this.a * 1.02;
        graphics2D.draw(new Line2D.Double(-40.0, -d2, 40.0, -d2));
        graphics2D.draw(new Line2D.Double(-40.0, d2, 40.0, d2));
        graphics2D.setColor(color);
        view.setStrokeSizeMultiplier(4);
        this.setStrokeSize(4);
        this.setWantedColor(color);
        this.phase.setValue(d);
    }
}

