/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Graphics2D;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm.core.Animation;
import vmm.core.BasicAnimator;
import vmm.core.Decorateable;
import vmm.core.Decoration;
import vmm.core.Parameterizable;
import vmm.core.ThreadedAnimation;
import vmm.core.Transform;
import vmm.core.View;
import vmm.planecurve.parametric.PlaneCurveParametric;

public abstract class ConicSection
extends PlaneCurveParametric {
    protected abstract void drawFociAndDirectrix(Graphics2D var1, View var2, Transform var3, double var4);

    public Animation getCreateAnimation(View view) {
        if (!(view instanceof PlaneCurveParametric.PlaneCurveParametricView)) {
            return null;
        }
        PlaneCurveParametric.PlaneCurveParametricView planeCurveParametricView = (PlaneCurveParametric.PlaneCurveParametricView)view;
        return new ConicAnimation(planeCurveParametricView);
    }

    public BasicAnimator getMorphingAnimation(View view, int n) {
        final BasicAnimator basicAnimator = super.getMorphingAnimation(view, n);
        if (basicAnimator == null) {
            return null;
        }
        Parameterizable parameterizable = view == null ? this : view;
        basicAnimator.addChangeListener(new ChangeListener((Decorateable)((Object)parameterizable)){
            Decoration dec;
            final /* synthetic */ Decorateable val$owner;
            {
                this.val$owner = decorateable;
                this.dec = new FocusDirectrixDecoration();
            }

            public void stateChanged(ChangeEvent changeEvent) {
                if (basicAnimator.isRunning()) {
                    this.val$owner.addDecoration(this.dec);
                } else {
                    this.val$owner.removeDecoration(this.dec);
                }
            }
        });
        return basicAnimator;
    }

    private class FocusDirectrixDecoration
    extends Decoration {
        double t = Double.NaN;

        private FocusDirectrixDecoration() {
        }

        void setT(double d) {
            this.t = d;
            this.fireDecorationChangeEvent();
        }

        public void doDraw(Graphics2D graphics2D, View view, Transform transform) {
            ConicSection.this.drawFociAndDirectrix(graphics2D, view, transform, this.t);
        }
    }

    private final class ConicAnimation
    extends ThreadedAnimation {
        private final PlaneCurveParametric.PlaneCurveParametricView view;

        private ConicAnimation(PlaneCurveParametric.PlaneCurveParametricView planeCurveParametricView) {
            this.view = planeCurveParametricView;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runAnimation() {
            FocusDirectrixDecoration focusDirectrixDecoration = null;
            try {
                int n;
                for (n = 0; n < 50; ++n) {
                    this.view.fractionToDraw = (double)n / 50.0;
                    this.view.forceRedraw();
                    this.pause(20);
                }
                this.view.fractionToDraw = 1.0;
                focusDirectrixDecoration = new FocusDirectrixDecoration();
                this.view.addDecoration(focusDirectrixDecoration);
                this.pause(200);
                n = ConicSection.this.tResolution.getValue();
                double d = ConicSection.this.tmin.getValue();
                double d2 = (ConicSection.this.tmax.getValue() - d) / (double)n;
                for (int i = 0; i < 10; ++i) {
                    for (int j = 0; j <= n; ++j) {
                        focusDirectrixDecoration.setT(d + (double)j * d2);
                        this.pause(35);
                    }
                    this.pause(300);
                }
                this.view.fractionToDraw = 1.0;
            }
            catch (Throwable throwable) {
                this.view.fractionToDraw = 1.0;
                this.view.forceRedraw();
                if (focusDirectrixDecoration != null) {
                    this.view.removeDecoration(focusDirectrixDecoration);
                }
                throw throwable;
            }
            this.view.forceRedraw();
            if (focusDirectrixDecoration != null) {
                this.view.removeDecoration(focusDirectrixDecoration);
            }
        }
    }
}

