/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import vmm.core.RealParamAnimateable;
import vmm.core.Transform;
import vmm.core.View;
import vmm.planecurve.parametric.DecoratedCurve;

public class Conchoid
extends DecoratedCurve {
    private RealParamAnimateable aa;
    private RealParamAnimateable bb;
    double AA;
    double BB;
    private int pointCount;
    double xa;
    double ya;
    double xb;
    double yb;
    double tx;
    double ty;
    double m;
    double rotx;
    double roty;
    double nn;
    double dt;
    double ex;
    double ey;

    public Conchoid() {
        this.tResolution.setValueAndDefault(400);
        this.aa = new RealParamAnimateable("vmm.planecurve.parametric.Conchoid.aa", 2.0, 0.0, 4.0);
        this.bb = new RealParamAnimateable("vmm.planecurve.parametric.Conchoid.bb", 1.0, 1.0, 1.0);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
        this.tmin.setValueAndDefaultFromString("-pi/2 + 0.000001");
        this.tmax.setValueAndDefaultFromString("3*pi/2 - 0.000001");
        this.setDefaultWindow(-5.0, 5.0, -4.0, 5.0);
        this.pointCount = 12000;
        this.randomSquare = this.fillRandomSquare(this.pointCount);
        this.movingSquare = this.initializeMovingSquare(this.pointCount);
    }

    public double xValue(double d) {
        this.AA = this.aa.getValue();
        this.BB = this.bb.getValue();
        double d2 = this.AA + this.BB / Math.cos(d);
        return d2 * Math.sin(d);
    }

    public double yValue(double d) {
        double d2 = this.AA + this.BB / Math.cos(d);
        return d2 * Math.cos(d);
    }

    public View getDefaultView() {
        DecoratedCurve.MMOView mMOView = (DecoratedCurve.MMOView)super.getDefaultView();
        mMOView.simplifyActionMenu = false;
        mMOView.setUseCloud(false);
        return mMOView;
    }

    private void abbreviations(double d) {
        this.xa = this.xValue(d);
        this.ya = this.yValue(d);
        this.m = this.xa / this.ya;
        this.rotx = this.BB * this.m;
        this.roty = -this.rotx * this.m;
        this.tx = -(this.roty - this.ya);
        this.ty = this.rotx - this.xa;
        this.ex = this.xa - this.rotx;
        this.ey = this.ya - this.BB;
        this.dt = (this.tmax.getValue() - this.tmin.getValue()) / (double)this.tResolution.getValue();
    }

    protected void drawNeededStuff(Graphics2D graphics2D, View view, Transform transform, double d) {
        DecoratedCurve.MMOView mMOView = (DecoratedCurve.MMOView)view;
        this.setWantedColor(Color.green);
        this.setStrokeSize(3);
        this.abbreviations(d);
        mMOView.setStrokeSizeMultiplier(4);
        graphics2D.setColor(Color.green);
        graphics2D.draw(new Line2D.Double(this.xa, this.ya, this.BB * this.m, this.BB));
        mMOView.setStrokeSizeMultiplier(1);
        graphics2D.setColor(Color.red);
        graphics2D.draw(new Line2D.Double(-20.0, this.BB, 20.0, this.BB));
        graphics2D.setColor(Color.blue);
        if (this.ya > this.BB) {
            graphics2D.draw(new Line2D.Double(0.0, 0.0, this.BB * this.m, this.BB));
        } else if (this.ya > 0.0) {
            graphics2D.draw(new Line2D.Double(0.0, 0.0, this.xa, this.ya));
        }
        if (mMOView.getUseCloud()) {
            graphics2D.draw(new Line2D.Double(this.rotx, this.roty, this.xa, this.ya));
            graphics2D.draw(new Line2D.Double(this.xa + this.tx, this.ya + this.ty, this.xa - this.tx, this.ya - this.ty));
            graphics2D.draw(new Ellipse2D.Double(this.rotx - 0.03, this.roty - 0.03, 0.06, 0.06));
            graphics2D.setColor(Color.green);
            graphics2D.draw(new Line2D.Double(0.0, 0.0, this.rotx, this.roty));
            graphics2D.draw(new Line2D.Double(this.rotx, this.roty, this.rotx, this.BB));
            graphics2D.setColor(Color.blue);
            this.abbreviations(d - this.dt);
            this.movingSquare = this.moveSquare(this.pointCount, this.xa, this.ya, this.ex, this.ey, 3.0 * this.BB);
            mMOView.drawPixels(this.movingSquare, 0, this.pointCount);
            this.abbreviations(d + this.dt);
            this.movingSquare = this.moveSquare(this.pointCount, this.xa, this.ya, this.ex, this.ey, 3.0 * this.BB);
            mMOView.drawPixels(this.movingSquare, 0, this.pointCount);
        }
    }
}

