/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import vmm.core.RealParamAnimateable;
import vmm.core.Transform;
import vmm.core.View;
import vmm.planecurve.parametric.DecoratedCurve;

public class Cissoid
extends DecoratedCurve {
    private RealParamAnimateable aa;
    private int pointCount;
    double a;
    double xa;
    double ya;
    double xco;
    double yco;
    double aux;
    double rotx;
    double roty;
    double tx;
    double ty;
    double nn;
    double ex;
    double ey;
    double dt;

    public Cissoid() {
        this.tResolution.setValueAndDefault(395);
        this.aa = new RealParamAnimateable("aa", 1.0, 2.0, 0.5);
        this.addParameter(this.aa);
        this.tmin.setValueAndDefault(-4.5);
        this.tmax.setValueAndDefaultFromString("4.5");
        this.setDefaultWindow(-4.0, 4.0, -4.0, 4.0);
        this.pointCount = 12000;
        this.randomSquare = this.fillRandomSquare(this.pointCount);
        this.movingSquare = this.initializeMovingSquare(this.pointCount);
    }

    public double xValue(double d) {
        return d * this.yValue(d);
    }

    public double yValue(double d) {
        this.a = this.aa.getValue();
        return 2.0 * this.a * d * d / (1.0 + d * d);
    }

    public View getDefaultView() {
        DecoratedCurve.MMOView mMOView = (DecoratedCurve.MMOView)super.getDefaultView();
        mMOView.simplifyActionMenu = false;
        mMOView.setUseCloud(false);
        return mMOView;
    }

    private void abbreviations(double d) {
        this.a = this.aa.getValue();
        this.xa = this.xValue(d);
        this.ya = this.yValue(d);
        this.aux = Math.sqrt(this.ya * (2.0 * this.a - this.ya));
        this.xco = this.xa - Math.signum(this.xa) * this.aux;
        this.yco = 2.0 * this.ya - this.a;
        this.rotx = this.xa + Math.signum(this.xa) * this.aux;
        this.roty = -this.a - this.rotx * this.xco / (this.yco + this.a);
        this.ex = this.xco - this.rotx;
        this.ey = this.yco - this.a;
        this.tx = -this.roty + this.ya;
        this.ty = this.rotx - this.xa;
        this.dt = (this.tmax.getValue() - this.tmin.getValue()) / (double)this.tResolution.getValue();
    }

    protected void drawNeededStuff(Graphics2D graphics2D, View view, Transform transform, double d) {
        DecoratedCurve.MMOView mMOView = (DecoratedCurve.MMOView)view;
        this.setStrokeSize(2);
        Color color = graphics2D.getColor();
        this.abbreviations(d);
        graphics2D.setColor(Color.red);
        mMOView.setStrokeSizeMultiplier(1);
        graphics2D.draw(new Line2D.Double(-10.0, this.a, 10.0, this.a));
        graphics2D.draw(new Line2D.Double(0.0, -this.a, -10.0 * this.xco / (this.yco + this.a), -10.0));
        mMOView.setStrokeSizeMultiplier(3);
        graphics2D.draw(new Line2D.Double(0.0, -this.a, this.xco, this.yco));
        graphics2D.draw(new Line2D.Double(this.xco, this.yco, this.rotx, this.a));
        mMOView.setStrokeSizeMultiplier(2);
        graphics2D.draw(new Ellipse2D.Double(this.rotx - 0.04, this.a - 0.04, 0.08, 0.08));
        graphics2D.draw(new Ellipse2D.Double(-0.06, -this.a - 0.06, 0.12, 0.12));
        graphics2D.setColor(Color.green);
        graphics2D.draw(new Ellipse2D.Double(this.xa - 0.06, this.ya - 0.06, 0.12, 0.12));
        if (mMOView.getUseCloud()) {
            mMOView.setStrokeSizeMultiplier(1);
            graphics2D.draw(new Line2D.Double(this.rotx, this.roty, this.rotx, this.a));
            graphics2D.draw(new Line2D.Double(this.rotx, this.roty, 0.0, -this.a));
            graphics2D.setColor(Color.blue);
            graphics2D.draw(new Line2D.Double(this.rotx, this.roty, this.xa, this.ya));
            graphics2D.draw(new Line2D.Double(this.xa + this.tx, this.ya + this.ty, this.xa - this.tx, this.ya - this.ty));
            graphics2D.draw(new Ellipse2D.Double(this.rotx - 0.06, this.roty - 0.06, 0.12, 0.12));
            this.abbreviations(d - this.dt);
            this.movingSquare = this.moveSquare(this.pointCount, this.xa, this.ya, this.ex, this.ey, 3.0 * this.a);
            mMOView.drawPixels(this.movingSquare, 0, this.pointCount);
            this.abbreviations(d + this.dt);
            this.movingSquare = this.moveSquare(this.pointCount, this.xa, this.ya, this.ex, this.ey, 3.0 * this.a);
            mMOView.drawPixels(this.movingSquare, 0, this.pointCount);
        }
        graphics2D.setColor(color);
    }
}

