/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import vmm.core.I18n;
import vmm.core.RealParamAnimateable;
import vmm.core.Transform;
import vmm.core.View;
import vmm.planecurve.parametric.DecoratedCurve;

public class Circle
extends DecoratedCurve {
    private RealParamAnimateable radius = new RealParamAnimateable("vmm.planecurve.parametric.Circle.Radius", 3.0, 1.0, 5.0);
    private int pointCount;

    public Circle() {
        this.radius.setMinimumValueForInput(Double.MIN_VALUE);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("2 * pi");
        this.tResolution.setValueAndDefaultFromString("400");
        this.addParameter(this.radius);
        this.pointCount = 6600;
        this.randomSquare = this.fillRandomSquare(this.pointCount);
        this.movingSquare = this.initializeMovingSquare(this.pointCount);
    }

    public double xValue(double d) {
        return this.radius.getValue() * Math.cos(d);
    }

    public double yValue(double d) {
        return this.radius.getValue() * Math.sin(d);
    }

    public double xDerivativeValue(double d) {
        return -this.radius.getValue() * Math.sin(d);
    }

    public double yDerivativeValue(double d) {
        return this.radius.getValue() * Math.cos(d);
    }

    public double x2ndDerivativeValue(double d) {
        return -this.radius.getValue() * Math.cos(d);
    }

    public double y2ndDerivativeValue(double d) {
        return -this.radius.getValue() * Math.sin(d);
    }

    public View getDefaultView() {
        class CircleView
        extends DecoratedCurve.MMOView {
            CircleView() {
                this.setShowAxes(true);
                this.simplifyActionMenu = false;
                this.setUseCloud(false);
                this.useCloudToggle.putValue("Name", I18n.tr("vmm.planecurve.parametric.PlaneCurveParameteric.ToggleUseCloudForCircle"));
            }
        }
        return new CircleView();
    }

    protected void drawNeededStuff(Graphics2D graphics2D, View view, Transform transform, double d) {
        DecoratedCurve.MMOView mMOView = (DecoratedCurve.MMOView)view;
        Color color = graphics2D.getColor();
        this.setWantedColor(color);
        double d2 = this.xValue(d);
        double d3 = this.yValue(d);
        double d4 = this.radius.getValue();
        mMOView.setStrokeSizeMultiplier(2);
        graphics2D.setColor(Color.blue);
        graphics2D.draw(new Line2D.Double(-d4, 0.0, d4, 0.0));
        graphics2D.draw(new Line2D.Double(0.0, 0.0, 0.0, -d4 * Math.signum(d3)));
        graphics2D.setColor(Color.red);
        graphics2D.draw(new Line2D.Double(-d4, 0.0, d2, d3));
        graphics2D.draw(new Line2D.Double(d2, d3, d4, 0.0));
        mMOView.setStrokeSizeMultiplier(1);
        graphics2D.draw(new Line2D.Double(d2, d3, 0.0, -d4 * Math.signum(d3)));
        if (mMOView.getUseCloud()) {
            graphics2D.setColor(Color.blue);
            graphics2D.draw(new Line2D.Double(d2, d3, -d2 / 5.0, -d3 / 5.0));
        }
        graphics2D.setColor(color);
    }
}

