/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import vmm.core.RealParamAnimateable;
import vmm.planecurve.parametric.PlaneCurveParametric;

public class Catenary
extends PlaneCurveParametric {
    private RealParamAnimateable aa;

    public Catenary() {
        this.tResolution.setValueAndDefault(395);
        this.aa = new RealParamAnimateable("aa", 1.0, 0.75, 1.5);
        this.addParameter(this.aa);
        this.tmin.setValueAndDefault(-4.0);
        this.tmax.setValueAndDefaultFromString("4");
        this.setDefaultWindow(-5.0, 5.0, -5.0, 5.0);
    }

    private static double cosh(double d) {
        return 0.5 * (Math.exp(d) + Math.exp(-d));
    }

    public double xValue(double d) {
        return d;
    }

    public double yValue(double d) {
        double d2 = this.aa.getValue();
        return d2 * Catenary.cosh(d / d2);
    }
}

