/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import vmm.core.Transform;
import vmm.core.View;
import vmm.planecurve.parametric.DecoratedCurve;

public class Astroid
extends DecoratedCurve {
    public Astroid() {
        this.tResolution.setValueAndDefault(300);
        this.tmin.setValueAndDefaultFromString("0");
        this.tmax.setValueAndDefaultFromString("2*pi");
        this.setDefaultWindow(-1.25, 1.25, -1.25, 1.25);
    }

    private static double Cube(double d) {
        return d * d * d;
    }

    private static double sin(double d) {
        return Math.sin(d);
    }

    private static double cos(double d) {
        return Math.cos(d);
    }

    public double xValue(double d) {
        return Astroid.Cube(Astroid.cos(d));
    }

    public double yValue(double d) {
        return Astroid.Cube(Astroid.sin(d));
    }

    protected void drawNeededStuff(Graphics2D graphics2D, View view, Transform transform, double d) {
        Color color = graphics2D.getColor();
        this.setWantedColor(Color.RED);
        this.setStrokeSize(3);
        double d2 = Astroid.Cube(Astroid.cos(d));
        double d3 = Astroid.Cube(Astroid.sin(d));
        double d4 = -3.0 * Astroid.cos(d) * Astroid.cos(d) * Astroid.sin(d);
        double d5 = 3.0 * Astroid.sin(d) * Astroid.sin(d) * Astroid.cos(d);
        double d6 = d4 / d5;
        graphics2D.setColor(Color.red);
        graphics2D.draw(new Line2D.Double(0.0, this.yValue(d) - this.xValue(d) * d5 / d4, this.xValue(d) - this.yValue(d) * d4 / d5, 0.0));
        graphics2D.draw(new Line2D.Double(d2 + 0.02, d3 + 0.02, d2 - 0.02, d3 - 0.02));
        graphics2D.draw(new Line2D.Double(d2 - 0.02, d3 + 0.02, d2 + 0.02, d3 - 0.02));
        graphics2D.setColor(Color.green);
        view.setStrokeSizeMultiplier(1);
        graphics2D.draw(new Line2D.Double(-10.0, -10.0, 10.0, 10.0));
        graphics2D.draw(new Line2D.Double(-10.0, 10.0, 10.0, -10.0));
        graphics2D.draw(new Line2D.Double(1.0 / (d6 - 1.0) * (d2 * d6 + d3), -1.0 / (d6 - 1.0) * (d2 * d6 + d3), 1.0 / (d6 + 1.0) * (d3 + d6 * d2), 1.0 / (d6 + 1.0) * (d3 + d6 * d2)));
        view.setStrokeSizeMultiplier(3);
        graphics2D.setColor(color);
    }
}

