/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import vmm.core.RealParamAnimateable;
import vmm.planecurve.parametric.PlaneCurveParametric;

public class ArchimedeanSpiral
extends PlaneCurveParametric {
    private RealParamAnimateable aa;

    public ArchimedeanSpiral() {
        this.tResolution.setValueAndDefault(500);
        this.aa = new RealParamAnimateable("aa", 1.0, -1.0, 1.25);
        this.addParameter(this.aa);
        this.tmin.setValueAndDefault(0.2);
        this.tmax.setValueAndDefaultFromString("7*pi");
        this.setDefaultWindow(-25.0, 25.0, -25.0, 25.0);
    }

    private double ExpAAlog(double d) {
        double d2 = this.aa.getValue();
        return Math.exp(d2 * Math.log(d));
    }

    public double xValue(double d) {
        return this.ExpAAlog(d) * Math.cos(d);
    }

    public double yValue(double d) {
        return this.ExpAAlog(d) * Math.sin(d);
    }
}

